/*
 * Decompiled with CFR 0.152.
 */
package org.bboxdb.tools.converter.tuple;

import java.util.Arrays;
import java.util.List;
import org.bboxdb.tools.converter.tuple.ADSBTupleBuilder2D;
import org.bboxdb.tools.converter.tuple.ADSBTupleBuilder3D;
import org.bboxdb.tools.converter.tuple.AuTransportGeoJSONTupleBuilder;
import org.bboxdb.tools.converter.tuple.BerlinModPlayerTupleBuilder;
import org.bboxdb.tools.converter.tuple.BerlinModTupleBuilder;
import org.bboxdb.tools.converter.tuple.Forex1DBuilder;
import org.bboxdb.tools.converter.tuple.Forex2DBuilder;
import org.bboxdb.tools.converter.tuple.GeoJSONTupleBuilder;
import org.bboxdb.tools.converter.tuple.NariDynamicBuilder;
import org.bboxdb.tools.converter.tuple.RomeTaxiPointBuilder;
import org.bboxdb.tools.converter.tuple.RomeTaxiRangeBuilder;
import org.bboxdb.tools.converter.tuple.SyntheticDataStreamTupleBuilder;
import org.bboxdb.tools.converter.tuple.SyntheticTupleBuilder;
import org.bboxdb.tools.converter.tuple.TPCHLineitemPointBuilder;
import org.bboxdb.tools.converter.tuple.TPCHLineitemRangeBuilder;
import org.bboxdb.tools.converter.tuple.TPCHOrderPointBuilder;
import org.bboxdb.tools.converter.tuple.TupleBuilder;
import org.bboxdb.tools.converter.tuple.YellowTaxiPointTupleBuilder;
import org.bboxdb.tools.converter.tuple.YellowTaxiRangeTupleBuilder;

public class TupleBuilderFactory {
    public static final List<String> ALL_BUILDER = Arrays.asList("geojson", "synthetic", "synthetic_stream", "yellowtaxi_point", "yellowtaxi_range", "tpch_lineitem_point", "tpch_lineitem_range", "tpch_order_point", "rome_taxi_point", "rome_taxi_range", "nari_dynamic", "forex_1d", "forex_2d", "berlinmod_player", "berlinmod", "adsb", "adsb3d", "au_transport");

    public static TupleBuilder getBuilderForFormat(String format) {
        switch (format) {
            case "geojson": {
                return new GeoJSONTupleBuilder();
            }
            case "synthetic": {
                return new SyntheticTupleBuilder();
            }
            case "synthetic_stream": {
                return new SyntheticDataStreamTupleBuilder();
            }
            case "yellowtaxi_point": {
                return new YellowTaxiPointTupleBuilder();
            }
            case "yellowtaxi_range": {
                return new YellowTaxiRangeTupleBuilder();
            }
            case "tpch_lineitem_point": {
                return new TPCHLineitemPointBuilder();
            }
            case "tpch_lineitem_range": {
                return new TPCHLineitemRangeBuilder();
            }
            case "tpch_order_point": {
                return new TPCHOrderPointBuilder();
            }
            case "rome_taxi_point": {
                return new RomeTaxiPointBuilder();
            }
            case "rome_taxi_range": {
                return new RomeTaxiRangeBuilder();
            }
            case "nari_dynamic": {
                return new NariDynamicBuilder();
            }
            case "forex_1d": {
                return new Forex1DBuilder();
            }
            case "forex_2d": {
                return new Forex2DBuilder();
            }
            case "berlinmod_player": {
                return new BerlinModPlayerTupleBuilder();
            }
            case "berlinmod": {
                return new BerlinModTupleBuilder();
            }
            case "adsb": {
                return new ADSBTupleBuilder2D();
            }
            case "adsb3d": {
                return new ADSBTupleBuilder3D();
            }
            case "au_transport": {
                return new AuTransportGeoJSONTupleBuilder();
            }
        }
        throw new RuntimeException("Unknown format: " + format);
    }

    public static class Name {
        public static final String YELLOWTAXI_POINT = "yellowtaxi_point";
        public static final String YELLOWTAXI_RANGE = "yellowtaxi_range";
        public static final String GEOJSON = "geojson";
        public static final String SYNTHETIC = "synthetic";
        public static final String SYNTHETIC_STREAM = "synthetic_stream";
        public static final String TPCH_LINEITEM_POINT = "tpch_lineitem_point";
        public static final String TPCH_LINEITEM_RANGE = "tpch_lineitem_range";
        public static final String TPCH_ORDER_POINT = "tpch_order_point";
        public static final String ROME_TAXI_POINT = "rome_taxi_point";
        public static final String ROME_TAXI_RANGE = "rome_taxi_range";
        public static final String NARI_DYNAMIC = "nari_dynamic";
        public static final String FOREX_1D = "forex_1d";
        public static final String FOREX_2D = "forex_2d";
        public static final String BERLINMOD_PLAYER = "berlinmod_player";
        public static final String BERLINMOD = "berlinmod";
        public static final String ADSB_2D = "adsb";
        public static final String ADSB_3D = "adsb3d";
        public static final String AUTRANSPORT = "au_transport";
    }
}

