/*
 * Decompiled with CFR 0.152.
 */
package org.bboxdb.tools.converter.tuple;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.bboxdb.commons.math.Hyperrectangle;
import org.bboxdb.storage.entity.Tuple;
import org.bboxdb.tools.converter.tuple.TupleBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YellowTaxiPointTupleBuilder
extends TupleBuilder {
    protected final SimpleDateFormat dateParser = new SimpleDateFormat("yyyy-mm-dd HH:mm:ss");
    private static final Logger logger = LoggerFactory.getLogger(YellowTaxiPointTupleBuilder.class);

    @Override
    public Tuple buildTuple(String valueData, String keyData) {
        try {
            String[] data = valueData.split(",");
            if ("VendorID".equals(data[0])) {
                return null;
            }
            Date tripStart = this.dateParser.parse(data[1]);
            double longBegin = Double.parseDouble(data[5]);
            double latBegin = Double.parseDouble(data[6]);
            Hyperrectangle boundingBox = new Hyperrectangle(new Double[]{longBegin, longBegin, latBegin, latBegin, tripStart.getTime(), tripStart.getTime()});
            return new Tuple(keyData, boundingBox.enlargeByAmount(this.boxPadding), valueData.getBytes());
        }
        catch (NumberFormatException | ParseException e) {
            logger.error("Unabe to parse: ", (Throwable)e);
            return null;
        }
    }
}

