/*
 * Decompiled with CFR 0.152.
 */
package org.bboxdb.tools.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.RootPaneContainer;
import javax.swing.border.BevelBorder;
import org.bboxdb.distribution.membership.BBoxDBInstance;
import org.bboxdb.tools.gui.BBoxDBInstanceTableModel;
import org.bboxdb.tools.gui.GuiModel;
import org.bboxdb.tools.gui.InstanceTableRenderer;
import org.bboxdb.tools.gui.views.View;
import org.bboxdb.tools.gui.views.ViewMode;
import org.bboxdb.tools.gui.views.query.QueryView;
import org.bboxdb.tools.gui.views.regiondepended.osm.OSMView;
import org.bboxdb.tools.gui.views.regiondepended.tree.TreeView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BBoxDBGui {
    private JFrame mainframe;
    private JComponent mainPanel;
    private JMenuBar menuBar;
    private JLabel statusLabel;
    private BBoxDBInstanceTableModel tableModel;
    private GuiModel guiModel;
    private ViewMode viewMode = ViewMode.TREE_MODE;
    private static final Logger logger = LoggerFactory.getLogger(BBoxDBGui.class);

    public BBoxDBGui(GuiModel guiModel) {
        this.guiModel = guiModel;
    }

    public void run() {
        this.mainframe = new JFrame("BBoxDB - GUI Client");
        this.setupMenu();
        this.mainPanel = this.buildSplitPane();
        this.updateMainPanel();
        this.tableModel = this.getTableModel();
        JTable table = new JTable(this.tableModel);
        table.getColumnModel().getColumn(0).setMaxWidth(40);
        table.getColumnModel().getColumn(2).setMinWidth(100);
        table.getColumnModel().getColumn(2).setMaxWidth(100);
        table.setDefaultRenderer(Object.class, new InstanceTableRenderer());
        JScrollPane tableScrollPane = new JScrollPane(table);
        Dimension dimension = table.getPreferredSize();
        if (dimension != null) {
            tableScrollPane.setPreferredSize(new Dimension(dimension.width, table.getRowHeight() * 7));
        }
        this.mainframe.setDefaultCloseOperation(3);
        this.mainframe.setLayout(new BorderLayout());
        this.mainframe.add((Component)this.mainPanel, "Center");
        JPanel southPanel = new JPanel();
        southPanel.setLayout(new BorderLayout());
        southPanel.add((Component)tableScrollPane, "Center");
        JPanel statusPanel = new JPanel();
        statusPanel.setBorder(new BevelBorder(1));
        statusPanel.setPreferredSize(new Dimension(southPanel.getWidth(), 20));
        statusPanel.setLayout(new BoxLayout(statusPanel, 0));
        this.statusLabel = new JLabel("");
        this.statusLabel.setHorizontalAlignment(2);
        statusPanel.add(this.statusLabel);
        southPanel.add((Component)statusPanel, "South");
        this.mainframe.add((Component)southPanel, "South");
        this.mainframe.pack();
        this.mainframe.setLocationRelativeTo(null);
        this.mainframe.setVisible(true);
    }

    public void dispose() {
        this.mainframe.dispose();
    }

    private BBoxDBInstanceTableModel getTableModel() {
        List<BBoxDBInstance> bboxDBInstances = this.guiModel.getBBoxDBInstances();
        return new BBoxDBInstanceTableModel(bboxDBInstances, this.guiModel);
    }

    private JSplitPane buildSplitPane() {
        JSplitPane splitPane = new JSplitPane(1);
        splitPane.setLeftComponent(this.getLeftPanel());
        splitPane.setOneTouchExpandable(true);
        splitPane.setDividerLocation(150);
        return splitPane;
    }

    private View getRightPanel() {
        switch (this.viewMode) {
            case TREE_MODE: {
                return new TreeView(this.guiModel);
            }
            case OSM_MODE: {
                return new OSMView(this.guiModel);
            }
            case QUERY_MODE: {
                return new QueryView(this.guiModel);
            }
        }
        throw new IllegalArgumentException("Unknown mode: " + (Object)((Object)this.viewMode));
    }

    private void updateMainPanel() {
        View view = this.getRightPanel();
        JComponent viewPanel = view.getJPanel();
        if (!view.isGroupSelectionNeeded()) {
            this.statusLabel.setText("");
            this.mainframe.remove(this.mainPanel);
            this.mainPanel = viewPanel;
            this.mainframe.add((Component)this.mainPanel, "Center");
            this.mainframe.revalidate();
        } else {
            JSplitPane pane = null;
            if (this.mainPanel instanceof JSplitPane) {
                pane = (JSplitPane)this.mainPanel;
                int oldLocation = pane.getDividerLocation();
                pane.setRightComponent(viewPanel);
                pane.setDividerLocation(oldLocation);
                this.mainframe.revalidate();
            } else {
                pane = this.buildSplitPane();
                pane.setRightComponent(viewPanel);
                this.mainframe.remove(this.mainPanel);
                this.mainframe.add((Component)pane, "Center");
                this.mainPanel = pane;
                this.mainframe.revalidate();
            }
        }
    }

    private JComponent getLeftPanel() {
        DefaultListModel<String> listModel = new DefaultListModel<String>();
        JList distributionGroupList = new JList(listModel);
        this.refreshDistributionGroups(listModel);
        distributionGroupList.setSelectionMode(0);
        distributionGroupList.setSelectedValue(this.guiModel.getDistributionGroup(), true);
        distributionGroupList.addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                this.guiModel.setDistributionGroup((String)distributionGroupList.getSelectedValue());
                this.updateMainPanel();
            }
        });
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add(distributionGroupList, "Center");
        JButton reloadItem = new JButton("Reload");
        reloadItem.addActionListener(e -> {
            this.refreshDistributionGroups(listModel);
            this.updateMainPanel();
        });
        panel.add((Component)reloadItem, "South");
        return panel;
    }

    private void refreshDistributionGroups(DefaultListModel<String> listModel) {
        ArrayList<String> distributionGroups = new ArrayList<String>();
        try {
            distributionGroups.addAll(this.guiModel.getDistributionGroups());
        }
        catch (Exception e) {
            logger.error("Got an exception while loading distribution groups");
        }
        Collections.sort(distributionGroups);
        listModel.clear();
        for (String distributionGroupName : distributionGroups) {
            listModel.addElement(distributionGroupName);
        }
        this.guiModel.setDistributionGroup(null);
        this.guiModel.unregisterTreeChangeListener();
        if (this.statusLabel != null) {
            this.statusLabel.setText("");
        }
    }

    private void setupMenu() {
        this.menuBar = new JMenuBar();
        this.mainframe.setJMenuBar(this.menuBar);
        JMenu menu = new JMenu("File");
        this.menuBar.add(menu);
        JMenuItem screeenshotMode = new JMenuItem("Toggle screenshot mode");
        menu.add(screeenshotMode);
        screeenshotMode.addActionListener(e -> {
            this.guiModel.setScreenshotMode(!this.guiModel.isScreenshotMode());
            this.tableModel.fireTableDataChanged();
        });
        JMenuItem closeItem = new JMenuItem("Close");
        menu.add(closeItem);
        closeItem.addActionListener(e -> System.exit(0));
        JMenu view = new JMenu("View");
        this.menuBar.add(view);
        JMenuItem viewKDTree = new JMenuItem("Tree view");
        view.add(viewKDTree);
        viewKDTree.addActionListener(e -> {
            this.viewMode = ViewMode.TREE_MODE;
            this.updateMainPanel();
        });
        JMenuItem viewKDTreeOsm = new JMenuItem("OpenStreetMap view");
        view.add(viewKDTreeOsm);
        viewKDTreeOsm.addActionListener(e -> {
            this.viewMode = ViewMode.OSM_MODE;
            this.updateMainPanel();
        });
        JMenuItem queryMode = new JMenuItem("Open query view");
        view.add(queryMode);
        queryMode.addActionListener(e -> {
            this.viewMode = ViewMode.QUERY_MODE;
            this.updateMainPanel();
        });
    }

    public void updateView() {
        if (this.tableModel != null) {
            this.tableModel.fireTableDataChanged();
        }
        this.mainframe.repaint();
    }

    public Component getGlassPane() {
        if (this.mainPanel == null) {
            return null;
        }
        RootPaneContainer root = (RootPaneContainer)((Object)this.mainPanel.getTopLevelAncestor());
        if (root == null) {
            return null;
        }
        return root.getGlassPane();
    }

    public JLabel getStatusLabel() {
        return this.statusLabel;
    }
}

