/*
 * Decompiled with CFR 0.152.
 */
package org.bboxdb.tools.gui;

import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.bboxdb.commons.FileSizeHelper;
import org.bboxdb.distribution.membership.BBoxDBInstance;
import org.bboxdb.tools.gui.GuiModel;

final class BBoxDBInstanceTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 8593512480994197794L;
    protected final List<BBoxDBInstance> instances;
    private GuiModel guiModel;

    public BBoxDBInstanceTableModel(List<BBoxDBInstance> distributedInstances, GuiModel guiModel) {
        this.instances = distributedInstances;
        this.guiModel = guiModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        List<BBoxDBInstance> list = this.instances;
        synchronized (list) {
            if (rowIndex > this.instances.size()) {
                return "";
            }
            BBoxDBInstance instance = this.instances.get(rowIndex);
            if (this.instances.size() < rowIndex) {
                return "";
            }
            if (instance == null) {
                return "";
            }
            if (columnIndex == 0) {
                return rowIndex + 1;
            }
            if (columnIndex == 1) {
                if (this.guiModel.isScreenshotMode()) {
                    return "XXX.XXX.XXX.XXX";
                }
                return instance.getIp();
            }
            if (columnIndex == 2) {
                return instance.getPort();
            }
            if (columnIndex == 3) {
                return instance.getVersion();
            }
            if (columnIndex == 4) {
                return instance.getState().getZookeeperValue();
            }
            if (columnIndex == 5) {
                return instance.getCpuCores();
            }
            if (columnIndex == 6) {
                return FileSizeHelper.readableFileSize((long)instance.getMemory());
            }
            if (columnIndex == 7) {
                return instance.getNumberOfStorages();
            }
            if (columnIndex == 8) {
                return FileSizeHelper.readableFileSize((long)instance.getTotalSpace());
            }
            if (columnIndex == 9) {
                return FileSizeHelper.readableFileSize((long)instance.getFreeSpace());
            }
            return "";
        }
    }

    @Override
    public int getRowCount() {
        return this.instances.size();
    }

    @Override
    public int getColumnCount() {
        return 10;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public String getColumnName(int column) {
        if (column == 0) {
            return "Id";
        }
        if (column == 1) {
            return "IP";
        }
        if (column == 2) {
            return "Port";
        }
        if (column == 3) {
            return "Version";
        }
        if (column == 4) {
            return "State";
        }
        if (column == 5) {
            return "CPU cores";
        }
        if (column == 6) {
            return "Memory";
        }
        if (column == 7) {
            return "Storage locations";
        }
        if (column == 8) {
            return "Total disk space";
        }
        if (column == 9) {
            return "Free disk space";
        }
        return "---";
    }
}

