/*
 * Decompiled with CFR 0.152.
 */
package org.bboxdb.tools.gui;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import org.bboxdb.distribution.zookeeper.ZookeeperClient;
import org.bboxdb.distribution.zookeeper.ZookeeperClientFactory;
import org.bboxdb.network.client.BBoxDBCluster;
import org.bboxdb.tools.gui.BBoxDBGui;
import org.bboxdb.tools.gui.GuiModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectDialog {
    private static final String DEFAULT_CLUSTER = "mycluster";
    private static final String DEFAULT_NODE = "newton1:50181";
    protected JTextField hosts;
    protected JTextField clustername;
    protected JFrame mainframe;
    protected static final Logger logger = LoggerFactory.getLogger(ConnectDialog.class);

    public void showDialog() {
        this.mainframe = new JFrame("BBoxDB - Connection Settings");
        this.hosts = new JTextField(DEFAULT_NODE);
        this.clustername = new JTextField(DEFAULT_CLUSTER);
        PanelBuilder builder = this.buildDialog();
        this.mainframe.add(builder.getPanel());
        this.mainframe.pack();
        this.mainframe.setLocationRelativeTo(null);
        this.mainframe.setVisible(true);
    }

    protected PanelBuilder buildDialog() {
        JButton closeButton = new JButton();
        closeButton.setText("Close");
        closeButton.addActionListener(e -> System.exit(0));
        Action connectAction = this.getConnectAction();
        JButton connectButton = new JButton(connectAction);
        connectButton.setText("Connect");
        FormLayout layout = new FormLayout("right:pref, 3dlu, 60dlu", "p, 3dlu, p, 3dlu, p, 9dlu, p");
        PanelBuilder builder = new PanelBuilder(layout);
        builder.setDefaultDialogBorder();
        CellConstraints cc = new CellConstraints();
        builder.addSeparator("Cluster contact point", cc.xyw(1, 1, 3));
        builder.addLabel("Zookeeper Hosts", cc.xy(1, 3));
        builder.add((Component)this.hosts, cc.xy(3, 3));
        builder.addLabel("Clustername", cc.xy(1, 5));
        builder.add((Component)this.clustername, cc.xy(3, 5));
        builder.add((Component)closeButton, cc.xy(1, 7));
        builder.add((Component)connectButton, cc.xy(3, 7));
        return builder;
    }

    protected Action getConnectAction() {
        AbstractAction connectAction = new AbstractAction(){
            private static final long serialVersionUID = 2908534701228350424L;

            @Override
            public void actionPerformed(ActionEvent e) {
                String cluster;
                String guiHosts = ConnectDialog.this.hosts.getText();
                if (guiHosts == null) {
                    return;
                }
                String[] hostList = guiHosts.split(",");
                List<String> zookeeperHosts = Arrays.asList(hostList);
                BBoxDBCluster connection = new BBoxDBCluster(zookeeperHosts, cluster = ConnectDialog.this.clustername.getText());
                boolean connectResult = connection.connect();
                if (!connectResult) {
                    String errorMessage = "Unable to connect to BBoxDB cluster";
                    logger.error("Unable to connect to BBoxDB cluster");
                    JOptionPane.showMessageDialog(new JFrame(), "Unable to connect to BBoxDB cluster", "Unable to connect", 0);
                    System.exit(-1);
                }
                ZookeeperClientFactory.setDefaultZookeeperClient((ZookeeperClient)connection.getZookeeperClient());
                this.showMainDialog(connection);
                ConnectDialog.this.mainframe.dispose();
            }

            protected void showMainDialog(BBoxDBCluster connection) {
                GuiModel guiModel = new GuiModel(connection);
                BBoxDBGui bboxDBGUI = new BBoxDBGui(guiModel);
                guiModel.setBBoxDBGui(bboxDBGUI);
                bboxDBGUI.run();
            }
        };
        return connectAction;
    }
}

