/*
 * Decompiled with CFR 0.152.
 */
package org.bboxdb.tools.gui;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.List;
import java.util.Map;
import org.bboxdb.commons.math.DoubleInterval;
import org.bboxdb.commons.math.Hyperrectangle;
import org.bboxdb.distribution.membership.BBoxDBInstance;
import org.bboxdb.distribution.partitioner.regionsplit.RegionMergeHelper;
import org.bboxdb.distribution.partitioner.regionsplit.RegionSplitHelper;
import org.bboxdb.distribution.region.DistributionRegion;
import org.bboxdb.distribution.zookeeper.DistributionRegionAdapter;
import org.bboxdb.distribution.zookeeper.ZookeeperClientFactory;
import org.bboxdb.distribution.zookeeper.ZookeeperException;
import org.bboxdb.distribution.zookeeper.ZookeeperNotFoundException;
import org.bboxdb.tools.gui.ConnectDialog;
import org.bboxdb.tools.gui.GuiModel;
import org.bboxdb.tools.gui.views.regiondepended.tree.TreeJPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributionRegionComponent {
    public static final int PADDING_LEFT_RIGHT = 15;
    public static final int LEVEL_DISTANCE = 100;
    public final int HEIGHT;
    public static final int WIDTH = 120;
    private final DistributionRegion distributionRegion;
    private int xOffset;
    private int yOffset;
    private final TreeJPanel panel;
    private GuiModel guiModel;
    private int maxChildren;
    private static final Logger logger = LoggerFactory.getLogger(ConnectDialog.class);

    public DistributionRegionComponent(DistributionRegion distributionRegion, TreeJPanel distributionGroupJPanel, GuiModel guiModel, int maxChildren) {
        this.distributionRegion = distributionRegion;
        this.panel = distributionGroupJPanel;
        this.guiModel = guiModel;
        this.maxChildren = maxChildren;
        this.xOffset = this.calculateXOffset(distributionRegion);
        this.yOffset = this.calculateYOffset();
        this.HEIGHT = 40 + distributionRegion.getConveringBox().getDimension() * 15;
    }

    private int calculateXOffset(DistributionRegion region) {
        int offset = this.panel.getRootPosX();
        while (!region.isRootElement()) {
            List children = region.getParent().getDirectChildren();
            int noOfChildren = children.size();
            int silbingsBlockSize = (noOfChildren + 1) * this.levelChildrenDistance(region.getLevel());
            offset -= silbingsBlockSize / 2;
            for (int i = 0; i < children.size(); ++i) {
                offset += this.levelChildrenDistance(region.getLevel());
                if (children.get(i) == region) break;
            }
            region = region.getParent();
        }
        return offset;
    }

    private int levelChildrenDistance(int level) {
        int offsetLastLevel = 135;
        int curentLevel = this.distributionRegion.getTotalLevel() - level - 1;
        return (int)(135.0 * Math.pow(this.maxChildren, curentLevel));
    }

    private void drawParentNodeLine(Graphics2D g) {
        if (this.distributionRegion.isRootElement()) {
            return;
        }
        int parentOffset = this.calculateXOffset(this.distributionRegion.getParent());
        int lineEndX = parentOffset + 60;
        int lineEndY = this.yOffset - 100 + this.HEIGHT;
        g.drawLine(this.xOffset + 60, this.yOffset, lineEndX, lineEndY);
    }

    private int calculateYOffset() {
        return this.distributionRegion.getLevel() * 100 + this.panel.getRootPosY();
    }

    public boolean isMouseOver(MouseEvent event) {
        return event.getX() >= this.xOffset && event.getX() <= this.xOffset + 120 && event.getY() >= this.yOffset && event.getY() <= this.yOffset + this.HEIGHT;
    }

    public Hyperrectangle drawComponent(Graphics2D g) {
        this.xOffset = this.calculateXOffset(this.distributionRegion);
        this.yOffset = this.calculateYOffset();
        Color oldColor = g.getColor();
        g.setColor(this.getColorForRegion(this.distributionRegion));
        g.fillRect(this.xOffset, this.yOffset, 120, this.HEIGHT);
        g.setColor(oldColor);
        g.drawRect(this.xOffset, this.yOffset, 120, this.HEIGHT);
        Hyperrectangle converingBox = this.distributionRegion.getConveringBox();
        double offset = 0.9 / (2.0 + (double)converingBox.getDimension());
        String regionId = "Region: " + Long.toString(this.distributionRegion.getRegionId());
        this.writeStringCentered(g, regionId, 1.0 * offset);
        String nodeState = this.distributionRegion.getState().getStringValue();
        this.writeStringCentered(g, nodeState, 2.0 * offset);
        for (int i = 0; i < converingBox.getDimension(); ++i) {
            DoubleInterval floatInterval = converingBox.getIntervalForDimension(i);
            String text = "D" + i + ": " + floatInterval.getRoundedString(3);
            this.writeStringCentered(g, text, (double)(3 + i) * offset);
        }
        this.drawParentNodeLine(g);
        return this.getBoundingBox();
    }

    public Hyperrectangle getBoundingBox() {
        Hyperrectangle boundingBox = new Hyperrectangle(new Double[]{this.xOffset, (double)this.xOffset + 120.0, this.yOffset, (double)this.yOffset + (double)this.HEIGHT});
        return boundingBox;
    }

    private void writeStringCentered(Graphics2D g, String stringValue, double pos) {
        int stringWidth = this.calculateStringWidth(g, stringValue);
        int centerValue = this.xOffset + 60 - stringWidth / 2;
        Font font = g.getFont();
        g.setFont(new Font(font.getFontName(), font.getStyle(), 10));
        g.drawString(stringValue, centerValue, this.yOffset + (int)((double)this.HEIGHT * pos));
    }

    private int calculateStringWidth(Graphics2D g, String stringValue) {
        Rectangle2D boundsState = g.getFontMetrics().getStringBounds(stringValue, g);
        return (int)boundsState.getWidth();
    }

    private Color getColorForRegion(DistributionRegion distributionRegion) {
        switch (distributionRegion.getState()) {
            case ACTIVE: 
            case ACTIVE_FULL: 
            case MERGING_PARENT: {
                return Color.GREEN;
            }
            case SPLIT: {
                return new Color(144, 144, 144);
            }
            case SPLITTING: {
                return Color.YELLOW;
            }
        }
        return Color.LIGHT_GRAY;
    }

    public String getToolTipText() {
        StringBuilder sb = new StringBuilder("<html>");
        try {
            Map<BBoxDBInstance, Map<String, Long>> statistics = this.addStatisticsToTooltip(sb);
            Hyperrectangle boundingBox = this.distributionRegion.getConveringBox();
            for (int i = 0; i < boundingBox.getDimension(); ++i) {
                DoubleInterval floatInterval = boundingBox.getIntervalForDimension(i);
                sb.append("Dimension: " + i + " ");
                sb.append(floatInterval.toString());
                sb.append("<br>");
            }
            List systems = this.distributionRegion.getSystems();
            for (BBoxDBInstance instance : systems) {
                if (statistics.keySet().contains(instance)) continue;
                sb.append("System: ");
                sb.append(instance.toGUIString(this.guiModel.isScreenshotMode()));
                sb.append(" <br>");
            }
            boolean mergeableByZookeeper = RegionMergeHelper.isMergingByZookeeperAllowed((DistributionRegion)this.distributionRegion);
            boolean mergeableBySpacePartitioner = RegionMergeHelper.isMergingBySpacePartitionerAllowed((DistributionRegion)this.distributionRegion);
            sb.append("Merge supported by configuration <i>" + mergeableByZookeeper + "</i>, by space partitioner <i>" + mergeableBySpacePartitioner + "</i><br>");
            boolean isSplitSupported = RegionSplitHelper.isSplittingSupported((DistributionRegion)this.distributionRegion);
            sb.append("Split supported by space partitioner <i>" + isSplitSupported + "</i><br>");
        }
        catch (Exception e) {
            logger.error("Got an exception while reading statistics for distribution group", (Throwable)e);
        }
        sb.append("</html>");
        return sb.toString();
    }

    private Map<BBoxDBInstance, Map<String, Long>> addStatisticsToTooltip(StringBuilder sb) throws ZookeeperException, ZookeeperNotFoundException {
        DistributionRegionAdapter adapter = ZookeeperClientFactory.getZookeeperClient().getDistributionRegionAdapter();
        Map statistics = adapter.getRegionStatistics(this.distributionRegion);
        for (BBoxDBInstance instance : statistics.keySet()) {
            Map statisticData = (Map)statistics.get(instance);
            sb.append("Node: ");
            sb.append(instance.toGUIString(this.guiModel.isScreenshotMode()));
            sb.append(" Tuples: ");
            sb.append(statisticData.get("total_tuples"));
            sb.append(", Size: ");
            sb.append(statisticData.get("total_size"));
            sb.append(" MB <br>");
        }
        return statistics;
    }

    public DistributionRegion getDistributionRegion() {
        return this.distributionRegion;
    }
}

