/*
 * Decompiled with CFR 0.152.
 */
package org.bboxdb.tools.gui;

import java.awt.Cursor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import javax.swing.SwingUtilities;
import org.bboxdb.distribution.DistributionGroupConfigurationCache;
import org.bboxdb.distribution.membership.BBoxDBInstance;
import org.bboxdb.distribution.membership.BBoxDBInstanceManager;
import org.bboxdb.distribution.membership.DistributedInstanceEvent;
import org.bboxdb.distribution.partitioner.SpacePartitioner;
import org.bboxdb.distribution.partitioner.SpacePartitionerCache;
import org.bboxdb.distribution.region.DistributionRegion;
import org.bboxdb.distribution.region.DistributionRegionCallback;
import org.bboxdb.distribution.region.DistributionRegionEvent;
import org.bboxdb.distribution.zookeeper.DistributionGroupAdapter;
import org.bboxdb.distribution.zookeeper.TupleStoreAdapter;
import org.bboxdb.distribution.zookeeper.ZookeeperClientFactory;
import org.bboxdb.distribution.zookeeper.ZookeeperException;
import org.bboxdb.distribution.zookeeper.ZookeeperNotFoundException;
import org.bboxdb.network.client.BBoxDBCluster;
import org.bboxdb.storage.entity.DistributionGroupConfiguration;
import org.bboxdb.tools.gui.BBoxDBGui;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuiModel
implements DistributionRegionCallback {
    public boolean screenshotMode = false;
    private final List<BBoxDBInstance> bboxdbInstances;
    private String distributionGroup;
    private BBoxDBGui bboxdbGui;
    private final BBoxDBCluster connection;
    private SpacePartitioner spacePartitioner;
    private final DistributionGroupAdapter distributionGroupZookeeperAdapter;
    private BiConsumer<DistributedInstanceEvent, BBoxDBInstance> distributedEventConsumer = (event, instance) -> this.handleDistributedEvent((DistributedInstanceEvent)event, (BBoxDBInstance)instance);
    private static final Logger logger = LoggerFactory.getLogger(GuiModel.class);

    public GuiModel(BBoxDBCluster connection) {
        this.connection = connection;
        this.distributionGroupZookeeperAdapter = new DistributionGroupAdapter(ZookeeperClientFactory.getZookeeperClient());
        this.bboxdbInstances = new ArrayList<BBoxDBInstance>();
        BBoxDBInstanceManager.getInstance().registerListener(this.distributedEventConsumer);
        this.updateBBoxDBInstances();
    }

    public void shutdown() {
        BBoxDBInstanceManager.getInstance().removeListener(this.distributedEventConsumer);
        this.unregisterTreeChangeListener();
    }

    public void unregisterTreeChangeListener() {
        if (this.spacePartitioner != null) {
            this.spacePartitioner.unregisterCallback((DistributionRegionCallback)this);
            this.spacePartitioner = null;
        }
    }

    public void updateModel() {
        try {
            this.updateBBoxDBInstances();
            this.bboxdbGui.updateView();
        }
        catch (Exception e) {
            logger.info("Exception while updating the view", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateBBoxDBInstances() {
        List<BBoxDBInstance> list = this.bboxdbInstances;
        synchronized (list) {
            this.bboxdbInstances.clear();
            this.bboxdbInstances.addAll(BBoxDBInstanceManager.getInstance().getInstances());
            Collections.sort(this.bboxdbInstances);
        }
    }

    public void updateDistributionRegion() throws ZookeeperException, ZookeeperNotFoundException {
        logger.info("Reread distribution group: {}", (Object)this.distributionGroup);
        if (this.distributionGroup == null) {
            return;
        }
        SwingUtilities.invokeLater(() -> {
            if (this.bboxdbGui.getGlassPane() != null) {
                this.bboxdbGui.getGlassPane().setVisible(true);
                this.bboxdbGui.getGlassPane().setCursor(Cursor.getPredefinedCursor(3));
            }
        });
        new Thread(() -> {
            this.unregisterTreeChangeListener();
            if (this.distributionGroup == null) {
                this.spacePartitioner = null;
                return;
            }
            try {
                this.spacePartitioner = SpacePartitionerCache.getInstance().getSpacePartitionerForGroupName(this.distributionGroup);
                DistributionGroupConfiguration config = DistributionGroupConfigurationCache.getInstance().getDistributionGroupConfiguration(this.distributionGroup);
                this.spacePartitioner.registerCallback((DistributionRegionCallback)this);
                StringBuilder sb = new StringBuilder();
                sb.append("Cluster name: " + this.getClustername());
                sb.append(", Replication factor: " + config.getReplicationFactor());
                sb.append(", Dimensions: " + config.getDimensions());
                sb.append(", Space partitioner: " + config.getSpacePartitioner());
                this.bboxdbGui.getStatusLabel().setText(sb.toString());
                logger.info("Read distribution group {}\u00a0done", (Object)this.distributionGroup);
                SwingUtilities.invokeLater(() -> {
                    this.updateModel();
                    if (this.bboxdbGui.getGlassPane() != null) {
                        Cursor defaultCursor = Cursor.getPredefinedCursor(0);
                        this.bboxdbGui.getGlassPane().setCursor(defaultCursor);
                        this.bboxdbGui.getGlassPane().setVisible(false);
                    }
                });
            }
            catch (Exception e) {
                logger.warn("Got exception", (Throwable)e);
            }
        }).start();
    }

    public void setStatusText(String text) {
        SwingUtilities.invokeLater(() -> this.bboxdbGui.getStatusLabel().setText(text));
    }

    public void handleDistributedEvent(DistributedInstanceEvent event, BBoxDBInstance instance) {
        this.updateBBoxDBInstances();
        this.updateModel();
    }

    public void regionChanged(DistributionRegionEvent event, DistributionRegion distributionRegion) {
        this.updateModel();
    }

    public List<BBoxDBInstance> getBBoxDBInstances() {
        return this.bboxdbInstances;
    }

    public void setBBoxDBGui(BBoxDBGui bboxDBGui) {
        this.bboxdbGui = bboxDBGui;
    }

    public String getDistributionGroup() {
        return this.distributionGroup;
    }

    public String getClustername() {
        return ZookeeperClientFactory.getZookeeperClient().getClustername();
    }

    public void setDistributionGroup(String distributionGroup) {
        this.distributionGroup = distributionGroup;
        try {
            this.updateDistributionRegion();
        }
        catch (Exception e) {
            logger.info("Exception while updating the view", (Throwable)e);
        }
    }

    public SpacePartitioner getTreeAdapter() {
        return this.spacePartitioner;
    }

    public List<String> getDistributionGroups() throws ZookeeperException, ZookeeperNotFoundException {
        return this.distributionGroupZookeeperAdapter.getDistributionGroups();
    }

    public boolean isScreenshotMode() {
        return this.screenshotMode;
    }

    public void setScreenshotMode(boolean screenshotMode) {
        this.screenshotMode = screenshotMode;
    }

    public BBoxDBCluster getConnection() {
        return this.connection;
    }

    public List<String> getAllTables() {
        ArrayList<String> allTables = new ArrayList<String>();
        TupleStoreAdapter adapter = new TupleStoreAdapter(ZookeeperClientFactory.getZookeeperClient());
        try {
            List<String> allGroups = this.getDistributionGroups();
            for (String distributionGroup : allGroups) {
                List allTablesInGroup = adapter.getAllTables(distributionGroup);
                allTables.addAll(allTablesInGroup);
            }
            Collections.sort(allTables);
        }
        catch (Exception e) {
            logger.error("Got error while fetchting distribution groups", (Throwable)e);
        }
        return allTables;
    }
}

