/*
 * Decompiled with CFR 0.152.
 */
package org.bboxdb.tools.gui.util;

import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.swing.JButton;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.OSMTileFactoryInfo;
import org.jxmapviewer.cache.FileBasedLocalCache;
import org.jxmapviewer.cache.LocalCache;
import org.jxmapviewer.input.PanKeyListener;
import org.jxmapviewer.input.PanMouseInputListener;
import org.jxmapviewer.input.ZoomMouseWheelListenerCursor;
import org.jxmapviewer.viewer.DefaultTileFactory;
import org.jxmapviewer.viewer.GeoPosition;
import org.jxmapviewer.viewer.TileFactory;
import org.jxmapviewer.viewer.TileFactoryInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapViewerFactory {
    private static Path cacheDir;
    private static final Logger logger;

    public static JXMapViewer createMapViewer() {
        JXMapViewer mapViewer = new JXMapViewer();
        OSMTileFactoryInfo info = new OSMTileFactoryInfo();
        DefaultTileFactory tileFactory = new DefaultTileFactory((TileFactoryInfo)info);
        tileFactory.setLocalCache((LocalCache)new FileBasedLocalCache(cacheDir.toFile(), false));
        mapViewer.setTileFactory((TileFactory)tileFactory);
        PanMouseInputListener mia = new PanMouseInputListener(mapViewer);
        mapViewer.addMouseListener((MouseListener)mia);
        mapViewer.addMouseMotionListener((MouseMotionListener)mia);
        mapViewer.addMouseWheelListener((MouseWheelListener)new ZoomMouseWheelListenerCursor(mapViewer));
        mapViewer.addKeyListener((KeyListener)new PanKeyListener(mapViewer));
        tileFactory.setThreadPoolSize(8);
        MapViewerFactory.showHagen(mapViewer);
        return mapViewer;
    }

    public static void showHagen(JXMapViewer mapViewer) {
        GeoPosition hagen = new GeoPosition(51.376255, 7.493675);
        mapViewer.setZoom(7);
        mapViewer.setAddressLocation(hagen);
    }

    public static void showLA(JXMapViewer mapViewer) {
        GeoPosition la = new GeoPosition(34.052235, -118.243683);
        mapViewer.setZoom(9);
        mapViewer.setAddressLocation(la);
    }

    public static void showSydney(JXMapViewer mapViewer) {
        GeoPosition sydney = new GeoPosition(-33.865143, 151.2099);
        mapViewer.setZoom(9);
        mapViewer.setAddressLocation(sydney);
    }

    public static void showBerlin(JXMapViewer mapViewer) {
        GeoPosition hagen = new GeoPosition(52.522199, 13.413749);
        mapViewer.setZoom(9);
        mapViewer.setAddressLocation(hagen);
    }

    public static void showGermany(JXMapViewer mapViewer) {
        GeoPosition hagen = new GeoPosition(51.904815, 10.265166);
        mapViewer.setZoom(14);
        mapViewer.setAddressLocation(hagen);
    }

    public static JButton getShowWorldButton(JXMapViewer mapViewer) {
        JButton showWorldButton = new JButton("Show world");
        showWorldButton.addActionListener(l -> mapViewer.setZoom(17));
        return showWorldButton;
    }

    public static JButton getZoomInButton(JXMapViewer mapViewer) {
        JButton zoomInButton = new JButton("Zoom in");
        zoomInButton.addActionListener(l -> {
            int zoom = mapViewer.getZoom();
            mapViewer.setZoom(zoom - 1);
        });
        return zoomInButton;
    }

    public static JButton getZoomOutButton(JXMapViewer mapViewer) {
        JButton zoomOutButton = new JButton("Zoom out");
        zoomOutButton.addActionListener(l -> {
            int zoom = mapViewer.getZoom();
            mapViewer.setZoom(zoom + 1);
        });
        return zoomOutButton;
    }

    public static JButton getShowHagenButton(JXMapViewer mapViewer) {
        JButton showHagenButton = new JButton("Show Hagen");
        showHagenButton.addActionListener(l -> MapViewerFactory.showHagen(mapViewer));
        return showHagenButton;
    }

    public static JButton getShowLAButton(JXMapViewer mapViewer) {
        JButton showLAButton = new JButton("Show LA");
        showLAButton.addActionListener(l -> MapViewerFactory.showLA(mapViewer));
        return showLAButton;
    }

    public static JButton getShowSydneyButton(JXMapViewer mapViewer) {
        JButton showHagenButton = new JButton("Show Sydney");
        showHagenButton.addActionListener(l -> MapViewerFactory.showSydney(mapViewer));
        return showHagenButton;
    }

    public static JButton getShowGermanyButton(JXMapViewer mapViewer) {
        JButton showGermanyButton = new JButton("Show Germany");
        showGermanyButton.addActionListener(l -> MapViewerFactory.showGermany(mapViewer));
        return showGermanyButton;
    }

    public static JButton getShowBerlinButton(JXMapViewer mapViewer) {
        JButton showHagenButton = new JButton("Show Berlin");
        showHagenButton.addActionListener(l -> MapViewerFactory.showBerlin(mapViewer));
        return showHagenButton;
    }

    static {
        logger = LoggerFactory.getLogger(MapViewerFactory.class);
        String tempdir = System.getProperty("java.io.tmpdir");
        String username = System.getProperty("user.name");
        cacheDir = Paths.get(tempdir, "jxmapviewer2cache_" + username);
        File file = cacheDir.toFile();
        boolean createSuccess = file.mkdirs();
        if (!createSuccess) {
            logger.debug("Using existing cache dir");
        }
        if (!file.canWrite()) {
            logger.error("Unable to write to cache dir: " + file);
            System.exit(-1);
        }
        logger.info("Caching maps to: " + cacheDir);
    }
}

