/*
 * Decompiled with CFR 0.152.
 */
package org.bboxdb.tools.gui.views.query;

import java.awt.Color;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.bboxdb.commons.concurrent.ExceptionSafeRunnable;
import org.bboxdb.network.client.BBoxDBCluster;
import org.bboxdb.query.ContinuousQueryPlan;
import org.bboxdb.query.ContinuousSpatialJoinQueryPlan;
import org.bboxdb.storage.entity.EntityIdentifier;
import org.bboxdb.storage.entity.JoinedTupleIdentifier;
import org.bboxdb.storage.entity.MultiTuple;
import org.bboxdb.tools.gui.views.query.ElementOverlayPainter;
import org.bboxdb.tools.gui.views.query.OverlayElementBuilder;
import org.bboxdb.tools.gui.views.query.OverlayElementGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractContinuousQueryRunable
extends ExceptionSafeRunnable {
    protected final ContinuousQueryPlan qp;
    protected final BBoxDBCluster connection;
    protected final ElementOverlayPainter painter;
    private long lastStaleCheck = 0L;
    protected boolean FILTER_STALE_ELEMENTS = false;
    protected final Map<EntityIdentifier, Long> updateDates = new HashMap<EntityIdentifier, Long>();
    protected final Map<EntityIdentifier, Long> tupleVersions = new HashMap<EntityIdentifier, Long>();
    protected final Map<EntityIdentifier, OverlayElementGroup> paintedElements = new HashMap<EntityIdentifier, OverlayElementGroup>();
    protected JoinedTupleIdentifier.Strategy strategy;
    private long STALE_TIME_IN_MS = TimeUnit.MINUTES.toMillis(5L);
    private static final Logger logger = LoggerFactory.getLogger(AbstractContinuousQueryRunable.class);

    public AbstractContinuousQueryRunable(ContinuousQueryPlan qp, BBoxDBCluster connection, ElementOverlayPainter painter) {
        this.qp = qp;
        this.connection = connection;
        this.painter = painter;
        this.strategy = JoinedTupleIdentifier.Strategy.KEY_AND_TABLE;
        if (qp instanceof ContinuousSpatialJoinQueryPlan) {
            ContinuousSpatialJoinQueryPlan queryPlan = (ContinuousSpatialJoinQueryPlan)qp;
            if (!queryPlan.getAfterJoinFilter().isEmpty()) {
                this.strategy = JoinedTupleIdentifier.Strategy.FIRST_KEY_AND_TABLE;
            }
            if (queryPlan.isReceiveInvalidations()) {
                this.strategy = JoinedTupleIdentifier.Strategy.KEY_AND_TABLE;
            }
        }
        logger.info("Duplicate strategy is: {}", (Object)this.strategy);
    }

    protected void removeStaleTupleIfNeeded() {
        long currentTime = System.currentTimeMillis();
        if (currentTime < this.lastStaleCheck + this.STALE_TIME_IN_MS) {
            return;
        }
        Iterator<Map.Entry<EntityIdentifier, Long>> iter = this.updateDates.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<EntityIdentifier, Long> entry = iter.next();
            if (entry.getValue() + this.STALE_TIME_IN_MS >= currentTime) continue;
            iter.remove();
            this.tupleVersions.remove(entry.getKey());
            OverlayElementGroup oldElement = this.paintedElements.remove(entry.getKey());
            if (oldElement == null) continue;
            logger.info("Removed one stale element");
            this.painter.removeElementToDraw(oldElement, true);
        }
        this.lastStaleCheck = currentTime;
    }

    protected void removeTupleFromView(MultiTuple joinedTuple) {
        JoinedTupleIdentifier key = new JoinedTupleIdentifier(joinedTuple, this.strategy);
        logger.info("---> Got invalidation tuple, removing {}\u00a0from view", (Object)key);
        OverlayElementGroup oldElement = this.paintedElements.remove(key);
        this.paintedElements.remove(key);
        this.tupleVersions.remove(key);
        this.updateDates.remove(key);
        if (oldElement != null) {
            this.painter.removeElementToDraw(oldElement, true);
        }
    }

    protected void updateTupleOnGui(MultiTuple joinedTuple, List<Color> colors, boolean refreshGUI) {
        OverlayElementGroup overlayElementGroup = OverlayElementBuilder.createOverlayElementGroup(joinedTuple, colors);
        JoinedTupleIdentifier key = new JoinedTupleIdentifier(joinedTuple, this.strategy);
        OverlayElementGroup oldElement = this.paintedElements.get(key);
        if (oldElement != null) {
            if (this.FILTER_STALE_ELEMENTS) {
                long existingTimestamp = this.tupleVersions.get(key);
                if (joinedTuple.getVersionTimestamp() < existingTimestamp) {
                    logger.info("Ignoring outdated version for tuple {} old={} new={}", new Object[]{key, existingTimestamp, joinedTuple.getVersionTimestamp()});
                    return;
                }
            }
            this.painter.removeElementToDraw(oldElement, refreshGUI);
        }
        this.paintedElements.put((EntityIdentifier)key, overlayElementGroup);
        this.tupleVersions.put((EntityIdentifier)key, joinedTuple.getVersionTimestamp());
        this.updateDates.put((EntityIdentifier)key, System.currentTimeMillis());
        this.painter.addElementToDraw(overlayElementGroup, refreshGUI);
    }
}

