/*
 * Decompiled with CFR 0.152.
 */
package org.bboxdb.tools.gui.views.query;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.bboxdb.commons.math.GeoJsonPolygon;

public class DetailsWindow {
    private final GeoJsonPolygon polygon;
    private final JFrame mainframe;

    public DetailsWindow(GeoJsonPolygon polygon) {
        this.polygon = polygon;
        this.mainframe = new JFrame("BBoxDB - Result details for polygon: " + polygon.getId());
    }

    private JButton getCloseButton() {
        JButton closeButton = new JButton("Close");
        closeButton.addActionListener(l -> this.mainframe.setVisible(false));
        return closeButton;
    }

    public void show() {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        JComponent jTable = this.buildJTextArea();
        mainPanel.add((Component)jTable, "Center");
        JButton closeButton = this.getCloseButton();
        mainPanel.add((Component)closeButton, "South");
        mainPanel.setPreferredSize(new Dimension(800, 600));
        this.mainframe.add(mainPanel);
        this.mainframe.pack();
        this.mainframe.setLocationRelativeTo(null);
        this.mainframe.setVisible(true);
    }

    private JComponent buildJTextArea() {
        JTextArea jtextArea = new JTextArea();
        jtextArea.setText(this.polygon.toFormatedGeoJson());
        JScrollPane scrollPane = new JScrollPane(jtextArea);
        SwingUtilities.invokeLater(() -> scrollPane.getVerticalScrollBar().setValue(0));
        return scrollPane;
    }
}

