/*
 * Decompiled with CFR 0.152.
 */
package org.bboxdb.tools.gui.views.query;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import javax.swing.SwingUtilities;
import org.bboxdb.storage.entity.EntityIdentifier;
import org.bboxdb.tools.gui.views.query.ElementPaintMode;
import org.bboxdb.tools.gui.views.query.OverlayElement;
import org.bboxdb.tools.gui.views.query.OverlayElementGroup;
import org.bboxdb.tools.gui.views.query.QueryRangeSelectionAdapter;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.painter.Painter;

public class ElementOverlayPainter
implements Painter<JXMapViewer> {
    private final Collection<OverlayElementGroup> tupleToDraw;
    private final List<OverlayElement> renderedElements;
    private Rectangle validForRectangle;
    private long validForElements;
    private static Color SELECTION_FILL_COLOR = new Color(128, 192, 255, 128);
    private static Color SELECTION_FRAME_COLOR = new Color(0, 0, 255, 128);
    private final QueryRangeSelectionAdapter selectionAdapter;
    private ElementPaintMode paintMode = ElementPaintMode.ALL;
    private final List<Consumer<List<OverlayElement>>> callbacks;
    private final JXMapViewer mapViewer;

    public ElementOverlayPainter(QueryRangeSelectionAdapter selectionAdapter, JXMapViewer mapViewer) {
        this.selectionAdapter = selectionAdapter;
        this.mapViewer = mapViewer;
        this.renderedElements = new ArrayList<OverlayElement>();
        this.tupleToDraw = new CopyOnWriteArrayList<OverlayElementGroup>();
        this.callbacks = new CopyOnWriteArrayList<Consumer<List<OverlayElement>>>();
    }

    public boolean markRegionAsDirty(OverlayElementGroup overlayElementGroup) {
        if (overlayElementGroup.getNumberOfOverlays() == 0) {
            return false;
        }
        Rectangle bbox = new Rectangle(overlayElementGroup.getOverlay(0).getBBoxToDrawOnGui());
        for (OverlayElement element : overlayElementGroup) {
            bbox.add(element.getDirtyPixel());
        }
        Rectangle rect = this.mapViewer.getViewportBounds();
        bbox.translate((int)(-rect.getX()), (int)(-rect.getY()));
        if (EventQueue.isDispatchThread()) {
            this.mapViewer.repaint(bbox);
        } else {
            SwingUtilities.invokeLater(() -> this.mapViewer.repaint(bbox));
        }
        return true;
    }

    public void repaintAll() {
        if (EventQueue.isDispatchThread()) {
            this.mapViewer.repaint();
        } else {
            SwingUtilities.invokeLater(() -> this.mapViewer.repaint());
        }
    }

    public void paint(Graphics2D g, JXMapViewer map, int width, int height) {
        Graphics2D graphicsContext = (Graphics2D)g.create();
        Color oldColor = graphicsContext.getColor();
        Optional<Rectangle> selection = this.selectionAdapter.getRectangle();
        if (selection.isPresent()) {
            g.setColor(SELECTION_FRAME_COLOR);
            g.draw(selection.get());
            g.setColor(SELECTION_FILL_COLOR);
            g.fill(selection.get());
        }
        Rectangle rect = map.getViewportBounds();
        graphicsContext.translate(-rect.x, -rect.y);
        graphicsContext.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.drawData(graphicsContext, map);
        graphicsContext.setColor(oldColor);
        graphicsContext.dispose();
    }

    private void drawData(Graphics2D graphicsContext, JXMapViewer map) {
        EntityIdentifier identifier;
        Rectangle viewBounds = map.getViewportBounds();
        if (this.hasDataChanged(viewBounds)) {
            this.validForRectangle = viewBounds;
            this.validForElements = this.tupleToDraw.size();
            this.renderedElements.clear();
            for (OverlayElementGroup tuple : this.tupleToDraw) {
                for (OverlayElement element : tuple) {
                    element.updatePosition(map);
                    Rectangle boundingBox = element.getBBoxToDrawOnGui();
                    if (!viewBounds.intersects(boundingBox)) continue;
                    this.renderedElements.add(element);
                }
            }
            List<OverlayElement> elementsForCallback = Collections.unmodifiableList(this.renderedElements);
            for (Consumer consumer : this.callbacks) {
                consumer.accept(elementsForCallback);
            }
        }
        HashSet<EntityIdentifier> alreadyRenderedElements = new HashSet<EntityIdentifier>();
        for (OverlayElement overlayElement : this.renderedElements) {
            if (!overlayElement.isSelected()) continue;
            identifier = overlayElement.getEntityIdentifier();
            this.renderElement(graphicsContext, map, alreadyRenderedElements, overlayElement, identifier);
        }
        for (OverlayElement overlayElement : this.renderedElements) {
            identifier = overlayElement.getEntityIdentifier();
            this.renderElement(graphicsContext, map, alreadyRenderedElements, overlayElement, identifier);
        }
    }

    private void renderElement(Graphics2D graphicsContext, JXMapViewer map, Set<EntityIdentifier> alreadyRenderedElements, OverlayElement element, EntityIdentifier identifier) {
        if (this.paintMode == ElementPaintMode.ALL || this.paintMode == ElementPaintMode.GEOMETRY_ONLY) {
            boolean drawReally = alreadyRenderedElements.add(identifier);
            element.drawOnGui(graphicsContext, map, drawReally);
        }
        if (this.paintMode == ElementPaintMode.ALL || this.paintMode == ElementPaintMode.BOUNDING_BOXES_ONLY) {
            Rectangle boundingBox = element.getBBoxToDrawOnGui();
            graphicsContext.setColor(Color.BLACK);
            graphicsContext.draw(boundingBox);
        }
    }

    private boolean hasDataChanged(Rectangle viewBounds) {
        if (this.validForRectangle == null || this.validForElements == 0L) {
            return true;
        }
        if (!this.validForRectangle.equals(viewBounds)) {
            return true;
        }
        return this.validForElements != (long)this.tupleToDraw.size();
    }

    public void setPaintMode(ElementPaintMode paintMode) {
        this.paintMode = paintMode;
    }

    public void registerCallback(Consumer<List<OverlayElement>> callback) {
        this.callbacks.add(callback);
    }

    public void addElementToDraw(OverlayElementGroup element, boolean refreshGUI) {
        this.tupleToDraw.add(element);
        this.repaintElement(element, true);
        this.setDirty();
        if (refreshGUI) {
            this.mapViewer.repaint();
        }
    }

    public void addElementToDrawBulk(Collection<OverlayElementGroup> elements) {
        this.tupleToDraw.addAll(elements);
        this.setDirty();
        this.mapViewer.repaint();
    }

    private void repaintElement(OverlayElementGroup element, boolean recalulatePosition) {
        for (OverlayElement overlayElement : element) {
            if (!recalulatePosition) continue;
            overlayElement.updatePosition(this.mapViewer);
        }
        this.markRegionAsDirty(element);
    }

    public void removeElementToDraw(OverlayElementGroup element, boolean refreshGUI) {
        this.tupleToDraw.remove(element);
        this.setDirty();
        if (refreshGUI) {
            this.repaintElement(element, false);
        }
    }

    private void setDirty() {
        this.validForRectangle = null;
    }

    public void clearAllElements() {
        this.tupleToDraw.clear();
        this.setDirty();
        this.mapViewer.repaint();
    }

    public JXMapViewer getMapViewer() {
        return this.mapViewer;
    }
}

