/*
 * Decompiled with CFR 0.152.
 */
package org.bboxdb.tools.gui.views.query;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.JToolTip;
import org.bboxdb.tools.gui.views.query.ElementOverlayPainter;
import org.bboxdb.tools.gui.views.query.OverlayElement;
import org.bboxdb.tools.gui.views.query.OverlayElementGroup;
import org.jxmapviewer.JXMapViewer;

public class MouseOverlayHandler
extends MouseAdapter {
    private final ElementOverlayPainter overlayPainter;
    private Collection<OverlayElement> renderedElements;
    private final List<OverlayElement> highlightedElements = new ArrayList<OverlayElement>();
    private final JToolTip toolTip;

    MouseOverlayHandler(ElementOverlayPainter painter, JToolTip toolTip) {
        this.overlayPainter = painter;
        this.toolTip = toolTip;
    }

    public void setRenderedElements(Collection<OverlayElement> renderedElements) {
        this.renderedElements = renderedElements;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        Object shape;
        if (this.renderedElements == null) {
            return;
        }
        JXMapViewer mapViewer = this.overlayPainter.getMapViewer();
        Rectangle rect = mapViewer.getViewportBounds();
        Point mousePosPoint = new Point((int)((double)e.getX() + rect.getX()), (int)((double)e.getY() + rect.getY()));
        Rectangle mousePos = new Rectangle(mousePosPoint);
        mousePos.setSize(1, 1);
        for (OverlayElement element : this.renderedElements) {
            shape = element.getLastRenderedShape();
            if (shape == null || !shape.intersects(mousePos) || element.isSelected()) continue;
            element.setSelected(true);
            this.highlightedElements.add(element);
            this.overlayPainter.markRegionAsDirty(element.getOverlayElementGroup());
        }
        Iterator<OverlayElement> iterator = this.highlightedElements.iterator();
        while (iterator.hasNext()) {
            OverlayElement element;
            element = iterator.next();
            shape = element.getLastRenderedShape();
            if ((shape == null || shape.intersects(mousePos)) && this.renderedElements.contains(element)) continue;
            iterator.remove();
            element.setSelected(false);
            this.overlayPainter.markRegionAsDirty(element.getOverlayElementGroup());
        }
        if (!this.highlightedElements.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            HashSet<String> knownElements = new HashSet<String>();
            for (OverlayElement element : this.highlightedElements) {
                if (!element.isSelected()) continue;
                OverlayElementGroup group = element.getOverlayElementGroup();
                for (int i = 0; i < group.getNumberOfOverlays(); ++i) {
                    OverlayElement overlayElement = group.getOverlay(i);
                    String tooltipText = overlayElement.getTooltipText();
                    if (knownElements.contains(tooltipText)) continue;
                    knownElements.add(tooltipText);
                    if (knownElements.size() != 1) {
                        sb.append("<hr>");
                    }
                    sb.append("%%FONT_START%%");
                    sb.append(tooltipText);
                    sb.append("</font>");
                }
            }
            int lines = sb.toString().split("\\<br\\>").length;
            StringBuilder htmlStringBuilder = new StringBuilder("<html>");
            htmlStringBuilder.append((CharSequence)sb);
            htmlStringBuilder.append("</html>");
            String htmlString = htmlStringBuilder.toString();
            htmlString = lines > 45 ? htmlString.replace("%%FONT_START%%", "<font size=\"1\">") : (lines > 25 ? htmlString.replace("%%FONT_START%%", "<font size=\"2\">") : htmlString.replace("%%FONT_START%%", "<font size=\"3\">"));
            this.toolTip.setTipText(htmlString);
            this.toolTip.setLocation(new Point(e.getX(), e.getY()));
            this.toolTip.setVisible(true);
        } else {
            this.toolTip.setVisible(false);
        }
    }
}

