/*
 * Decompiled with CFR 0.152.
 */
package org.bboxdb.tools.gui.views.query;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bboxdb.commons.math.GeoJsonPolygon;
import org.bboxdb.commons.math.Hyperrectangle;
import org.bboxdb.storage.entity.EntityIdentifier;
import org.bboxdb.tools.gui.views.query.OverlayElementGroup;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.viewer.GeoPosition;

public class OverlayElement {
    private final String tablename;
    private final GeoJsonPolygon polygon;
    private final Color color;
    private List<Point2D> polygonPointsPixel;
    private final Rectangle boundingBoxPixel;
    private final Rectangle dirtyPixel;
    private Shape lastRenderedShape;
    private final EntityIdentifier entityIdentifier;
    private OverlayElementGroup overlayElementGroup;
    private static final int TRANSPARENCY = 127;
    private static final int POINT_SIZE = 5;

    public OverlayElement(EntityIdentifier entityIdentifier, String tablename, GeoJsonPolygon polygon, Color color) {
        this.entityIdentifier = entityIdentifier;
        this.tablename = tablename;
        this.polygon = polygon;
        this.color = color;
        this.boundingBoxPixel = new Rectangle();
        this.dirtyPixel = new Rectangle();
    }

    public GeoJsonPolygon getPolygon() {
        return this.polygon;
    }

    public Color getColor() {
        return this.color;
    }

    public void updatePosition(JXMapViewer map) {
        this.polygonPointsPixel = this.convertPointCoordinatesToGUICoordinates(map, this.polygon.getPointList());
        if (this.polygon.getPointList().size() == 1) {
            Rectangle bbox = this.getRectangleForPoint(map, this.polygonPointsPixel);
            this.boundingBoxPixel.setBounds(bbox);
            this.dirtyPixel.setBounds(this.boundingBoxPixel);
            this.dirtyPixel.grow((int)this.boundingBoxPixel.getHeight() * 4, (int)this.boundingBoxPixel.getWidth() * 4);
        } else {
            Hyperrectangle bbox = this.polygon.getBoundingBox();
            this.updateElementBoundingBox(map, bbox);
        }
    }

    private void updateElementBoundingBox(JXMapViewer map, Hyperrectangle bbox) {
        Point2D.Double startPos = new Point2D.Double(bbox.getCoordinateLow(0), bbox.getCoordinateLow(1));
        Point2D.Double stopPos = new Point2D.Double(bbox.getCoordinateHigh(0), bbox.getCoordinateHigh(1));
        Point2D bboxPixelStart = this.convertPointToPixel(map, startPos);
        Point2D bboxPixelStop = this.convertPointToPixel(map, stopPos);
        int width = (int)(bboxPixelStop.getX() - bboxPixelStart.getX() + 0.5);
        int elementWidth = Math.abs(width) + 1;
        int height = (int)(bboxPixelStop.getY() - bboxPixelStart.getY() + 0.5);
        int elementHeight = Math.abs(height) + 1;
        this.boundingBoxPixel.setBounds((int)(bboxPixelStart.getX() - 0.5), (int)(bboxPixelStop.getY() - 0.5), elementWidth, elementHeight);
        this.dirtyPixel.setBounds(this.boundingBoxPixel);
    }

    public List<Point2D> getPointsToDrawOnGui() {
        return this.polygonPointsPixel;
    }

    public Rectangle getBBoxToDrawOnGui() {
        return this.boundingBoxPixel;
    }

    private List<Point2D> convertPointCoordinatesToGUICoordinates(JXMapViewer map, List<Point2D> polygonPoints) {
        ArrayList<Point2D> elementPoints = new ArrayList<Point2D>();
        for (Point2D point : polygonPoints) {
            Point2D convertedPoint = this.convertPointToPixel(map, point);
            elementPoints.add(convertedPoint);
        }
        return elementPoints;
    }

    private Point2D convertPointToPixel(JXMapViewer map, Point2D point) {
        GeoPosition geoPosition = new GeoPosition(point.getX(), point.getY());
        return map.getTileFactory().geoToPixel(geoPosition, map.getZoom());
    }

    public boolean isSelected() {
        return this.overlayElementGroup.isSelected();
    }

    public void setSelected(boolean selected) {
        this.overlayElementGroup.setSelected(selected);
    }

    public String getTooltipText() {
        StringBuffer sb = new StringBuffer();
        sb.append("<b>Table:</b> " + this.tablename + "<br>");
        if (this.getPolygon().getId() != 0L) {
            sb.append("<b>Id: </b> " + this.getPolygon().getId() + "<br>");
        }
        for (Map.Entry property : this.getPolygon().getProperties().entrySet()) {
            String tooltipProperty = (String)property.getKey();
            String tooltipPropertyUpper = tooltipProperty.substring(0, 1).toUpperCase() + tooltipProperty.substring(1);
            sb.append("<b>" + tooltipPropertyUpper + ":</b> " + (String)property.getValue() + "<br>");
        }
        return sb.toString();
    }

    public String getSourceTable() {
        return this.tablename;
    }

    public void drawOnGui(Graphics2D graphicsContext, JXMapViewer map, boolean drawReally) {
        Point2D lastElement;
        List<Point2D> pointList = this.getPointsToDrawOnGui();
        Color color = this.isSelected() ? Color.GRAY : this.getColor();
        Stroke oldStroke = graphicsContext.getStroke();
        if (pointList.size() == 1) {
            Rectangle rectangle = this.getRectangleForPoint(map, pointList);
            this.lastRenderedShape = rectangle;
            if (drawReally) {
                graphicsContext.setColor(color);
                graphicsContext.fill(rectangle);
                graphicsContext.setColor(Color.BLACK);
                graphicsContext.draw(rectangle);
                String stringValue = this.getStringValueForPointElement();
                Rectangle2D stringBounds = graphicsContext.getFontMetrics().getStringBounds(stringValue, graphicsContext);
                int stringPosY = (int)(rectangle.getMaxY() + rectangle.getHeight() / 2.0 + stringBounds.getHeight());
                int stringPosX = (int)(rectangle.getCenterX() - stringBounds.getWidth() / 2.0);
                Rectangle2D.Double stringDrawPos = new Rectangle2D.Double(stringPosX, (double)stringPosY - stringBounds.getHeight(), stringBounds.getWidth(), stringBounds.getHeight());
                graphicsContext.drawString(stringValue, stringPosX, stringPosY);
                Rectangle2D.union(stringDrawPos, this.boundingBoxPixel, this.dirtyPixel);
            }
            return;
        }
        Point2D firstElement = pointList.get(0);
        if (firstElement.equals(lastElement = pointList.get(pointList.size() - 1))) {
            Polygon polygon = new Polygon();
            for (Point2D point : pointList) {
                polygon.addPoint((int)point.getX(), (int)point.getY());
            }
            this.lastRenderedShape = polygon;
            if (drawReally) {
                Color transparentColor = new Color(color.getRed(), color.getGreen(), color.getBlue(), 127);
                graphicsContext.setColor(transparentColor);
                graphicsContext.fillPolygon(polygon);
                graphicsContext.setColor(Color.BLACK);
                graphicsContext.drawPolygon(polygon);
            }
        } else {
            graphicsContext.setColor(color);
            if (this.isSelected()) {
                graphicsContext.setStroke(new BasicStroke(4.0f));
            } else {
                graphicsContext.setStroke(new BasicStroke(2.0f));
            }
            Path2D.Double line = new Path2D.Double();
            ((Path2D)line).moveTo(pointList.get(0).getX(), pointList.get(0).getY());
            for (int i = 0; i < pointList.size(); ++i) {
                Point2D point = pointList.get(i);
                ((Path2D)line).lineTo(point.getX(), point.getY());
            }
            this.lastRenderedShape = line;
            if (drawReally) {
                graphicsContext.draw(line);
            }
        }
        graphicsContext.setStroke(oldStroke);
    }

    private String getStringValueForPointElement() {
        Map properties = this.polygon.getProperties();
        if (properties.containsKey("TripID")) {
            return (String)properties.get("TripID");
        }
        if (properties.containsKey("Callsign")) {
            return (String)properties.get("Callsign") + "(" + (String)properties.get("Altitude") + " f)";
        }
        return Long.toString(this.polygon.getId());
    }

    private Rectangle getRectangleForPoint(JXMapViewer map, List<Point2D> pointList) {
        Point2D thePoint = pointList.get(0);
        int zoom = map.getZoom() + 1;
        int changedZoom = zoom / 4;
        int size = Math.max(5, 5 * changedZoom);
        int pointX = (int)(thePoint.getX() - (double)(size / 2));
        int pointY = (int)(thePoint.getY() - (double)(size / 2));
        return new Rectangle(pointX, pointY, size, size);
    }

    public EntityIdentifier getEntityIdentifier() {
        return this.entityIdentifier;
    }

    public void setOverlayElementGroup(OverlayElementGroup overlayElementGroup) {
        this.overlayElementGroup = overlayElementGroup;
    }

    public OverlayElementGroup getOverlayElementGroup() {
        return this.overlayElementGroup;
    }

    public Shape getLastRenderedShape() {
        return this.lastRenderedShape;
    }

    public Rectangle getDirtyPixel() {
        return this.dirtyPixel;
    }

    public String toString() {
        return "OverlayElement [tablename=" + this.tablename + ", polygon=" + this.polygon + ", color=" + this.color + ", polygonPointsPixel=" + this.polygonPointsPixel + ", boundingBoxPixel=" + this.boundingBoxPixel + ", dirtyPixel=" + this.dirtyPixel + ", lastRenderedShape=" + this.lastRenderedShape + ", entityIdentifier=" + this.entityIdentifier + "]";
    }
}

