/*
 * Decompiled with CFR 0.152.
 */
package org.bboxdb.tools.gui.views.query;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bboxdb.commons.math.GeoJsonPolygon;
import org.bboxdb.misc.Const;
import org.bboxdb.storage.entity.EntityIdentifier;
import org.bboxdb.storage.entity.JoinedTupleIdentifier;
import org.bboxdb.storage.entity.MultiTuple;
import org.bboxdb.storage.entity.Tuple;
import org.bboxdb.tools.gui.views.query.OverlayElement;
import org.bboxdb.tools.gui.views.query.OverlayElementGroup;

public class OverlayElementBuilder {
    public static OverlayElementGroup createOverlayElementGroup(Tuple tuple, String tupleStoreName, Color color) {
        OverlayElement overlayElement = OverlayElementBuilder.generateOverlayElement(tuple, tupleStoreName, color);
        return new OverlayElementGroup(Arrays.asList(overlayElement));
    }

    public static OverlayElementGroup createOverlayElementGroup(MultiTuple joinedTuple, List<Color> colors) {
        ArrayList<OverlayElement> elements = new ArrayList<OverlayElement>();
        for (int i = 0; i < joinedTuple.getNumberOfTuples(); ++i) {
            Tuple tuple = joinedTuple.getTuple(i);
            String tupleStoreName = joinedTuple.getTupleStoreName(i);
            Color color = colors.get(i % colors.size());
            OverlayElement overlayElement = OverlayElementBuilder.generateOverlayElement(tuple, tupleStoreName, color);
            elements.add(overlayElement);
        }
        elements.sort((c1, c2) -> Integer.compare(c2.getPolygon().getNumberOfPoints(), c1.getPolygon().getNumberOfPoints()));
        return new OverlayElementGroup(elements);
    }

    private static OverlayElement generateOverlayElement(Tuple tuple, String tupleStoreName, Color color) {
        String data = new String(tuple.getDataBytes(), Const.DEFAULT_CHARSET);
        GeoJsonPolygon polygon = GeoJsonPolygon.fromGeoJson((String)data);
        MultiTuple joinedTuple = new MultiTuple(Arrays.asList(tuple), Arrays.asList(tupleStoreName));
        JoinedTupleIdentifier identifier = new JoinedTupleIdentifier(joinedTuple);
        OverlayElement overlayElement = new OverlayElement((EntityIdentifier)identifier, tupleStoreName, polygon, color);
        return overlayElement;
    }
}

