/*
 * Decompiled with CFR 0.152.
 */
package org.bboxdb.tools.gui.views.query;

import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.List;
import java.util.Optional;
import javax.swing.SwingUtilities;
import org.bboxdb.tools.gui.GuiModel;
import org.bboxdb.tools.gui.views.query.ElementOverlayPainter;
import org.bboxdb.tools.gui.views.query.QueryWindow;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.viewer.GeoPosition;
import org.jxmapviewer.viewer.TileFactory;

public class QueryRangeSelectionAdapter
extends MouseAdapter {
    private boolean dragging;
    private final JXMapViewer viewer;
    private Point2D startPos = new Point2D.Double();
    private Point2D stopPos = new Point2D.Double();
    private ElementOverlayPainter elementOverlayPainter;
    private final GuiModel guiModel;
    private List<Thread> backgroundThreads;

    public QueryRangeSelectionAdapter(GuiModel guiModel, JXMapViewer viewer, List<Thread> backgroundThreads) {
        this.guiModel = guiModel;
        this.viewer = viewer;
        this.backgroundThreads = backgroundThreads;
    }

    public void setElementOverlayPainter(ElementOverlayPainter elementOverlayPainter) {
        this.elementOverlayPainter = elementOverlayPainter;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!SwingUtilities.isRightMouseButton(e)) {
            return;
        }
        this.startPos.setLocation(e.getX(), e.getY());
        this.dragging = true;
    }

    private Point2D getRealPos(Point2D point) {
        Point2D.Double pos = new Point2D.Double();
        Rectangle viewport = this.viewer.getViewportBounds();
        ((Point2D)pos).setLocation(point.getX() + viewport.getX(), point.getY() + viewport.getY());
        return pos;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.updateStatusBar(e);
        if (!this.dragging) {
            return;
        }
        this.stopPos.setLocation(e.getX(), e.getY());
        this.viewer.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.updateStatusBar(e);
    }

    private void updateStatusBar(MouseEvent e) {
        Point2D.Double mousePos = new Point2D.Double(e.getX(), e.getY());
        Point2D realPos = this.getRealPos(mousePos);
        TileFactory tileFactory = this.viewer.getTileFactory();
        GeoPosition pos = tileFactory.pixelToGeo(realPos, this.viewer.getZoom());
        this.guiModel.setStatusText("Longitude " + pos.getLongitude() + " Latitude " + pos.getLatitude());
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!this.dragging) {
            return;
        }
        if (!SwingUtilities.isRightMouseButton(e)) {
            return;
        }
        this.viewer.repaint();
        this.dragging = false;
        TileFactory tileFactory = this.viewer.getTileFactory();
        Point2D realStartPos = this.getRealPos(this.startPos);
        GeoPosition beginPos = tileFactory.pixelToGeo(realStartPos, this.viewer.getZoom());
        Point2D realEndPos = this.getRealPos(this.stopPos);
        GeoPosition endPos = tileFactory.pixelToGeo(realEndPos, this.viewer.getZoom());
        QueryWindow queryWindow = new QueryWindow(this.guiModel, this.elementOverlayPainter, this.backgroundThreads);
        double minLong = Math.min(beginPos.getLongitude(), endPos.getLongitude());
        double maxLong = Math.max(beginPos.getLongitude(), endPos.getLongitude());
        double minLat = Math.min(beginPos.getLatitude(), endPos.getLatitude());
        double maxLat = Math.max(beginPos.getLatitude(), endPos.getLatitude());
        queryWindow.setSelectedLongBegin(Double.toString(minLong));
        queryWindow.setSelectedLongEnd(Double.toString(maxLong));
        queryWindow.setSelectedLatBegin(Double.toString(minLat));
        queryWindow.setSelectedLatEnd(Double.toString(maxLat));
        queryWindow.show();
    }

    public Optional<Rectangle> getRectangle() {
        if (this.dragging) {
            int x1 = (int)Math.min(this.startPos.getX(), this.stopPos.getX());
            int y1 = (int)Math.min(this.startPos.getY(), this.stopPos.getY());
            int x2 = (int)Math.max(this.startPos.getX(), this.stopPos.getX());
            int y2 = (int)Math.max(this.startPos.getY(), this.stopPos.getY());
            return Optional.of(new Rectangle(x1, y1, x2 - x1, y2 - y1));
        }
        return Optional.empty();
    }
}

