/*
 * Decompiled with CFR 0.152.
 */
package org.bboxdb.tools.gui.views.query;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToolTip;
import org.bboxdb.tools.gui.GuiModel;
import org.bboxdb.tools.gui.util.MapViewerFactory;
import org.bboxdb.tools.gui.views.View;
import org.bboxdb.tools.gui.views.query.ElementOverlayPainter;
import org.bboxdb.tools.gui.views.query.ElementPaintMode;
import org.bboxdb.tools.gui.views.query.MouseOverlayHandler;
import org.bboxdb.tools.gui.views.query.OverlayElement;
import org.bboxdb.tools.gui.views.query.QueryRangeSelectionAdapter;
import org.bboxdb.tools.gui.views.query.ResultDetailsWindow;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.painter.Painter;

public class QueryView
implements View {
    private final GuiModel guiModel;
    private JXMapViewer mapViewer;
    private final ResultDetailsWindow resultDetailsWindow;
    private final List<Thread> backgroundThreads;
    private ElementOverlayPainter painter;

    public QueryView(GuiModel guiModel) {
        this.guiModel = guiModel;
        this.resultDetailsWindow = new ResultDetailsWindow();
        this.backgroundThreads = new ArrayList<Thread>();
    }

    @Override
    public JComponent getJPanel() {
        this.mapViewer = MapViewerFactory.createMapViewer();
        this.resultDetailsWindow.setMapViewer(this.mapViewer);
        QueryRangeSelectionAdapter selectionAdapter = new QueryRangeSelectionAdapter(this.guiModel, this.mapViewer, this.backgroundThreads);
        this.painter = new ElementOverlayPainter(selectionAdapter, this.mapViewer);
        this.mapViewer.setOverlayPainter((Painter)this.painter);
        selectionAdapter.setElementOverlayPainter(this.painter);
        this.mapViewer.addMouseListener((MouseListener)selectionAdapter);
        this.mapViewer.addMouseMotionListener((MouseMotionListener)selectionAdapter);
        JToolTip tooltip = new JToolTip(){
            private static final long serialVersionUID = -2806858564323423227L;

            @Override
            public void setLocation(int x, int y) {
            }

            @Override
            public void setLocation(Point p) {
                super.setLocation((int)p.getX(), (int)p.getY());
            }
        };
        tooltip.setComponent((JComponent)this.mapViewer);
        this.mapViewer.add((Component)tooltip);
        MouseOverlayHandler mouseOverlayHandler = new MouseOverlayHandler(this.painter, tooltip);
        this.mapViewer.addMouseMotionListener((MouseMotionListener)mouseOverlayHandler);
        this.painter.registerCallback(e -> mouseOverlayHandler.setRenderedElements((Collection<OverlayElement>)e));
        this.painter.registerCallback(e -> this.resultDetailsWindow.setRenderedElements((List<OverlayElement>)e));
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        mainPanel.add((Component)this.mapViewer, "Center");
        JPanel buttonPanel = new JPanel();
        mainPanel.add((Component)buttonPanel, "South");
        JButton zoomInButton = MapViewerFactory.getZoomInButton(this.mapViewer);
        buttonPanel.add(zoomInButton);
        JButton zoomOutButton = MapViewerFactory.getZoomOutButton(this.mapViewer);
        buttonPanel.add(zoomOutButton);
        JButton showWorldButton = MapViewerFactory.getShowWorldButton(this.mapViewer);
        buttonPanel.add(showWorldButton);
        JButton showLAButton = MapViewerFactory.getShowLAButton(this.mapViewer);
        buttonPanel.add(showLAButton);
        JButton showBerlinButton = MapViewerFactory.getShowBerlinButton(this.mapViewer);
        buttonPanel.add(showBerlinButton);
        JButton showSydneyButton = MapViewerFactory.getShowSydneyButton(this.mapViewer);
        buttonPanel.add(showSydneyButton);
        JButton clearButton = this.getClearButton();
        buttonPanel.add(clearButton);
        JButton resultDetails = this.getResultDetailsButton();
        buttonPanel.add(resultDetails);
        JComponent bboxCheckbox = this.getDrawModeComponent(this.painter);
        buttonPanel.add(bboxCheckbox);
        return mainPanel;
    }

    private JButton getResultDetailsButton() {
        JButton queryButton = new JButton("Show result details");
        queryButton.addActionListener(l -> this.resultDetailsWindow.show());
        return queryButton;
    }

    private JComponent getDrawModeComponent(ElementOverlayPainter painter) {
        ElementPaintMode[] valuesAsEnum = ElementPaintMode.values();
        String[] valuesAsString = (String[])Arrays.asList(valuesAsEnum).stream().map(e -> e.getStringValue()).toArray(String[]::new);
        JComboBox<String> dropdown = new JComboBox<String>(valuesAsString);
        dropdown.setSelectedIndex(2);
        painter.setPaintMode(ElementPaintMode.GEOMETRY_ONLY);
        dropdown.addActionListener(a -> {
            ElementPaintMode mode = valuesAsEnum[dropdown.getSelectedIndex()];
            painter.setPaintMode(mode);
            this.mapViewer.repaint();
        });
        return dropdown;
    }

    private JButton getClearButton() {
        JButton clearButton = new JButton("Clear map");
        clearButton.addActionListener(l -> {
            this.backgroundThreads.forEach(t -> t.interrupt());
            this.backgroundThreads.clear();
            if (this.painter != null) {
                this.painter.clearAllElements();
            }
            this.mapViewer.repaint();
        });
        return clearButton;
    }

    @Override
    public boolean isGroupSelectionNeeded() {
        return false;
    }
}

