/*
 * Decompiled with CFR 0.152.
 */
package org.bboxdb.tools.gui.views.query;

import com.google.common.base.Stopwatch;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import org.bboxdb.commons.InputParseException;
import org.bboxdb.commons.MathUtil;
import org.bboxdb.commons.math.Hyperrectangle;
import org.bboxdb.misc.BBoxDBException;
import org.bboxdb.network.client.BBoxDBCluster;
import org.bboxdb.network.client.future.client.JoinedTupleListFuture;
import org.bboxdb.network.client.future.client.TupleListFuture;
import org.bboxdb.query.ContinuousQueryPlan;
import org.bboxdb.query.QueryPlanBuilder;
import org.bboxdb.query.filter.UserDefinedFilterDefinition;
import org.bboxdb.query.filter.UserDefinedGeoJsonSpatialFilter;
import org.bboxdb.query.filter.UserDefinedGeoJsonSpatialFilterStrict;
import org.bboxdb.storage.entity.MultiTuple;
import org.bboxdb.storage.entity.Tuple;
import org.bboxdb.tools.gui.GuiModel;
import org.bboxdb.tools.gui.views.query.ContinuousQueryRunable;
import org.bboxdb.tools.gui.views.query.ElementOverlayPainter;
import org.bboxdb.tools.gui.views.query.OverlayElementBuilder;
import org.bboxdb.tools.gui.views.query.OverlayElementGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryWindow {
    private static final String QUERY_NONE = "---";
    private static final String QUERY_RANGE = "Range query";
    private static final String QUERY_JOIN = "Spatial join";
    private static final String QUERY_RANGE_CONTINUOUS = "Continuous range query";
    private static final String QUERY_JOIN_CONTINUOUS = "Continuous spatial join";
    private static final String QUERY_PREDEFINED_NONE = "----";
    private static final String QUERY_PREDEFINED_STATIC_ROADS = "Roads (Static)";
    private static final String QUERY_PREDEFINED_STATIC_FOREST = "Forest (Static)";
    private static final String QUERY_PREDEFINED_AIRCRAFT = "Aircraft";
    private static final String QUERY_PREDEFINED_BUS = "Buses";
    private static final String QUERY_PREDEFINED_BUS_ROAD = "Buses joined with Road";
    private static final String QUERY_PREDEFINED_BUS_ELIZABETH = "Buses on Elizabeth Street";
    private static final String QUERY_PREDEFINED_BUS_BRIDGE = "Buses on a Bridge";
    private static final String QUERY_PREDEFINED_BUS_FOREST_BBOX = "Buses joined with Forest (bbox)";
    private static final String QUERY_PREDEFINED_BUS_FOREST_RELAXTED = "Buses joined with Forest (relaxed)";
    private static final String QUERY_PREDEFINED_BUS_FOREST_STRICT = "Buses joined with Forest (strict)";
    private static final String QUERY_PREDEFINED_STATIC_ROAD_VALUE = "Road with value";
    private static final String QUERY_PREDEFINED_STATIC_ROAD_FOREST_JOIN = "Road joined with Forest";
    private JFrame mainframe;
    private final GuiModel guimodel;
    private String selectedLatBegin = "-90";
    private String selectedLatEnd = "90";
    private String selectedLongBegin = "-180";
    private String selectedLongEnd = "180";
    private final ElementOverlayPainter painter;
    private static final String[] COLOR_NAMES = new String[]{"Red", "Green", "Blue", "Yellow", "Orange", "Pink"};
    private static final Color[] COLOR_VALUES = new Color[]{Color.RED, Color.GREEN, Color.BLUE, Color.YELLOW, Color.ORANGE, Color.PINK};
    private static final String[] BOOL_NAMES = new String[]{"Enabled", "Disabled"};
    private static final Boolean[] BOOL_VALUES = new Boolean[]{true, false};
    private static final String[] PREDEFINED_QUERIES = new String[]{"----", "Roads (Static)", "Forest (Static)", "Aircraft", "Buses", "Buses joined with Road", "Buses on Elizabeth Street", "Buses on a Bridge", "Buses joined with Forest (bbox)", "Buses joined with Forest (relaxed)", "Buses joined with Forest (strict)", "Road with value", "Road joined with Forest"};
    private List<Thread> backgroundThreads;
    private static final Logger logger = LoggerFactory.getLogger(QueryWindow.class);

    public QueryWindow(GuiModel guimodel, ElementOverlayPainter painter, List<Thread> backgroundThreads) {
        this.guimodel = guimodel;
        this.painter = painter;
        this.backgroundThreads = backgroundThreads;
    }

    public void show() {
        this.mainframe = new JFrame("BBoxDB - Execute query");
        PanelBuilder builder = this.buildDialog();
        this.mainframe.add(builder.getPanel());
        this.mainframe.pack();
        this.mainframe.setLocationRelativeTo(null);
        this.mainframe.setVisible(true);
    }

    private PanelBuilder buildDialog() {
        FormLayout layout = new FormLayout("right:pref, 3dlu, 120dlu, 10dlu, right:pref, 3dlu, 100dlu", "p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 9dlu, p");
        PanelBuilder builder = new PanelBuilder(layout);
        builder.setDefaultDialogBorder();
        List<String> allTables = this.guimodel.getAllTables();
        String[] allTableArray = allTables.toArray(new String[0]);
        CellConstraints cc = new CellConstraints();
        builder.addSeparator("Query", cc.xyw(1, 1, 3));
        builder.addLabel("Type", cc.xy(1, 3));
        String[] queries = new String[]{QUERY_NONE, QUERY_RANGE, QUERY_JOIN, QUERY_RANGE_CONTINUOUS, QUERY_JOIN_CONTINUOUS};
        JComboBox<String> queryTypeBox = new JComboBox<String>(queries);
        builder.add(queryTypeBox, cc.xy(3, 3));
        builder.addLabel("Table 1", cc.xy(1, 5));
        JComboBox<String> table1Field = new JComboBox<String>(allTableArray);
        table1Field.setEnabled(false);
        builder.add(table1Field, cc.xy(3, 5));
        builder.addLabel("Color for table 1", cc.xy(1, 7));
        JComboBox<String> table1ColorField = new JComboBox<String>(COLOR_NAMES);
        table1ColorField.setSelectedItem(COLOR_NAMES[0]);
        table1ColorField.setEnabled(false);
        builder.add(table1ColorField, cc.xy(3, 7));
        builder.addLabel("Table 2", cc.xy(1, 9));
        JComboBox<String> table2Field = new JComboBox<String>(allTableArray);
        table2Field.setEnabled(false);
        builder.add(table2Field, cc.xy(3, 9));
        builder.addLabel("Color for table 2", cc.xy(1, 11));
        JComboBox<String> table2ColorField = new JComboBox<String>(COLOR_NAMES);
        table2ColorField.setSelectedItem(COLOR_NAMES[2]);
        table2ColorField.setEnabled(false);
        builder.add(table2ColorField, cc.xy(3, 11));
        builder.addLabel("Receive watermarks", cc.xy(1, 13));
        JComboBox<String> receiveWatermarksField = new JComboBox<String>(BOOL_NAMES);
        receiveWatermarksField.setEnabled(false);
        builder.add(receiveWatermarksField, cc.xy(3, 13));
        builder.addLabel("Receive invalidations", cc.xy(1, 15));
        JComboBox<String> receiveInvalidationsField = new JComboBox<String>(BOOL_NAMES);
        receiveInvalidationsField.setEnabled(false);
        builder.add(receiveInvalidationsField, cc.xy(3, 15));
        builder.addSeparator("Predefined Queries", cc.xyw(1, 17, 3));
        builder.addLabel("Query", cc.xy(1, 19));
        JComboBox<String> predefinedQueriesBox = new JComboBox<String>(PREDEFINED_QUERIES);
        predefinedQueriesBox.setSelectedItem(PREDEFINED_QUERIES[0]);
        predefinedQueriesBox.setEnabled(true);
        builder.add(predefinedQueriesBox, cc.xy(3, 19));
        builder.addSeparator("Parameter", cc.xyw(5, 1, 3));
        builder.addLabel("Longitude begin", cc.xy(5, 3));
        JTextField longBegin = new JTextField();
        longBegin.setText(this.selectedLongBegin);
        builder.add((Component)longBegin, cc.xy(7, 3));
        builder.addLabel("Longitude end", cc.xy(5, 5));
        JTextField longEnd = new JTextField();
        longEnd.setText(this.selectedLongEnd);
        builder.add((Component)longEnd, cc.xy(7, 5));
        builder.addLabel("Latitude begin", cc.xy(5, 7));
        JTextField latBegin = new JTextField();
        latBegin.setText(this.selectedLatBegin);
        builder.add((Component)latBegin, cc.xy(7, 7));
        builder.addLabel("Latitude end", cc.xy(5, 9));
        JTextField latEnd = new JTextField();
        latEnd.setText(this.selectedLatEnd);
        builder.add((Component)latEnd, cc.xy(7, 9));
        builder.addLabel("UDF Name", cc.xy(5, 11));
        JTextField udfNameField = new JTextField();
        builder.add((Component)udfNameField, cc.xy(7, 11));
        builder.addLabel("UDF Value", cc.xy(5, 13));
        JTextField udfValueField = new JTextField();
        builder.add((Component)udfValueField, cc.xy(7, 13));
        JButton closeButton = new JButton();
        closeButton.setText("Close");
        closeButton.addActionListener(e -> this.mainframe.dispose());
        Action executeAction = this.getExecuteAction(queryTypeBox, table1Field, table1ColorField, table2Field, table2ColorField, longBegin, longEnd, latBegin, latEnd, udfNameField, udfValueField, receiveWatermarksField, receiveInvalidationsField);
        JButton executeButton = new JButton(executeAction);
        executeButton.setText("Execute");
        executeButton.setEnabled(false);
        this.addActionListener(queryTypeBox, predefinedQueriesBox, table1Field, table1ColorField, table2Field, table2ColorField, executeButton, udfNameField, udfValueField, receiveWatermarksField, receiveInvalidationsField);
        builder.add((Component)closeButton, cc.xy(5, 21));
        builder.add((Component)executeButton, cc.xy(7, 21));
        return builder;
    }

    private void addActionListener(JComboBox<String> queryTypeBox, JComboBox<String> predefinedQueriesBox, JComboBox<String> table1Field, JComboBox<String> table1ColorField, JComboBox<String> table2Field, JComboBox<String> table2ColorField, JButton executeButton, JTextField udfNameField, JTextField udfValueField, JComboBox<String> receiveWatermarksField, JComboBox<String> receiveInvalidationsField) {
        predefinedQueriesBox.addActionListener(l -> {
            String selectedPredefinedQuery;
            switch (selectedPredefinedQuery = predefinedQueriesBox.getSelectedItem().toString()) {
                case "----": {
                    udfNameField.setText("");
                    udfValueField.setText("");
                    queryTypeBox.setSelectedItem(QUERY_RANGE);
                    break;
                }
                case "Roads (Static)": {
                    udfNameField.setText("");
                    udfValueField.setText("");
                    table1Field.setSelectedItem("osmgroup_roads");
                    table1ColorField.setSelectedItem("Blue");
                    queryTypeBox.setSelectedItem(QUERY_RANGE);
                    executeButton.setEnabled(true);
                    table1Field.setEnabled(true);
                    table1ColorField.setEnabled(true);
                    table2Field.setEnabled(false);
                    table2ColorField.setEnabled(false);
                    receiveWatermarksField.setEnabled(false);
                    receiveInvalidationsField.setEnabled(false);
                    break;
                }
                case "Road with value": {
                    udfNameField.setText(UserDefinedGeoJsonSpatialFilter.class.getCanonicalName());
                    udfValueField.setText("lanes:4");
                    table1Field.setSelectedItem("osmgroup_roads");
                    table1ColorField.setSelectedItem("Blue");
                    queryTypeBox.setSelectedItem(QUERY_RANGE);
                    executeButton.setEnabled(true);
                    table1Field.setEnabled(true);
                    table1ColorField.setEnabled(true);
                    table2Field.setEnabled(false);
                    table2ColorField.setEnabled(false);
                    receiveWatermarksField.setEnabled(false);
                    receiveInvalidationsField.setEnabled(false);
                    break;
                }
                case "Road joined with Forest": {
                    udfNameField.setText(UserDefinedGeoJsonSpatialFilter.class.getCanonicalName());
                    udfValueField.setText("");
                    table1Field.setSelectedItem("osmgroup_roads");
                    table2Field.setSelectedItem("osmgroup_forests");
                    table1ColorField.setSelectedItem("Blue");
                    table2ColorField.setSelectedItem("Green");
                    queryTypeBox.setSelectedItem(QUERY_JOIN);
                    executeButton.setEnabled(true);
                    table1Field.setEnabled(true);
                    table1ColorField.setEnabled(true);
                    table2Field.setEnabled(true);
                    table2ColorField.setEnabled(true);
                    receiveWatermarksField.setEnabled(false);
                    receiveInvalidationsField.setEnabled(false);
                    break;
                }
                case "Forest (Static)": {
                    udfNameField.setText("");
                    udfValueField.setText("");
                    table1Field.setSelectedItem("osmgroup_forests");
                    table1ColorField.setSelectedItem("Green");
                    queryTypeBox.setSelectedItem(QUERY_RANGE);
                    executeButton.setEnabled(true);
                    table1Field.setEnabled(true);
                    table1ColorField.setEnabled(true);
                    table2Field.setEnabled(false);
                    table2ColorField.setEnabled(false);
                    receiveWatermarksField.setEnabled(false);
                    receiveInvalidationsField.setEnabled(false);
                    break;
                }
                case "Aircraft": {
                    udfNameField.setText("");
                    udfValueField.setText("");
                    table1Field.setSelectedItem("osmgroup_adsb");
                    queryTypeBox.setSelectedItem(QUERY_RANGE_CONTINUOUS);
                    executeButton.setEnabled(true);
                    table1Field.setEnabled(true);
                    table1ColorField.setEnabled(true);
                    table2Field.setEnabled(false);
                    table2ColorField.setEnabled(false);
                    receiveWatermarksField.setEnabled(true);
                    receiveInvalidationsField.setEnabled(true);
                    break;
                }
                case "Buses": {
                    udfNameField.setText("");
                    udfValueField.setText("");
                    table1Field.setSelectedItem("osmgroup_buses");
                    queryTypeBox.setSelectedItem(QUERY_RANGE_CONTINUOUS);
                    executeButton.setEnabled(true);
                    table1Field.setEnabled(true);
                    table1ColorField.setEnabled(true);
                    table2Field.setEnabled(false);
                    table2ColorField.setEnabled(false);
                    table2ColorField.setSelectedItem("Blue");
                    receiveWatermarksField.setEnabled(true);
                    receiveInvalidationsField.setEnabled(true);
                    break;
                }
                case "Buses joined with Road": {
                    udfNameField.setText(UserDefinedGeoJsonSpatialFilter.class.getCanonicalName());
                    udfValueField.setText("");
                    table1Field.setSelectedItem("osmgroup_buses");
                    table2Field.setSelectedItem("osmgroup_roads");
                    queryTypeBox.setSelectedItem(QUERY_JOIN_CONTINUOUS);
                    executeButton.setEnabled(true);
                    table1Field.setEnabled(true);
                    table1ColorField.setEnabled(true);
                    table2Field.setEnabled(true);
                    table2ColorField.setEnabled(true);
                    table2ColorField.setSelectedItem("Blue");
                    receiveWatermarksField.setEnabled(true);
                    receiveInvalidationsField.setEnabled(true);
                    break;
                }
                case "Buses on Elizabeth Street": {
                    udfNameField.setText(UserDefinedGeoJsonSpatialFilter.class.getCanonicalName());
                    udfValueField.setText("name:Elizabeth Street");
                    table1Field.setSelectedItem("osmgroup_buses");
                    table2Field.setSelectedItem("osmgroup_roads");
                    queryTypeBox.setSelectedItem(QUERY_JOIN_CONTINUOUS);
                    executeButton.setEnabled(true);
                    table1Field.setEnabled(true);
                    table1ColorField.setEnabled(true);
                    table2Field.setEnabled(true);
                    table2ColorField.setEnabled(true);
                    table2ColorField.setSelectedItem("Blue");
                    receiveWatermarksField.setEnabled(true);
                    receiveInvalidationsField.setEnabled(true);
                    break;
                }
                case "Buses on a Bridge": {
                    udfNameField.setText(UserDefinedGeoJsonSpatialFilter.class.getCanonicalName());
                    udfValueField.setText("bridge:yes");
                    table1Field.setSelectedItem("osmgroup_buses");
                    table2Field.setSelectedItem("osmgroup_roads");
                    queryTypeBox.setSelectedItem(QUERY_JOIN_CONTINUOUS);
                    executeButton.setEnabled(true);
                    table1Field.setEnabled(true);
                    table1ColorField.setEnabled(true);
                    table2Field.setEnabled(true);
                    table2ColorField.setEnabled(true);
                    table2ColorField.setSelectedItem("Blue");
                    receiveWatermarksField.setEnabled(true);
                    receiveInvalidationsField.setEnabled(true);
                    break;
                }
                case "Buses joined with Forest (bbox)": {
                    udfNameField.setText("");
                    udfValueField.setText("");
                    table1Field.setSelectedItem("osmgroup_buses");
                    table2Field.setSelectedItem("osmgroup_forests");
                    queryTypeBox.setSelectedItem(QUERY_JOIN_CONTINUOUS);
                    executeButton.setEnabled(true);
                    table1Field.setEnabled(true);
                    table1ColorField.setEnabled(true);
                    table2Field.setEnabled(true);
                    table2ColorField.setEnabled(true);
                    table2ColorField.setSelectedItem("Green");
                    receiveWatermarksField.setEnabled(true);
                    receiveInvalidationsField.setEnabled(true);
                    break;
                }
                case "Buses joined with Forest (relaxed)": {
                    udfNameField.setText(UserDefinedGeoJsonSpatialFilter.class.getCanonicalName());
                    udfValueField.setText("");
                    table1Field.setSelectedItem("osmgroup_buses");
                    table2Field.setSelectedItem("osmgroup_forests");
                    queryTypeBox.setSelectedItem(QUERY_JOIN_CONTINUOUS);
                    executeButton.setEnabled(true);
                    table1Field.setEnabled(true);
                    table1ColorField.setEnabled(true);
                    table2Field.setEnabled(true);
                    table2ColorField.setEnabled(true);
                    table2ColorField.setSelectedItem("Green");
                    receiveWatermarksField.setEnabled(true);
                    receiveInvalidationsField.setEnabled(true);
                    break;
                }
                case "Buses joined with Forest (strict)": {
                    udfNameField.setText(UserDefinedGeoJsonSpatialFilterStrict.class.getCanonicalName());
                    udfValueField.setText("");
                    table1Field.setSelectedItem("osmgroup_buses");
                    table2Field.setSelectedItem("osmgroup_forests");
                    queryTypeBox.setSelectedItem(QUERY_JOIN_CONTINUOUS);
                    executeButton.setEnabled(true);
                    table1Field.setEnabled(true);
                    table1ColorField.setEnabled(true);
                    table2Field.setEnabled(true);
                    table2ColorField.setEnabled(true);
                    table2ColorField.setSelectedItem("Green");
                    receiveWatermarksField.setEnabled(true);
                    receiveInvalidationsField.setEnabled(true);
                    break;
                }
                default: {
                    logger.error("Unknown selection: " + selectedPredefinedQuery);
                }
            }
        });
        queryTypeBox.addActionListener(l -> {
            String selectedQuery;
            if (!predefinedQueriesBox.getSelectedItem().toString().equals(QUERY_PREDEFINED_NONE)) {
                return;
            }
            switch (selectedQuery = queryTypeBox.getSelectedItem().toString()) {
                case "Range query": {
                    table1Field.setEnabled(true);
                    table1ColorField.setEnabled(true);
                    table2Field.setEnabled(false);
                    table2ColorField.setEnabled(false);
                    executeButton.setEnabled(true);
                    udfNameField.setText("");
                    udfValueField.setText("");
                    receiveWatermarksField.setEnabled(false);
                    receiveInvalidationsField.setEnabled(false);
                    break;
                }
                case "Continuous range query": {
                    table1Field.setEnabled(true);
                    table1ColorField.setEnabled(true);
                    table2Field.setEnabled(false);
                    table2ColorField.setEnabled(false);
                    executeButton.setEnabled(true);
                    udfNameField.setText("");
                    udfValueField.setText("");
                    receiveWatermarksField.setEnabled(true);
                    receiveInvalidationsField.setEnabled(true);
                    break;
                }
                case "Spatial join": {
                    table1Field.setEnabled(true);
                    table1ColorField.setEnabled(true);
                    table2Field.setEnabled(true);
                    table2ColorField.setEnabled(true);
                    executeButton.setEnabled(true);
                    udfNameField.setText("");
                    udfValueField.setText("");
                    receiveWatermarksField.setEnabled(false);
                    receiveInvalidationsField.setEnabled(false);
                    break;
                }
                case "Continuous spatial join": {
                    table1Field.setEnabled(true);
                    table1ColorField.setEnabled(true);
                    table2Field.setEnabled(true);
                    table2ColorField.setEnabled(true);
                    executeButton.setEnabled(true);
                    udfNameField.setText("");
                    udfValueField.setText("");
                    receiveWatermarksField.setEnabled(true);
                    receiveInvalidationsField.setEnabled(true);
                    break;
                }
                default: {
                    table1Field.setEnabled(false);
                    table1ColorField.setEnabled(false);
                    table2Field.setEnabled(false);
                    table1ColorField.setEnabled(false);
                    executeButton.setEnabled(false);
                    udfNameField.setText("");
                    udfValueField.setText("");
                }
            }
        });
    }

    private Action getExecuteAction(final JComboBox<String> queryTypeBox, final JComboBox<String> table1Field, final JComboBox<String> color1Box, final JComboBox<String> table2Field, final JComboBox<String> color2Box, final JTextField longBegin, final JTextField longEnd, final JTextField latBegin, final JTextField latEnd, final JTextField filterField, final JTextField valueField, final JComboBox<String> receiveWatermarksField, final JComboBox<String> receiveInvalidationsField) {
        AbstractAction ececuteAction = new AbstractAction(){
            private static final long serialVersionUID = 6307940821474247538L;

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    String queryType = queryTypeBox.getSelectedItem().toString();
                    String table1 = table1Field.getSelectedItem().toString();
                    String table2 = table2Field.getSelectedItem().toString();
                    String filter = filterField.getText();
                    String value = valueField.getText();
                    double longBeginDouble = MathUtil.tryParseDouble((String)longBegin.getText(), () -> "Unable to parse value");
                    double longEndDouble = MathUtil.tryParseDouble((String)longEnd.getText(), () -> "Unable to parse value");
                    double latBeginDouble = MathUtil.tryParseDouble((String)latBegin.getText(), () -> "Unable to parse value");
                    double latEndDouble = MathUtil.tryParseDouble((String)latEnd.getText(), () -> "Unable to parse value");
                    Hyperrectangle resultBox = new Hyperrectangle(new Double[]{latBeginDouble, latEndDouble, longBeginDouble, longEndDouble});
                    Color color1 = COLOR_VALUES[color1Box.getSelectedIndex()];
                    Color color2 = COLOR_VALUES[color2Box.getSelectedIndex()];
                    boolean receiveWatermarks = BOOL_VALUES[receiveWatermarksField.getSelectedIndex()];
                    boolean receiveInvalidations = BOOL_VALUES[receiveInvalidationsField.getSelectedIndex()];
                    switch (queryType) {
                        case "Range query": {
                            this.executeRangeQuery(resultBox, table1, color1, filter, value);
                            break;
                        }
                        case "Spatial join": {
                            this.executeJoinQuery(resultBox, table1, color1, table2, color2, filter, value);
                            break;
                        }
                        case "Continuous range query": {
                            this.executeRangeQueryContinuous(resultBox, table1, color1, filter, value, receiveWatermarks, receiveInvalidations);
                            break;
                        }
                        case "Continuous spatial join": {
                            this.executeJoinQueryContinuous(resultBox, table1, table2, color1, color2, filter, value, receiveWatermarks, receiveInvalidations);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unknown action: " + queryType);
                        }
                    }
                    QueryWindow.this.mainframe.dispose();
                }
                catch (InputParseException exception) {
                    JOptionPane.showMessageDialog(QueryWindow.this.mainframe, "Got an error: " + exception.getMessage());
                }
            }

            private void executeJoinQuery(Hyperrectangle bbox, String table1, Color color1, String table2, Color color2, String customFilter, String customValue) {
                try {
                    ArrayList<UserDefinedFilterDefinition> udfs = new ArrayList<UserDefinedFilterDefinition>();
                    if (customFilter.length() > 1) {
                        UserDefinedFilterDefinition udf = new UserDefinedFilterDefinition(customFilter, customValue);
                        udfs.add(udf);
                    }
                    Stopwatch stopwatch = Stopwatch.createStarted();
                    JoinedTupleListFuture result = QueryWindow.this.guimodel.getConnection().querySpatialJoin(Arrays.asList(table1, table2), bbox, udfs);
                    result.waitForCompletion();
                    stopwatch.stop();
                    if (result.isFailed()) {
                        logger.error("Got an error" + result.getAllMessages());
                        return;
                    }
                    ArrayList<OverlayElementGroup> elements = new ArrayList<OverlayElementGroup>();
                    List<Color> colors = Arrays.asList(color1, color2);
                    for (MultiTuple joinedTuple : result) {
                        OverlayElementGroup group = OverlayElementBuilder.createOverlayElementGroup(joinedTuple, colors);
                        elements.add(group);
                    }
                    logger.info("Got {}\u00a0tuples back in {} / {}\u00a0ms", new Object[]{elements.size(), result.getCompletionTime(TimeUnit.MILLISECONDS), stopwatch.elapsed(TimeUnit.MILLISECONDS)});
                    QueryWindow.this.painter.addElementToDrawBulk(elements);
                }
                catch (BBoxDBException e) {
                    logger.error("Got error while performing query", (Throwable)e);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }

            private void executeRangeQuery(Hyperrectangle bbox, String table, Color color, String customFilter, String customValue) {
                try {
                    ArrayList<UserDefinedFilterDefinition> udfs = new ArrayList<UserDefinedFilterDefinition>();
                    if (customFilter.length() > 1) {
                        UserDefinedFilterDefinition udf = new UserDefinedFilterDefinition(customFilter, customValue);
                        udfs.add(udf);
                    }
                    Stopwatch stopwatch = Stopwatch.createStarted();
                    TupleListFuture result = QueryWindow.this.guimodel.getConnection().queryRectangle(table, bbox, udfs);
                    result.waitForCompletion();
                    stopwatch.stop();
                    if (result.isFailed()) {
                        logger.error("Got an error" + result.getAllMessages());
                        return;
                    }
                    ArrayList<OverlayElementGroup> elements = new ArrayList<OverlayElementGroup>();
                    for (Tuple tuple : result) {
                        OverlayElementGroup overlayElement = OverlayElementBuilder.createOverlayElementGroup(tuple, table, color);
                        elements.add(overlayElement);
                    }
                    logger.info("Got {}\u00a0tuples back in {} / {}\u00a0ms", new Object[]{elements.size(), result.getCompletionTime(TimeUnit.MILLISECONDS), stopwatch.elapsed(TimeUnit.MILLISECONDS)});
                    QueryWindow.this.painter.addElementToDrawBulk(elements);
                }
                catch (BBoxDBException e) {
                    logger.error("Got error while performing query", (Throwable)e);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }

            private void executeJoinQueryContinuous(Hyperrectangle bbox, String table1, String table2, Color color1, Color color2, String customFilter, String customValue, boolean receiveWatermarks, boolean receiveInvalidations) {
                QueryPlanBuilder qpb = QueryPlanBuilder.createQueryOnTable((String)table1).spatialJoinWithTable(table2).forAllNewTuplesInSpace(bbox);
                if (customFilter.length() > 2) {
                    UserDefinedFilterDefinition userDefinedFilter = new UserDefinedFilterDefinition(customFilter, customValue);
                    qpb.addJoinFilter(userDefinedFilter);
                }
                if (receiveWatermarks) {
                    qpb.receiveWatermarks();
                }
                if (receiveInvalidations) {
                    qpb.receiveInvalidations();
                }
                BBoxDBCluster connection = QueryWindow.this.guimodel.getConnection();
                List<Color> colors = Arrays.asList(color1, color2);
                ContinuousQueryPlan qp = qpb.build();
                this.startQueryRunable(qp, connection, colors);
            }

            private void startQueryRunable(ContinuousQueryPlan qp, BBoxDBCluster connection, List<Color> colors) {
                ContinuousQueryRunable runable = new ContinuousQueryRunable(colors, qp, connection, QueryWindow.this.painter);
                Thread fetchThread = new Thread((Runnable)((Object)runable));
                QueryWindow.this.backgroundThreads.add(fetchThread);
                fetchThread.start();
            }

            private void executeRangeQueryContinuous(Hyperrectangle bbox, String table, Color color, String customFilter, String customValue, boolean receiveWatermarks, boolean receiveInvalidations) {
                QueryPlanBuilder qpb = QueryPlanBuilder.createQueryOnTable((String)table).forAllNewTuplesInSpace(bbox).compareWithStaticSpace(bbox);
                if (customFilter.length() > 2) {
                    UserDefinedFilterDefinition userDefinedFilter = new UserDefinedFilterDefinition(customFilter, customValue);
                    qpb.addStreamFilter(userDefinedFilter);
                }
                if (receiveWatermarks) {
                    qpb.receiveWatermarks();
                }
                if (receiveInvalidations) {
                    qpb.receiveInvalidations();
                }
                BBoxDBCluster connection = QueryWindow.this.guimodel.getConnection();
                ContinuousQueryPlan qp = qpb.build();
                List<Color> colors = Arrays.asList(color);
                this.startQueryRunable(qp, connection, colors);
            }
        };
        return ececuteAction;
    }

    public void setSelectedLatBegin(String selectedLatBegin) {
        this.selectedLatBegin = selectedLatBegin;
    }

    public void setSelectedLatEnd(String selectedLatEnd) {
        this.selectedLatEnd = selectedLatEnd;
    }

    public void setSelectedLongBegin(String selectedLongBegin) {
        this.selectedLongBegin = selectedLongBegin;
    }

    public void setSelectedLongEnd(String selectedLongEnd) {
        this.selectedLongEnd = selectedLongEnd;
    }
}

