/*
 * Decompiled with CFR 0.152.
 */
package org.bboxdb.tools.gui.views.query;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import org.bboxdb.commons.math.GeoJsonPolygon;
import org.bboxdb.tools.gui.views.query.DetailsWindow;
import org.bboxdb.tools.gui.views.query.OverlayElement;
import org.jxmapviewer.JXMapViewer;

public class ResultDetailsWindow {
    private List<OverlayElement> renderedElements;
    private final JFrame mainframe = new JFrame("BBoxDB - Query result view");
    private final AbstractTableModel tableModel = this.buildTableModel();
    private JXMapViewer mapViewer;

    public ResultDetailsWindow() {
        JPanel panel = this.buildDialog();
        this.mainframe.add(panel);
    }

    private AbstractTableModel buildTableModel() {
        AbstractTableModel tableModel = new AbstractTableModel(){
            private static final long serialVersionUID = -5660979952458001100L;

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                OverlayElement overlayElement = (OverlayElement)ResultDetailsWindow.this.renderedElements.get(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return overlayElement.getSourceTable();
                    }
                    case 1: {
                        return overlayElement.getPolygon().getId();
                    }
                    case 2: {
                        return this.getKeyStringForOverlay(overlayElement);
                    }
                    case 3: {
                        return overlayElement.getPolygon().toGeoJson();
                    }
                }
                throw new IllegalArgumentException("Unable to get a column for: " + columnIndex);
            }

            private String getKeyStringForOverlay(OverlayElement overlayElement) {
                StringBuilder sb = new StringBuilder();
                GeoJsonPolygon polygon = overlayElement.getPolygon();
                Map properties = polygon.getProperties();
                for (Map.Entry entry : properties.entrySet()) {
                    if (sb.length() != 0) {
                        sb.append(", ");
                    } else {
                        sb.append("<html>");
                    }
                    sb.append("<b>" + (String)entry.getKey() + "</b>");
                    sb.append("=");
                    sb.append((String)entry.getValue());
                }
                sb.append("</html>");
                return sb.toString();
            }

            @Override
            public int getRowCount() {
                return ResultDetailsWindow.this.renderedElements.size();
            }

            @Override
            public int getColumnCount() {
                return 4;
            }

            @Override
            public String getColumnName(int column) {
                switch (column) {
                    case 0: {
                        return "Table";
                    }
                    case 1: {
                        return "OSM-ID";
                    }
                    case 2: {
                        return "Tags";
                    }
                    case 3: {
                        return "GeoJSON";
                    }
                }
                throw new IllegalArgumentException("Unable to get a column name for: " + column);
            }
        };
        return tableModel;
    }

    public void show() {
        this.mainframe.pack();
        this.mainframe.setLocationRelativeTo(null);
        this.mainframe.setVisible(true);
    }

    private JPanel buildDialog() {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        JComponent jTable = this.buildJTable();
        mainPanel.add((Component)jTable, "Center");
        JButton closeButton = this.getCloseButton();
        mainPanel.add((Component)closeButton, "South");
        return mainPanel;
    }

    private JComponent buildJTable() {
        JTable table = new JTable(this.tableModel);
        table.getSelectionModel().addListSelectionListener(l -> {
            if (l.getValueIsAdjusting()) {
                return;
            }
            for (OverlayElement element : this.renderedElements) {
                element.setSelected(false);
            }
            int[] selectedRows = table.getSelectedRows();
            for (int i = 0; i < selectedRows.length; ++i) {
                int selectedRow = selectedRows[i];
                this.renderedElements.get(selectedRow).setSelected(true);
            }
            this.mapViewer.repaint();
        });
        table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                JTable table = (JTable)mouseEvent.getSource();
                Point point = mouseEvent.getPoint();
                int row = table.rowAtPoint(point);
                if (mouseEvent.getClickCount() == 2 && table.getSelectedRow() != -1) {
                    OverlayElement element = (OverlayElement)ResultDetailsWindow.this.renderedElements.get(row);
                    DetailsWindow detailsWindow = new DetailsWindow(element.getPolygon());
                    detailsWindow.show();
                }
            }
        });
        table.getColumnModel().getColumn(0).setMinWidth(140);
        table.getColumnModel().getColumn(0).setMaxWidth(140);
        table.getColumnModel().getColumn(1).setMinWidth(100);
        table.getColumnModel().getColumn(1).setMaxWidth(100);
        return new JScrollPane(table);
    }

    private JButton getCloseButton() {
        JButton closeButton = new JButton("Close");
        closeButton.addActionListener(l -> this.mainframe.setVisible(false));
        return closeButton;
    }

    public void setRenderedElements(List<OverlayElement> renderedElements) {
        this.renderedElements = renderedElements;
        if (this.mainframe.isVisible()) {
            this.tableModel.fireTableDataChanged();
        }
    }

    public void setMapViewer(JXMapViewer mapViewer) {
        this.mapViewer = mapViewer;
    }
}

