/*
 * Decompiled with CFR 0.152.
 */
package org.bboxdb.tools.gui.views.regiondepended.osm;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import org.bboxdb.commons.math.Hyperrectangle;
import org.bboxdb.distribution.partitioner.DistributionRegionState;
import org.bboxdb.distribution.region.DistributionRegion;
import org.bboxdb.misc.BBoxDBException;
import org.bboxdb.tools.gui.GuiModel;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.painter.Painter;
import org.jxmapviewer.viewer.GeoPosition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSMOverlayPainter
implements Painter<JXMapViewer> {
    protected static final double MAX_LAT = 85.0;
    protected static final double MIN_LAT = -85.0;
    protected static final double MAX_LONG = 180.0;
    protected static final double MIN_LONG = -180.0;
    protected final Hyperrectangle coverBox = new Hyperrectangle(new Double[]{-85.0, 85.0, -180.0, 180.0});
    protected GuiModel guiModel;
    private static final Logger logger = LoggerFactory.getLogger(OSMOverlayPainter.class);

    public OSMOverlayPainter(GuiModel guiModel) {
        this.guiModel = guiModel;
    }

    public void paint(Graphics2D g, JXMapViewer map, int w, int h) {
        Graphics2D graphicsContext = (Graphics2D)g.create();
        Rectangle rect = map.getViewportBounds();
        graphicsContext.translate(-rect.x, -rect.y);
        graphicsContext.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphicsContext.setColor(Color.BLACK);
        graphicsContext.setStroke(new BasicStroke(2.0f));
        this.drawDistribution(graphicsContext, map);
        graphicsContext.dispose();
    }

    protected void drawDistribution(Graphics2D graphicsContext, JXMapViewer map) {
        try {
            if (this.guiModel.getTreeAdapter() == null || this.guiModel.getTreeAdapter().getRootNode() == null) {
                return;
            }
            DistributionRegion distributionRegion = this.guiModel.getTreeAdapter().getRootNode();
            Hyperrectangle bbox = distributionRegion.getConveringBox();
            if (bbox.getDimension() != 2) {
                System.err.println("Unable to print dimensions: " + bbox.getDimension());
                return;
            }
            this.drawBoundingBox(graphicsContext, map, distributionRegion);
        }
        catch (BBoxDBException e) {
            logger.error("Got an exception", (Throwable)e);
        }
    }

    protected void drawBoundingBox(Graphics2D graphicsContext, JXMapViewer map, DistributionRegion distributionRegion) {
        DistributionRegionState state = distributionRegion.getState();
        if (state == DistributionRegionState.ACTIVE || state == DistributionRegionState.ACTIVE_FULL) {
            Hyperrectangle bbox = distributionRegion.getConveringBox();
            Hyperrectangle paintBox = bbox.getIntersection(this.coverBox);
            GeoPosition bl = new GeoPosition(paintBox.getCoordinateLow(0), paintBox.getCoordinateLow(1));
            GeoPosition br = new GeoPosition(paintBox.getCoordinateLow(0), paintBox.getCoordinateHigh(1));
            GeoPosition ul = new GeoPosition(paintBox.getCoordinateHigh(0), paintBox.getCoordinateLow(1));
            GeoPosition ur = new GeoPosition(paintBox.getCoordinateHigh(0), paintBox.getCoordinateHigh(1));
            this.drawLine(graphicsContext, bl, br, map);
            this.drawLine(graphicsContext, br, ur, map);
            this.drawLine(graphicsContext, ur, ul, map);
            this.drawLine(graphicsContext, ul, bl, map);
        }
        for (DistributionRegion region : distributionRegion.getDirectChildren()) {
            this.drawBoundingBox(graphicsContext, map, region);
        }
    }

    protected void drawLine(Graphics2D graphicsContext, GeoPosition begin, GeoPosition end, JXMapViewer map) {
        Point2D beginPoint = map.getTileFactory().geoToPixel(begin, map.getZoom());
        Point2D endPoint = map.getTileFactory().geoToPixel(end, map.getZoom());
        graphicsContext.drawLine((int)beginPoint.getX(), (int)beginPoint.getY(), (int)endPoint.getX(), (int)endPoint.getY());
    }
}

