/*
 * Decompiled with CFR 0.152.
 */
package org.bboxdb.tools.gui.views.regiondepended.osm;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.bboxdb.tools.gui.GuiModel;
import org.bboxdb.tools.gui.util.MapViewerFactory;
import org.bboxdb.tools.gui.views.View;
import org.bboxdb.tools.gui.views.regiondepended.osm.OSMOverlayPainter;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.painter.Painter;

public class OSMView
implements View {
    private final GuiModel guiModel;
    private JXMapViewer mapViewer;

    public OSMView(GuiModel guiModel) {
        this.guiModel = guiModel;
    }

    @Override
    public JPanel getJPanel() {
        this.mapViewer = this.createMapViewer();
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        mainPanel.add((Component)this.mapViewer, "Center");
        JPanel buttonPanel = new JPanel();
        mainPanel.add((Component)buttonPanel, "South");
        JButton zoomInButton = MapViewerFactory.getZoomInButton(this.mapViewer);
        buttonPanel.add(zoomInButton);
        JButton zoomOutButton = MapViewerFactory.getZoomOutButton(this.mapViewer);
        buttonPanel.add(zoomOutButton);
        JButton showWorldButton = MapViewerFactory.getShowWorldButton(this.mapViewer);
        buttonPanel.add(showWorldButton);
        JButton showGermanyButton = MapViewerFactory.getShowGermanyButton(this.mapViewer);
        buttonPanel.add(showGermanyButton);
        JButton showHagenButton = MapViewerFactory.getShowHagenButton(this.mapViewer);
        buttonPanel.add(showHagenButton);
        JButton showBerlinButton = MapViewerFactory.getShowBerlinButton(this.mapViewer);
        buttonPanel.add(showBerlinButton);
        JButton showSydneyButton = MapViewerFactory.getShowSydneyButton(this.mapViewer);
        buttonPanel.add(showSydneyButton);
        return mainPanel;
    }

    private JXMapViewer createMapViewer() {
        JXMapViewer mapViewer = MapViewerFactory.createMapViewer();
        OSMOverlayPainter distributionPainter = new OSMOverlayPainter(this.guiModel);
        mapViewer.setOverlayPainter((Painter)distributionPainter);
        return mapViewer;
    }

    @Override
    public boolean isGroupSelectionNeeded() {
        return true;
    }
}

