/*
 * Decompiled with CFR 0.152.
 */
package org.bboxdb.tools.gui.views.regiondepended.tree;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import org.bboxdb.commons.math.Hyperrectangle;
import org.bboxdb.distribution.region.DistributionRegion;
import org.bboxdb.misc.BBoxDBException;
import org.bboxdb.tools.gui.DistributionRegionComponent;
import org.bboxdb.tools.gui.GuiModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeJPanel
extends JPanel {
    private static final long serialVersionUID = -248493308846818192L;
    protected final List<DistributionRegionComponent> regions = new ArrayList<DistributionRegionComponent>();
    protected Dimension componentSize;
    protected final GuiModel guiModel;
    private static final int PADDING_TOP_BOTTOM = 10;
    private static final int PADDING_LEFT_RIGHT = 40;
    protected int rootPosX;
    protected final int rootPosY;
    private double zoomFactor;
    private static final Logger logger = LoggerFactory.getLogger(TreeJPanel.class);

    public TreeJPanel(GuiModel guiModel) {
        this.guiModel = guiModel;
        this.rootPosX = 1000;
        this.rootPosY = 30;
        this.zoomFactor = 1.0;
        this.setToolTipText("");
        MouseAdapter adapter = this.buildMouseAdapter();
        this.addMouseListener(adapter);
        this.addMouseMotionListener(adapter);
    }

    private MouseAdapter buildMouseAdapter() {
        MouseAdapter adapter = new MouseAdapter(){
            private Point origin;

            @Override
            public void mousePressed(MouseEvent e) {
                this.origin = new Point(e.getPoint());
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (this.origin == null) {
                    return;
                }
                JViewport viewPort = (JViewport)SwingUtilities.getAncestorOfClass(JViewport.class, TreeJPanel.this);
                if (viewPort == null) {
                    return;
                }
                int deltaX = this.origin.x - e.getX();
                int deltaY = this.origin.y - e.getY();
                Rectangle view = viewPort.getViewRect();
                view.x += deltaX;
                view.y += deltaY;
                TreeJPanel.this.scrollRectToVisible(view);
            }
        };
        return adapter;
    }

    protected Hyperrectangle drawDistributionRegion(Graphics2D graphics2d) {
        Hyperrectangle minBoundingBox = Hyperrectangle.FULL_SPACE;
        for (DistributionRegionComponent component : this.regions) {
            Hyperrectangle boundingBox = component.drawComponent(graphics2d);
            minBoundingBox = Hyperrectangle.getCoveringBox((Hyperrectangle)boundingBox, (Hyperrectangle)minBoundingBox);
        }
        return minBoundingBox;
    }

    protected void createDistribtionRegionComponents(DistributionRegion distributionRegion, int maxChildren) {
        if (distributionRegion == null) {
            return;
        }
        DistributionRegionComponent distributionRegionComponent = new DistributionRegionComponent(distributionRegion, this, this.guiModel, maxChildren);
        this.regions.add(distributionRegionComponent);
        for (DistributionRegion region : distributionRegion.getDirectChildren()) {
            this.createDistribtionRegionComponents(region, maxChildren);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.setBackground(Color.WHITE);
        if (this.guiModel.getTreeAdapter() == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)g;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.scale(this.zoomFactor, this.zoomFactor);
        try {
            DistributionRegion distributionRegion = this.guiModel.getTreeAdapter().getRootNode();
            this.regions.clear();
            if (distributionRegion == null) {
                logger.error("Got null root node");
                return;
            }
            int maxChildren = distributionRegion.getThisAndChildRegions().stream().mapToInt(r -> r.getDirectChildren().size()).max().orElse(0);
            this.rootPosX = 100000;
            this.createDistribtionRegionComponents(distributionRegion, maxChildren);
            this.calculateRootNodeXPos();
            Hyperrectangle drawBox = this.drawDistributionRegion(graphics2D);
            this.updateComponentSize(drawBox);
        }
        catch (BBoxDBException e) {
            logger.error("Got an exception", (Throwable)e);
        }
    }

    protected void calculateRootNodeXPos() {
        if (this.regions.isEmpty()) {
            return;
        }
        Hyperrectangle minBoundingBox = Hyperrectangle.FULL_SPACE;
        for (DistributionRegionComponent component : this.regions) {
            minBoundingBox = Hyperrectangle.getCoveringBox((Hyperrectangle)component.getBoundingBox(), (Hyperrectangle)minBoundingBox);
        }
        double rootCoordinateLow = this.regions.get(0).getBoundingBox().getCoordinateLow(0);
        double bboxCoordinateLow = minBoundingBox.getCoordinateLow(0);
        int rootOffsetBBox = (int)(rootCoordinateLow - bboxCoordinateLow) + 40;
        int rootOffsetWindowSize = (int)((this.getVisibleRect().getWidth() - 120.0) / 2.0);
        this.rootPosX = Math.max(rootOffsetBBox, rootOffsetWindowSize);
    }

    protected void updateComponentSize(Hyperrectangle boundingBox) {
        int preferedHeight;
        if (boundingBox == Hyperrectangle.FULL_SPACE) {
            return;
        }
        int preferedWidth = (int)((boundingBox.getCoordinateHigh(0) + 80.0) * this.zoomFactor);
        Dimension boundingBoxSize = new Dimension(preferedWidth, preferedHeight = (int)((boundingBox.getCoordinateHigh(1) + 20.0 + (double)this.rootPosY) * this.zoomFactor));
        if (!boundingBoxSize.equals(this.componentSize)) {
            this.componentSize = boundingBoxSize;
            this.setPreferredSize(boundingBoxSize);
            this.setMinimumSize(boundingBoxSize);
            this.revalidate();
            this.repaint();
        }
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        MouseEvent scaledEvent = new MouseEvent(event.getComponent(), event.getID(), event.getWhen(), event.getModifiers(), (int)((double)event.getX() / this.zoomFactor), (int)((double)event.getY() / this.zoomFactor), event.getClickCount(), event.isPopupTrigger());
        for (DistributionRegionComponent component : this.regions) {
            if (!component.isMouseOver(scaledEvent)) continue;
            return component.getToolTipText();
        }
        this.setToolTipText(null);
        return super.getToolTipText(event);
    }

    public int getRootPosX() {
        return this.rootPosX;
    }

    public int getRootPosY() {
        return this.rootPosY;
    }

    public double getZoomFactor() {
        return this.zoomFactor;
    }

    public void setZoomFactor(double zoomFactor) {
        this.zoomFactor = zoomFactor;
        this.revalidate();
        this.repaint();
    }
}

