/*
 * Decompiled with CFR 0.152.
 */
package org.bboxdb.tools.gui.views.regiondepended.tree;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.bboxdb.commons.MathUtil;
import org.bboxdb.tools.gui.GuiModel;
import org.bboxdb.tools.gui.views.View;
import org.bboxdb.tools.gui.views.regiondepended.tree.TreeJPanel;

public class TreeView
implements View {
    private final GuiModel guiModel;

    public TreeView(GuiModel guiModel) {
        this.guiModel = guiModel;
    }

    @Override
    public JComponent getJPanel() {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        TreeJPanel jTreeComponent = new TreeJPanel(this.guiModel);
        JScrollPane rightScrollPanel = new JScrollPane(jTreeComponent);
        mainPanel.setPreferredSize(new Dimension(1000, 600));
        jTreeComponent.setPreferredSize(new Dimension(800, 550));
        mainPanel.add((Component)rightScrollPanel, "Center");
        JPanel buttonPanel = new JPanel();
        mainPanel.add((Component)buttonPanel, "South");
        JTextField textField = new JTextField();
        textField.setText(Double.toString(MathUtil.round((double)jTreeComponent.getZoomFactor(), (int)1)));
        JButton zoomInButton = this.getZoomInButton(jTreeComponent, textField);
        buttonPanel.add(zoomInButton);
        JButton zoomOutButton = this.getZoomOutButton(jTreeComponent, textField);
        buttonPanel.add(zoomOutButton);
        buttonPanel.add(textField);
        return mainPanel;
    }

    protected JButton getZoomInButton(TreeJPanel jTreeComponent, JTextField textField) {
        JButton zoomInButton = new JButton("Zoom in");
        zoomInButton.addActionListener(l -> {
            jTreeComponent.setZoomFactor(jTreeComponent.getZoomFactor() * 1.1);
            textField.setText(Double.toString(jTreeComponent.getZoomFactor()));
            textField.setText(Double.toString(MathUtil.round((double)jTreeComponent.getZoomFactor(), (int)1)));
        });
        return zoomInButton;
    }

    protected JButton getZoomOutButton(TreeJPanel jTreeComponent, JTextField textField) {
        JButton zoomOutButton = new JButton("Zoom out");
        zoomOutButton.addActionListener(l -> {
            jTreeComponent.setZoomFactor(jTreeComponent.getZoomFactor() * 0.9);
            textField.setText(Double.toString(MathUtil.round((double)jTreeComponent.getZoomFactor(), (int)1)));
        });
        return zoomOutButton;
    }

    @Override
    public boolean isGroupSelectionNeeded() {
        return true;
    }
}

