/*
 * Decompiled with CFR 0.152.
 */
package org.bboxdb.tools.helper;

import java.util.ArrayList;
import java.util.concurrent.ThreadLocalRandom;
import org.bboxdb.commons.math.DoubleInterval;
import org.bboxdb.commons.math.Hyperrectangle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RandomHyperrectangleGenerator {
    private static final Logger logger = LoggerFactory.getLogger(RandomHyperrectangleGenerator.class);

    public static Hyperrectangle generateRandomHyperrectangle(Hyperrectangle completeSpace, double percentage) {
        logger.debug("Generating a random hyperrectangle with a coverage of {}\u00a0percent", (Object)percentage);
        Hyperrectangle scaledRectangle = completeSpace.scaleVolumeByPercentage(percentage);
        if (scaledRectangle == null) {
            logger.error("Unable to scale {}", (Object)completeSpace);
            return completeSpace;
        }
        if (percentage <= 0.0 || percentage > 1.0) {
            logger.error("Unable to generate random space. Percentage has to be in interval (0, 1] (provided {})", (Object)percentage);
            return completeSpace;
        }
        ArrayList<DoubleInterval> bboxIntervals = new ArrayList<DoubleInterval>();
        for (int dimension = 0; dimension < scaledRectangle.getDimension(); ++dimension) {
            double dataExtentCompleteRange = completeSpace.getExtent(dimension);
            double extendRange = scaledRectangle.getExtent(dimension);
            double offsetRage = dataExtentCompleteRange - extendRange;
            double randomDouble = ThreadLocalRandom.current().nextDouble();
            double bboxOffset = Math.abs(randomDouble % 1.0 * offsetRage);
            DoubleInterval doubleInterval = new DoubleInterval(completeSpace.getCoordinateLow(dimension) + bboxOffset, completeSpace.getCoordinateLow(dimension) + bboxOffset + extendRange);
            bboxIntervals.add(doubleInterval);
        }
        Hyperrectangle generatedHyperrectangle = new Hyperrectangle(bboxIntervals);
        logger.debug("Complete space {} / generated {}", (Object)completeSpace, (Object)generatedHyperrectangle);
        return generatedHyperrectangle;
    }
}

