/*
 * Decompiled with CFR 0.152.
 */
package org.bboxdb.tools.network;

import java.io.BufferedReader;
import java.io.File;
import java.nio.file.Files;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import org.bboxdb.commons.MathUtil;
import org.bboxdb.commons.math.GeoJsonPolygon;
import org.bboxdb.misc.Const;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalyzeAuData
implements Runnable {
    private final File file;
    private static final Logger logger = LoggerFactory.getLogger(AnalyzeAuData.class);

    public AnalyzeAuData(File file) {
        this.file = file;
    }

    @Override
    public void run() {
        try (BufferedReader reader = Files.newBufferedReader(this.file.toPath(), Const.DEFAULT_CHARSET);){
            String line = null;
            SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy HH");
            HashMap<String, Long> counterMap = new HashMap<String, Long>();
            long minTime = Long.MAX_VALUE;
            long maxTime = Long.MIN_VALUE;
            while ((line = reader.readLine()) != null) {
                GeoJsonPolygon polygon = GeoJsonPolygon.fromGeoJson((String)line);
                String timestampString = (String)polygon.getProperties().get("TimestampParsed");
                long timestamp = MathUtil.tryParseLong((String)timestampString, () -> "Unable to parse: " + timestampString);
                String timeslot = sdf.format(new Date(timestamp));
                long oldElements = counterMap.getOrDefault(timeslot, 0L);
                counterMap.put(timeslot, oldElements + 1L);
                minTime = Math.min(minTime, timestamp);
                maxTime = Math.max(maxTime, timestamp);
            }
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(minTime);
            calendar.set(9, 0);
            calendar.set(10, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            while (calendar.getTimeInMillis() < maxTime) {
                String key = sdf.format(calendar.getTime());
                long readElementInTimeframe = counterMap.getOrDefault(key, 0L);
                System.out.println(key + "\t" + readElementInTimeframe);
                calendar.add(10, 1);
            }
        }
        catch (Exception e) {
            logger.error("Got error", (Throwable)e);
        }
    }

    public static void main(String[] args) {
        File file;
        if (args.length != 1) {
            System.err.println("Usage: <Class> <Filename>");
            System.exit(-1);
        }
        if (!(file = new File(args[0])).isFile()) {
            System.err.println("Unable to open: " + file);
            System.exit(-1);
        }
        AnalyzeAuData analyzeAuData = new AnalyzeAuData(file);
        analyzeAuData.run();
    }
}

