/*
 * Decompiled with CFR 0.152.
 */
package org.bboxdb.tools.network;

import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.bboxdb.commons.MathUtil;
import org.bboxdb.commons.math.GeoJsonPolygon;
import org.bboxdb.misc.BBoxDBException;
import org.bboxdb.network.client.BBoxDBCluster;
import org.bboxdb.network.client.tools.FixedSizeFutureStore;
import org.bboxdb.network.client.tools.InvalidationHelper;
import org.bboxdb.storage.entity.Tuple;
import org.bboxdb.storage.entity.WatermarkTuple;
import org.bboxdb.tools.converter.tuple.GeoJSONTupleBuilder;
import org.bboxdb.tools.network.AuTransportSources;
import org.bboxdb.tools.network.FetchRunable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaptureAUTransportStream
implements Runnable {
    private static final int MAX_PENDING_FUTURES = 1000;
    private long fetchDelay;
    private final String authKey;
    private final String connectionPoint;
    private final String clustername;
    private final String distributionGroup;
    private final FixedSizeFutureStore pendingFutures;
    private final ExecutorService threadPool;
    private final String[] entities;
    private static final Logger logger = LoggerFactory.getLogger(CaptureAUTransportStream.class);

    public CaptureAUTransportStream(String authKey, String[] entities, String connectionPoint, String clustername, String distributionGroup, int delay) {
        this.authKey = authKey;
        this.entities = entities;
        this.connectionPoint = connectionPoint;
        this.clustername = clustername;
        this.distributionGroup = distributionGroup;
        this.fetchDelay = TimeUnit.SECONDS.toMillis(delay);
        this.pendingFutures = new FixedSizeFutureStore(1000L, true);
        this.threadPool = Executors.newCachedThreadPool();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try (BBoxDBCluster bboxdbClient = new BBoxDBCluster(this.connectionPoint, this.clustername);){
            bboxdbClient.connect();
            for (String entity : this.entities) {
                logger.info("Starting fetch thread for {}", (Object)entity);
                String urlString = AuTransportSources.API_ENDPOINT.get(entity);
                if (urlString == null) {
                    logger.error("Unable to determine URL for: " + entity);
                    System.exit(-1);
                }
                String table = this.distributionGroup + "_" + entity;
                GeoJSONTupleBuilder tupleBuilder = new GeoJSONTupleBuilder();
                InvalidationHelper invalidationHelper = new InvalidationHelper(bboxdbClient, table, this.pendingFutures);
                Consumer<GeoJsonPolygon> consumer = polygon -> {
                    WatermarkTuple tuple = null;
                    if (polygon == null) {
                        tuple = new WatermarkTuple(System.currentTimeMillis());
                        invalidationHelper.updateWatermarkGeneration();
                    } else {
                        String key = this.getKeyForPolygon((GeoJsonPolygon)polygon);
                        tuple = tupleBuilder.buildTuple(polygon.toGeoJson(), key);
                        if (tuple == null) {
                            System.err.println("Unable to build tuple for: " + tuple);
                            return;
                        }
                    }
                    try {
                        invalidationHelper.putTuple((Tuple)tuple);
                    }
                    catch (BBoxDBException e) {
                        logger.error("Got error while inserting tuple", (Throwable)e);
                    }
                };
                FetchRunable runable = new FetchRunable(urlString, this.authKey, consumer, this.fetchDelay, entity, true);
                this.threadPool.submit((Runnable)((Object)runable));
            }
            this.threadPool.shutdown();
            this.threadPool.awaitTermination(999999L, TimeUnit.DAYS);
        }
        catch (Exception e) {
            logger.error("Got an exception", (Throwable)e);
        }
        finally {
            this.waitForPendingFutures();
            this.threadPool.shutdownNow();
        }
    }

    private String getKeyForPolygon(GeoJsonPolygon polygon) {
        Map properties = polygon.getProperties();
        if (properties.containsKey("TripID")) {
            return ((String)properties.get("TripID")).replace(" ", "_");
        }
        return ((String)properties.get("RouteID")).replace(" ", "_");
    }

    private void waitForPendingFutures() {
        try {
            this.pendingFutures.waitForCompletion();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 6) {
            System.err.println("Usage: <Class> <AuthKey> <Entity1:Entity2:EntityN> <Connection Endpoint> <Clustername> <DistributionGroup> <Delay in sec>");
            System.err.println("Entities: " + AuTransportSources.SUPPORTED_ENTITIES);
            System.exit(-1);
        }
        String authKey = args[0];
        String[] entities = args[1].split(":");
        String connectionPoint = args[2];
        String clustername = args[3];
        String distributionGroup = args[4];
        int delay = MathUtil.tryParseIntOrExit((String)args[5], () -> "Unable to parse delay value: " + args[5]);
        CaptureAUTransportStream main = new CaptureAUTransportStream(authKey, entities, connectionPoint, clustername, distributionGroup, delay);
        main.run();
    }
}

