/*
 * Decompiled with CFR 0.152.
 */
package org.bboxdb.tools.network;

import com.google.common.base.Stopwatch;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.util.concurrent.TimeUnit;
import org.bboxdb.commons.MathUtil;
import org.bboxdb.misc.Const;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaptureStoredData
implements Runnable {
    private final File file;
    private final Socket socket;
    private final int linesPerSecond;
    private static final Logger logger = LoggerFactory.getLogger(CaptureStoredData.class);

    public CaptureStoredData(File file, Socket socket, int linesPerSecond) {
        this.file = file;
        this.socket = socket;
        this.linesPerSecond = linesPerSecond;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try (BufferedReader reader = Files.newBufferedReader(this.file.toPath(), Const.DEFAULT_CHARSET);
             BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream(), Const.DEFAULT_CHARSET));){
            String line = null;
            long currentSecondSlot = this.getTimeSlot();
            long processedLines = 0L;
            long totalProcessedLines = 0L;
            Stopwatch stopwatch = Stopwatch.createStarted();
            while (true) {
                long currentSecond;
                block43: {
                    block44: {
                        block42: {
                            if ((line = reader.readLine()) == null) break block42;
                            writer.write(line + "\n");
                            ++processedLines;
                            ++totalProcessedLines;
                            if (Thread.currentThread().isInterrupted()) {
                                logger.info("Thread is interruped");
                                return;
                            }
                            currentSecond = this.getTimeSlot();
                            if (processedLines < (long)this.linesPerSecond) break block43;
                            break block44;
                        }
                        logger.info("Total processed elements {}\u00a0in {}\u00a0ms", (Object)totalProcessedLines, (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
                        logger.info("Finished at: {}", (Object)System.currentTimeMillis());
                        return;
                    }
                    while (currentSecond == currentSecondSlot) {
                        if (Thread.currentThread().isInterrupted()) {
                            logger.info("Thread is interruped");
                            return;
                        }
                        Thread.sleep(10L);
                        currentSecond = this.getTimeSlot();
                    }
                }
                if (currentSecond == currentSecondSlot) continue;
                long elapsecSeconds = Math.max(stopwatch.elapsed().getSeconds(), 1L);
                long avgLinesPerSec = totalProcessedLines / elapsecSeconds;
                logger.info("Processed {}\u00a0elements (avg lines per second {} / total lines {})", new Object[]{processedLines, avgLinesPerSec, totalProcessedLines});
                currentSecondSlot = currentSecond;
                processedLines = 0L;
                writer.flush();
            }
        }
        catch (Exception e) {
            logger.error("Got error", (Throwable)e);
        }
    }

    private long getTimeSlot() {
        return System.currentTimeMillis() / 1000L;
    }

    public static void main(String[] args) throws UnknownHostException, IOException {
        if (args.length != 3) {
            System.err.println("Usage: <Class> <Filename> <Host:Port> <Elements per sec>");
            System.exit(-1);
        }
        File file = new File(args[0]);
        String[] networkSocketString = args[1].split(":");
        int linesPerSecond = MathUtil.tryParseIntOrExit((String)args[2], () -> "Unable to parse: " + args[2]);
        if (!file.isFile()) {
            System.err.println("Unable to open: " + file);
            System.exit(-1);
        }
        int port = MathUtil.tryParseIntOrExit((String)networkSocketString[1], () -> "Unable to parse: " + networkSocketString[1]);
        Socket socket = new Socket(networkSocketString[0], port);
        CaptureStoredData analyzeAuData = new CaptureStoredData(file, socket, linesPerSecond);
        analyzeAuData.run();
    }
}

