/*
 * Decompiled with CFR 0.152.
 */
package org.bboxdb.tools.network;

import com.google.common.base.Stopwatch;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.util.concurrent.TimeUnit;
import org.bboxdb.commons.MathUtil;
import org.bboxdb.misc.Const;
import org.bboxdb.storage.entity.Tuple;
import org.bboxdb.tools.converter.tuple.TupleBuilder;
import org.bboxdb.tools.converter.tuple.TupleBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaptureStoredDataTimed
implements Runnable {
    private final File file;
    private final Socket socket;
    private TupleBuilder tupleFactory;
    private static final Logger logger = LoggerFactory.getLogger(CaptureStoredDataTimed.class);

    public CaptureStoredDataTimed(File file, Socket socket, TupleBuilder tupleFactory) {
        this.file = file;
        this.socket = socket;
        this.tupleFactory = tupleFactory;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try (BufferedReader reader = Files.newBufferedReader(this.file.toPath(), Const.DEFAULT_CHARSET);
             BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream(), Const.DEFAULT_CHARSET));){
            String line = null;
            long currentSecondSlot = this.getTimeSlot();
            long totalProcessedLines = 0L;
            long processedLines = 0L;
            Stopwatch stopwatch = Stopwatch.createStarted();
            long timeOffset = -1L;
            while (true) {
                Tuple tuple;
                if ((line = reader.readLine()) != null) {
                    writer.write(line + "\n");
                    ++totalProcessedLines;
                    ++processedLines;
                    if (Thread.currentThread().isInterrupted()) {
                        logger.info("Thread is interruped");
                        return;
                    }
                    tuple = this.tupleFactory.buildTuple(line);
                    if (tuple == null) continue;
                    if (timeOffset == -1L) {
                        timeOffset = System.currentTimeMillis() * 1000L - tuple.getVersionTimestamp();
                    }
                } else {
                    logger.info("Total processed elements {}\u00a0in {}\u00a0ms", (Object)totalProcessedLines, (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
                    return;
                }
                while (tuple.getVersionTimestamp() + timeOffset > System.currentTimeMillis() * 1000L) {
                    if (Thread.currentThread().isInterrupted()) {
                        logger.info("Thread is interruped");
                        return;
                    }
                    Thread.sleep(10L);
                }
                long curTimeSlot = this.getTimeSlot();
                if (curTimeSlot <= currentSecondSlot) continue;
                logger.info("Processed {}\u00a0elements", (Object)processedLines);
                processedLines = 0L;
                currentSecondSlot = curTimeSlot;
                writer.flush();
            }
        }
        catch (Exception e) {
            logger.error("Got error", (Throwable)e);
        }
    }

    private long getTimeSlot() {
        return System.currentTimeMillis() / 1000L;
    }

    public static void main(String[] args) throws UnknownHostException, IOException {
        if (args.length != 3) {
            System.err.println("Usage: <Class> <Filename> <Host:Port> <Data format>");
            System.exit(-1);
        }
        File file = new File(args[0]);
        String[] networkSocketString = args[1].split(":");
        TupleBuilder tupleFactory = TupleBuilderFactory.getBuilderForFormat(args[2]);
        if (!file.isFile()) {
            System.err.println("Unable to open: " + file);
            System.exit(-1);
        }
        int port = MathUtil.tryParseIntOrExit((String)networkSocketString[1], () -> "Unable to parse: " + networkSocketString[1]);
        Socket socket = new Socket(networkSocketString[0], port);
        CaptureStoredDataTimed analyzeAuData = new CaptureStoredDataTimed(file, socket, tupleFactory);
        analyzeAuData.run();
    }
}

