/*
 * Decompiled with CFR 0.152.
 */
package org.bboxdb.tools.network;

import com.google.transit.realtime.GtfsRealtime;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import org.bboxdb.commons.concurrent.ExceptionSafeRunnable;
import org.bboxdb.commons.math.GeoJsonPolygon;
import org.bboxdb.misc.BBoxDBException;
import org.bboxdb.storage.sstable.spatialindex.SpatialIndexEntry;
import org.bboxdb.storage.sstable.spatialindex.rtree.RTreeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FetchRunable
extends ExceptionSafeRunnable {
    private final Consumer<GeoJsonPolygon> consumer;
    private final long fetchDelay;
    private final String urlString;
    private final String authKey;
    private final String entityName;
    private final boolean removeDuplicates;
    private static final Logger logger = LoggerFactory.getLogger(FetchRunable.class);

    public FetchRunable(String urlString, String authKey, Consumer<GeoJsonPolygon> consumer, long fetchDelay, String entityName, boolean removeDuplicates) {
        this.urlString = urlString;
        this.authKey = authKey;
        this.consumer = consumer;
        this.fetchDelay = fetchDelay;
        this.entityName = entityName;
        this.removeDuplicates = removeDuplicates;
    }

    protected void runThread() throws Exception {
        while (!Thread.currentThread().isInterrupted()) {
            try {
                URL url = new URL(this.urlString);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                connection.setDoInput(true);
                connection.setRequestProperty("Accept", "text/plain");
                connection.setRequestProperty("Authorization", "apikey " + this.authKey);
                GtfsRealtime.FeedMessage message = GtfsRealtime.FeedMessage.parseFrom(connection.getInputStream());
                List<GeoJsonPolygon> polygonList = this.parseElements(message);
                int inserts = this.insertData(polygonList);
                logger.info("Inserted {} {} (read {})", new Object[]{inserts, this.entityName, polygonList.size()});
                this.consumer.accept(null);
            }
            catch (Exception e) {
                logger.error("Got exception", (Throwable)e);
            }
            Thread.sleep(this.fetchDelay);
        }
    }

    private List<GeoJsonPolygon> parseElements(GtfsRealtime.FeedMessage message) {
        List<GtfsRealtime.FeedEntity> entities = message.getEntityList();
        ArrayList<GeoJsonPolygon> polygonList = new ArrayList<GeoJsonPolygon>();
        for (GtfsRealtime.FeedEntity entity : entities) {
            GtfsRealtime.VehiclePosition vehicle = entity.getVehicle();
            GtfsRealtime.TripDescriptor trip = vehicle.getTrip();
            GtfsRealtime.Position position = vehicle.getPosition();
            GeoJsonPolygon geoJsonPolygon = new GeoJsonPolygon(0L);
            geoJsonPolygon.addProperty("UpdateTimestamp", Long.toString(vehicle.getTimestamp()));
            geoJsonPolygon.addProperty("ParsedTimestamp", Long.toString(System.currentTimeMillis()));
            geoJsonPolygon.addProperty("RouteID", trip.getRouteId());
            geoJsonPolygon.addProperty("TripID", trip.getTripId());
            geoJsonPolygon.addProperty("TripStartDate", trip.getStartDate());
            geoJsonPolygon.addProperty("TripStartTime", trip.getStartTime());
            geoJsonPolygon.addProperty("TripScheduleRelationship", trip.getScheduleRelationship().name());
            geoJsonPolygon.addProperty("Speed", Float.toString(position.getSpeed()));
            geoJsonPolygon.addProperty("Bearing", Float.toString(position.getBearing()));
            geoJsonPolygon.addProperty("DirectionID", Integer.toString(trip.getDirectionId()));
            geoJsonPolygon.addProperty("CongestionLevel", vehicle.getCongestionLevel().name());
            geoJsonPolygon.addProperty("OccupancyStatus", vehicle.getOccupancyStatus().name());
            geoJsonPolygon.addPoint((double)position.getLongitude(), (double)position.getLatitude());
            polygonList.add(geoJsonPolygon);
        }
        return polygonList;
    }

    private int insertData(List<GeoJsonPolygon> polygonList) throws BBoxDBException {
        if (!this.removeDuplicates) {
            polygonList.forEach(p -> this.consumer.accept((GeoJsonPolygon)p));
            return polygonList.size();
        }
        return this.insertWithoutDuplicates(polygonList);
    }

    private int insertWithoutDuplicates(List<GeoJsonPolygon> polygonList) {
        polygonList.sort((p1, p2) -> Long.compare(p1.getId(), p2.getId()));
        RTreeBuilder index = new RTreeBuilder();
        for (int i = 0; i < polygonList.size(); ++i) {
            GeoJsonPolygon polygon = polygonList.get(i);
            SpatialIndexEntry spe = new SpatialIndexEntry(polygon.getBoundingBox(), i);
            index.insert(spe);
        }
        HashSet<Integer> processedElements = new HashSet<Integer>();
        int inserts = 0;
        for (int i = 0; i < polygonList.size(); ++i) {
            if (processedElements.contains(i)) continue;
            GeoJsonPolygon polygon = polygonList.get(i);
            List entries = index.getEntriesForRegion(polygon.getBoundingBox());
            for (SpatialIndexEntry entry : entries) {
                processedElements.add(entry.getValue());
            }
            this.consumer.accept(polygon);
            ++inserts;
        }
        return inserts;
    }
}

