/*
 * Decompiled with CFR 0.152.
 */
package org.bboxdb.tools.network;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.EnumSet;
import org.bboxdb.commons.InputParseException;
import org.bboxdb.commons.MathUtil;
import org.bboxdb.commons.math.Hyperrectangle;
import org.bboxdb.distribution.zookeeper.ContinuousQueryEnlargementRegisterer;
import org.bboxdb.distribution.zookeeper.QueryEnlargement;
import org.bboxdb.distribution.zookeeper.ZookeeperException;
import org.bboxdb.misc.BBoxDBException;
import org.bboxdb.misc.Const;
import org.bboxdb.network.client.BBoxDB;
import org.bboxdb.network.client.BBoxDBCluster;
import org.bboxdb.network.client.future.client.EmptyResultFuture;
import org.bboxdb.network.client.future.client.OperationFuture;
import org.bboxdb.network.client.tools.FixedSizeFutureStore;
import org.bboxdb.network.routing.DistributionRegionHandlingFlag;
import org.bboxdb.storage.StorageManagerException;
import org.bboxdb.storage.entity.Tuple;
import org.bboxdb.storage.entity.TupleStoreName;
import org.bboxdb.tools.converter.tuple.TupleBuilder;
import org.bboxdb.tools.converter.tuple.TupleBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketImporter
implements Runnable {
    private int port;
    private String connectionPoint;
    private String clustername;
    private String table;
    private TupleBuilder tupleFactory;
    private final FixedSizeFutureStore pendingFutures;
    private final QueryEnlargement enlargement;
    private EnumSet<DistributionRegionHandlingFlag> insertOptions;
    private static final int MAX_PENDING_FUTURES = 2048;
    private static final String NULL_STRING = "NULL";
    private static final Logger logger = LoggerFactory.getLogger(SocketImporter.class);

    public SocketImporter(int port, String connectionPoint, String clustername, String table, TupleBuilder tupleFactory, QueryEnlargement enlargement, EnumSet<DistributionRegionHandlingFlag> insertOptions) {
        this.port = port;
        this.connectionPoint = connectionPoint;
        this.clustername = clustername;
        this.table = table;
        this.tupleFactory = tupleFactory;
        this.enlargement = enlargement;
        this.insertOptions = insertOptions;
        this.pendingFutures = new FixedSizeFutureStore(2048L, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try (ServerSocket serverSocket = new ServerSocket(this.port);
             BBoxDBCluster bboxdbClient = new BBoxDBCluster(this.connectionPoint, this.clustername);){
            bboxdbClient.connect();
            while (!Thread.currentThread().isInterrupted()) {
                this.handleConnection(serverSocket, (BBoxDB)bboxdbClient);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.waitForPendingFutures();
        }
    }

    private void handleConnection(ServerSocket serverSocket, BBoxDB bboxdbClient) throws IOException, BBoxDBException {
        logger.info("Ready and waiting for connections on port {}", (Object)this.port);
        try (Socket clientSocket = serverSocket.accept();
             InputStreamReader reader = new InputStreamReader(clientSocket.getInputStream(), Const.DEFAULT_CHARSET);
             BufferedReader inputStream = new BufferedReader(reader);){
            String line;
            logger.info("Handle connection from: {}", (Object)clientSocket.getRemoteSocketAddress());
            while ((line = inputStream.readLine()) != null) {
                Tuple tuple = this.tupleFactory.buildTuple(line);
                if (tuple == null) continue;
                Hyperrectangle tupleBBox = this.getEnlargedBBoxForTuple(tuple);
                tuple.setBoundingBox(tupleBBox);
                if (NULL_STRING.equals(this.table)) continue;
                EmptyResultFuture result = bboxdbClient.put(this.table, tuple, this.insertOptions);
                this.pendingFutures.put((OperationFuture)result);
            }
        }
        catch (Exception e) {
            logger.error("Got exception", (Throwable)e);
        }
    }

    private Hyperrectangle getEnlargedBBoxForTuple(Tuple tuple) {
        if (this.enlargement == null) {
            return tuple.getBoundingBox();
        }
        double maxAbsoluteEnlargement = this.enlargement.getMaxAbsoluteEnlargement();
        double maxEnlargementFactor = this.enlargement.getMaxEnlargementFactor();
        double maxEnlargementLat = this.enlargement.getMaxEnlargementLat();
        double maxEnlargementLon = this.enlargement.getMaxEnlargementLon();
        ArrayList<Hyperrectangle> bboxes = new ArrayList<Hyperrectangle>();
        bboxes.add(tuple.getBoundingBox());
        if (maxAbsoluteEnlargement != 0.0) {
            bboxes.add(tuple.getBoundingBox().enlargeByAmount(maxAbsoluteEnlargement));
        }
        if (maxEnlargementFactor != 1.0) {
            bboxes.add(tuple.getBoundingBox().enlargeByFactor(maxEnlargementFactor));
        }
        if (maxEnlargementLat != 0.0 || maxEnlargementLon != 0.0) {
            bboxes.add(tuple.getBoundingBox().enlargeByMeters(maxEnlargementLat, maxEnlargementLon));
        }
        Hyperrectangle resultBox = Hyperrectangle.getCoveringBox(bboxes);
        if (logger.isDebugEnabled()) {
            logger.debug("==========================");
            logger.debug("Enlargement: {}", (Object)this.enlargement);
            logger.debug("Original bounding box");
            logger.debug("{}", (Object)tuple.getBoundingBox());
            logger.debug("Enlarged bounding box");
            logger.debug("{}", (Object)resultBox);
            logger.debug("");
        }
        return resultBox;
    }

    private void waitForPendingFutures() {
        try {
            this.pendingFutures.waitForCompletion();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public static void main(String[] args) throws InputParseException, StorageManagerException, ZookeeperException {
        if (args.length != 7) {
            System.err.println("Usage: <Class> <Port> <Connection Endpoint> <Clustername> <Table> <Format> <Enlargement> <Write-To-Disk>");
            System.exit(-1);
        }
        String portString = args[0];
        int port = MathUtil.tryParseInt((String)portString, () -> "Unable to parse: " + portString);
        String connectionPoint = args[1];
        String clustername = args[2];
        String table = args[3];
        String format = args[4];
        String enlargement = args[5];
        String writeToDiskString = args[6];
        TupleBuilder tupleFactory = TupleBuilderFactory.getBuilderForFormat(format);
        QueryEnlargement queryEnlargement = null;
        if ("dynamic".equals(enlargement)) {
            logger.info("Performing dynamic enlargement");
            TupleStoreName tupleStoreName = new TupleStoreName(table);
            ContinuousQueryEnlargementRegisterer continuousQueryRegisterer = ContinuousQueryEnlargementRegisterer.getInstanceFor((TupleStoreName)tupleStoreName);
            queryEnlargement = continuousQueryRegisterer.getEnlagementForTable();
        } else if (NULL_STRING.equals(enlargement)) {
            logger.info("Performing NULL enlargement");
            queryEnlargement = null;
        } else {
            logger.info("Performing factor enlargement");
            double enlargementFactor = MathUtil.tryParseDoubleOrExit((String)enlargement, () -> "Unable to parse enlargement: " + enlargement);
            queryEnlargement = new QueryEnlargement();
            queryEnlargement.setMaxEnlargementFactor(enlargementFactor);
        }
        boolean writeToDisk = MathUtil.tryParseBooleanOrExit((String)writeToDiskString);
        EnumSet<DistributionRegionHandlingFlag> insertOptions = EnumSet.noneOf(DistributionRegionHandlingFlag.class);
        if (!writeToDisk) {
            insertOptions.add(DistributionRegionHandlingFlag.STREAMING_ONLY);
        }
        logger.info("Use the following insert options {}", insertOptions);
        SocketImporter main = new SocketImporter(port, connectionPoint, clustername, table, tupleFactory, queryEnlargement, insertOptions);
        main.run();
    }
}

