/*
 * Decompiled with CFR 0.152.
 */
package org.bboxdb.tools.network;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.bboxdb.commons.CloseableHelper;
import org.bboxdb.commons.MathUtil;
import org.bboxdb.commons.math.GeoJsonPolygon;
import org.bboxdb.misc.Const;
import org.bboxdb.tools.network.AuTransportSources;
import org.bboxdb.tools.network.FetchRunable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreAuTransport
implements Runnable {
    private long fetchDelay;
    private final String authKey;
    private final File output;
    private final ExecutorService threadPool;
    private final String[] entities;
    private static final Logger logger = LoggerFactory.getLogger(StoreAuTransport.class);

    public StoreAuTransport(String authKey, String[] entities, File output, int delay) {
        this.authKey = authKey;
        this.entities = entities;
        this.output = output;
        this.fetchDelay = TimeUnit.SECONDS.toMillis(delay);
        this.threadPool = Executors.newCachedThreadPool();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ArrayList<BufferedOutputStream> openStreams = new ArrayList<BufferedOutputStream>();
        try {
            for (String entity : this.entities) {
                logger.info("Starting fetch thread for {}", (Object)entity);
                String urlString = AuTransportSources.API_ENDPOINT.get(entity);
                if (urlString == null) {
                    logger.error("Unable to determine URL for: " + entity);
                    System.exit(-1);
                }
                File file = new File(this.output.getAbsolutePath() + "/" + entity);
                BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file));
                openStreams.add(bos);
                Consumer<GeoJsonPolygon> consumer = polygon -> {
                    try {
                        if (polygon == null) {
                            return;
                        }
                        bos.write(polygon.toGeoJson().getBytes(Const.DEFAULT_CHARSET));
                        bos.write("\n".getBytes(Const.DEFAULT_CHARSET));
                        bos.flush();
                    }
                    catch (IOException e) {
                        logger.error("Got error while inserting tuple");
                    }
                };
                FetchRunable runable = new FetchRunable(urlString, this.authKey, consumer, this.fetchDelay, entity, false);
                this.threadPool.submit((Runnable)((Object)runable));
            }
            this.threadPool.shutdown();
            this.threadPool.awaitTermination(999999L, TimeUnit.DAYS);
        }
        catch (Exception e) {
            logger.error("Got an exception", (Throwable)e);
        }
        finally {
            this.threadPool.shutdownNow();
            openStreams.forEach(s -> CloseableHelper.closeWithoutException((Closeable)s));
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 4) {
            System.err.println("Usage: <Class> <AuthKey> <Entity1:Entity2:EntityN> <OutputFolder> <Delay in sec>");
            System.err.println("Entities: " + AuTransportSources.SUPPORTED_ENTITIES);
            System.exit(-1);
        }
        String authKey = args[0];
        String[] entities = args[1].split(":");
        String outputFolder = args[2];
        int delay = MathUtil.tryParseIntOrExit((String)args[3], () -> "Unable to parse delay value: " + args[3]);
        File output = new File(outputFolder);
        if (!output.exists()) {
            System.err.println("Output dir does not exists: " + output);
            System.exit(-1);
        }
        if (!output.isDirectory()) {
            System.err.println("Output dir is not a directory: " + output);
            System.exit(-1);
        }
        StoreAuTransport main = new StoreAuTransport(authKey, entities, output, delay);
        main.run();
    }
}

