/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.BAMFileSpan;
import htsjdk.samtools.BAMIndex;
import htsjdk.samtools.CRAMIterator;
import htsjdk.samtools.CachingBAMFileIndex;
import htsjdk.samtools.Defaults;
import htsjdk.samtools.DiskBasedBAMFileIndex;
import htsjdk.samtools.QueryInterval;
import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileReader;
import htsjdk.samtools.SAMFileSpan;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordFactory;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.cram.build.CramIO;
import htsjdk.samtools.cram.ref.ReferenceSource;
import htsjdk.samtools.cram.structure.Container;
import htsjdk.samtools.seekablestream.SeekableFileStream;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.RuntimeEOFException;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class CRAMFileReader
extends SAMFileReader.ReaderImplementation {
    private File file;
    private final ReferenceSource referenceSource;
    private InputStream is;
    private CRAMIterator it;
    private BAMIndex mIndex;
    private File mIndexFile;
    private boolean mEnableIndexCaching;
    private boolean mEnableIndexMemoryMapping;
    private ValidationStringency validationStringency;
    private static final SAMRecordIterator emptyIterator = new SAMRecordIterator(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public SAMRecord next() {
            throw new RuntimeException("No records.");
        }

        @Override
        public void remove() {
            throw new RuntimeException("Remove not supported.");
        }

        @Override
        public void close() {
        }

        @Override
        public SAMRecordIterator assertSorted(SAMFileHeader.SortOrder sortOrder) {
            return this;
        }
    };

    public CRAMFileReader(File file, InputStream inputStream) {
        this(file, inputStream, new ReferenceSource(Defaults.REFERENCE_FASTA));
    }

    public CRAMFileReader(File file, InputStream inputStream, ReferenceSource referenceSource) {
        if (file == null && inputStream == null) {
            throw new IllegalArgumentException("Either file or input stream is required.");
        }
        this.file = file;
        this.is = inputStream;
        this.referenceSource = referenceSource;
        this.getIterator();
    }

    public CRAMFileReader(File file, File file2, ReferenceSource referenceSource) {
        if (this.file == null) {
            throw new IllegalArgumentException("File is required.");
        }
        this.file = file;
        this.mIndexFile = file2;
        this.referenceSource = referenceSource;
        this.getIterator();
    }

    public CRAMFileReader(File file, ReferenceSource referenceSource) {
        if (file == null && this.is == null) {
            throw new IllegalArgumentException("Either file or input stream is required.");
        }
        this.file = file;
        this.referenceSource = referenceSource;
        this.getIterator();
    }

    public SAMRecordIterator iterator() {
        return this.getIterator();
    }

    @Override
    void enableIndexCaching(boolean bl) {
        this.mEnableIndexCaching = bl;
    }

    @Override
    void enableIndexMemoryMapping(boolean bl) {
        this.mEnableIndexMemoryMapping = bl;
    }

    @Override
    void enableCrcChecking(boolean bl) {
    }

    @Override
    void setSAMRecordFactory(SAMRecordFactory sAMRecordFactory) {
    }

    @Override
    public boolean hasIndex() {
        return this.mIndex != null || this.mIndexFile != null;
    }

    @Override
    public BAMIndex getIndex() {
        if (!this.hasIndex()) {
            throw new SAMException("No index is available for this BAM file.");
        }
        if (this.mIndex == null) {
            SAMSequenceDictionary sAMSequenceDictionary = this.getFileHeader().getSequenceDictionary();
            this.mIndex = this.mEnableIndexCaching ? new CachingBAMFileIndex(this.mIndexFile, sAMSequenceDictionary, this.mEnableIndexMemoryMapping) : new DiskBasedBAMFileIndex(this.mIndexFile, sAMSequenceDictionary, this.mEnableIndexMemoryMapping);
        }
        return this.mIndex;
    }

    @Override
    public SAMFileHeader getFileHeader() {
        return this.it.getSAMFileHeader();
    }

    public SAMRecordIterator getIterator() {
        if (this.it != null && this.file == null) {
            return this.it;
        }
        try {
            CRAMIterator cRAMIterator = this.file != null ? new CRAMIterator(new FileInputStream(this.file), this.referenceSource) : new CRAMIterator(this.is, this.referenceSource);
            cRAMIterator.setValidationStringency(this.validationStringency);
            this.it = cRAMIterator;
            return this.it;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public CloseableIterator<SAMRecord> getIterator(SAMFileSpan sAMFileSpan) {
        throw new RuntimeException("Not implemented.");
    }

    @Override
    public SAMFileSpan getFilePointerSpanningReads() {
        throw new RuntimeException("Not implemented.");
    }

    @Override
    public CloseableIterator<SAMRecord> queryAlignmentStart(String string, int n) {
        Object object;
        Closeable closeable;
        long[] lArray = null;
        SAMFileHeader sAMFileHeader = this.getFileHeader();
        int n2 = sAMFileHeader.getSequenceIndex(string);
        if (n2 != -1) {
            closeable = this.getIndex();
            object = closeable.getSpanOverlapping(n2, n, -1);
            long[] lArray2 = lArray = object != null ? ((BAMFileSpan)object).toCoordinateArray() : null;
        }
        if (lArray == null || lArray.length == 0) {
            return emptyIterator;
        }
        closeable = this.getSeekableStreamOrFailWithRTE();
        try {
            ((SeekableStream)closeable).seek(0L);
            object = new CRAMIterator((InputStream)closeable, this.referenceSource);
            ((CRAMIterator)object).setValidationStringency(this.validationStringency);
            this.it = object;
        }
        catch (IOException iOException) {
            throw new RuntimeEOFException(iOException);
        }
        for (int i = 0; i < lArray.length; i += 2) {
            long l = lArray[i] >>> 16;
            try {
                ((SeekableStream)closeable).seek(l);
                Container container = CramIO.readContainerHeader((InputStream)closeable);
                if (container.alignmentStart + container.alignmentSpan <= n) continue;
                ((SeekableStream)closeable).seek(l);
                return object;
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        return this.it;
    }

    @Override
    public CloseableIterator<SAMRecord> queryUnmapped() {
        long l = this.getIndex().getStartOfLastLinearBin();
        SeekableStream seekableStream = this.getSeekableStreamOrFailWithRTE();
        try {
            seekableStream.seek(0L);
            CRAMIterator cRAMIterator = new CRAMIterator(seekableStream, this.referenceSource);
            cRAMIterator.setValidationStringency(this.validationStringency);
            seekableStream.seek(l);
            this.it = cRAMIterator;
        }
        catch (IOException iOException) {
            throw new RuntimeEOFException(iOException);
        }
        return this.it;
    }

    private SeekableStream getSeekableStreamOrFailWithRTE() {
        SeekableStream seekableStream = null;
        if (this.file != null) {
            try {
                seekableStream = new SeekableFileStream(this.file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new RuntimeException(fileNotFoundException);
            }
        } else if (this.is instanceof SeekableStream) {
            seekableStream = (SeekableStream)this.is;
        }
        return seekableStream;
    }

    @Override
    public void close() {
        CloserUtil.close(this.it);
        CloserUtil.close(this.is);
        CloserUtil.close(this.mIndex);
    }

    @Override
    void setValidationStringency(ValidationStringency validationStringency) {
        this.validationStringency = validationStringency;
    }

    @Override
    public ValidationStringency getValidationStringency() {
        return this.validationStringency;
    }

    @Override
    public CloseableIterator<SAMRecord> query(QueryInterval[] queryIntervalArray, boolean bl) {
        if (this.is == null) {
            throw new IllegalStateException("File reader is closed");
        }
        if (this.it != null) {
            throw new IllegalStateException("Iteration in progress");
        }
        if (this.mIndex == null && this.mIndexFile == null) {
            throw new UnsupportedOperationException("Cannot query stream-based BAM file");
        }
        throw new SAMException("Multiple interval queries not implemented.");
    }

    @Override
    public SamReader.Type type() {
        return SamReader.Type.CRAM_TYPE;
    }

    @Override
    void enableFileSource(SamReader samReader, boolean bl) {
        if (this.it != null) {
            this.it.setFileSource(bl ? samReader : null);
        }
    }
}

