/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.CigarElement;
import htsjdk.samtools.Defaults;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriterImpl;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMTextHeaderCodec;
import htsjdk.samtools.cram.build.ContainerFactory;
import htsjdk.samtools.cram.build.Cram2SamRecordFactory;
import htsjdk.samtools.cram.build.CramIO;
import htsjdk.samtools.cram.build.Sam2CramRecordFactory;
import htsjdk.samtools.cram.common.CramVersions;
import htsjdk.samtools.cram.common.Version;
import htsjdk.samtools.cram.lossy.PreservationPolicy;
import htsjdk.samtools.cram.lossy.QualityScorePreservation;
import htsjdk.samtools.cram.ref.ReferenceSource;
import htsjdk.samtools.cram.ref.ReferenceTracks;
import htsjdk.samtools.cram.structure.Container;
import htsjdk.samtools.cram.structure.CramCompressionRecord;
import htsjdk.samtools.cram.structure.CramHeader;
import htsjdk.samtools.cram.structure.Slice;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.StringLineReader;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class CRAMFileWriter
extends SAMFileWriterImpl {
    private static final int REF_SEQ_INDEX_NOT_INITED = -2;
    private static final int DEFAULT_RECORDS_PER_SLICE = 10000;
    private static final int DEFAULT_SLICES_PER_CONTAINER = 1;
    private static final Version cramVersion = CramVersions.CRAM_v2_1;
    private String fileName;
    private List<SAMRecord> samRecords = new ArrayList<SAMRecord>();
    private ContainerFactory containerFactory;
    protected int recordsPerSlice = 10000;
    protected int containerSize = this.recordsPerSlice * 1;
    private Sam2CramRecordFactory sam2CramRecordFactory;
    private OutputStream os;
    private ReferenceSource source;
    private int refSeqIndex = -2;
    private static Log log = Log.getInstance(CRAMFileWriter.class);
    private SAMFileHeader samFileHeader;
    private boolean preserveReadNames = true;
    private QualityScorePreservation preservation = null;
    private boolean captureAllTags = true;
    private Set<String> captureTags = new TreeSet<String>();
    private Set<String> ignoreTags = new TreeSet<String>();

    public CRAMFileWriter(OutputStream outputStream, ReferenceSource referenceSource, SAMFileHeader sAMFileHeader, String string) {
        this.os = outputStream;
        this.source = referenceSource;
        this.samFileHeader = sAMFileHeader;
        this.fileName = string;
        this.setSortOrder(sAMFileHeader.getSortOrder(), true);
        this.setHeader(sAMFileHeader);
        if (this.source == null) {
            this.source = new ReferenceSource(Defaults.REFERENCE_FASTA);
        }
        this.containerFactory = new ContainerFactory(sAMFileHeader, this.recordsPerSlice);
    }

    protected boolean shouldFlushContainer(SAMRecord sAMRecord) {
        if (this.samRecords.size() >= this.containerSize) {
            return true;
        }
        return this.refSeqIndex != -2 && this.refSeqIndex != sAMRecord.getReferenceIndex();
    }

    private static void updateTracks(List<SAMRecord> list, ReferenceTracks referenceTracks) {
        for (SAMRecord sAMRecord : list) {
            if (sAMRecord.getAlignmentStart() == 0) continue;
            int n = sAMRecord.getAlignmentStart();
            int n2 = 0;
            for (CigarElement cigarElement : sAMRecord.getCigar().getCigarElements()) {
                int n3;
                if (cigarElement.getOperator().consumesReferenceBases()) {
                    for (n3 = 0; n3 < cigarElement.getLength(); ++n3) {
                        referenceTracks.addCoverage(n + n3, 1);
                    }
                }
                switch (cigarElement.getOperator()) {
                    case M: 
                    case X: 
                    case EQ: {
                        for (n3 = n2; n3 < cigarElement.getLength(); ++n3) {
                            byte by;
                            byte by2 = sAMRecord.getReadBases()[n2 + n3];
                            if (by2 == (by = referenceTracks.baseAt(n + n3))) continue;
                            referenceTracks.addMismatches(n + n3, 1);
                        }
                        break;
                    }
                }
                n2 += cigarElement.getOperator().consumesReadBases() ? cigarElement.getLength() : 0;
                n += cigarElement.getOperator().consumesReferenceBases() ? cigarElement.getLength() : 0;
            }
        }
    }

    protected void flushContainer() throws IllegalArgumentException, IllegalAccessException, IOException {
        Object object;
        Object object2;
        Slice[] sliceArray;
        Object object3;
        byte[] byArray = this.refSeqIndex == -1 ? new byte[]{} : this.source.getReferenceBases(this.samFileHeader.getSequence(this.refSeqIndex), true);
        int n = 0;
        int n2 = 0;
        for (SAMRecord cloneable22 : this.samRecords) {
            if (cloneable22.getAlignmentStart() == 0) continue;
            if (n == 0) {
                n = cloneable22.getAlignmentStart();
            }
            n = Math.min(cloneable22.getAlignmentStart(), n);
            n2 = Math.max(cloneable22.getAlignmentEnd(), n2);
        }
        Object object4 = null;
        if (this.preservation != null && this.preservation.areReferenceTracksRequired()) {
            if (object4 == null || ((ReferenceTracks)object4).getSequenceId() != this.refSeqIndex) {
                object4 = new ReferenceTracks(this.refSeqIndex, byArray);
            }
            ((ReferenceTracks)object4).ensureRange(n, n2 - n + 1);
            CRAMFileWriter.updateTracks(this.samRecords, (ReferenceTracks)object4);
        }
        ArrayList<CramCompressionRecord> arrayList = new ArrayList<CramCompressionRecord>(this.samRecords.size());
        this.sam2CramRecordFactory = new Sam2CramRecordFactory(this.refSeqIndex, byArray, this.samFileHeader);
        this.sam2CramRecordFactory.preserveReadNames = this.preserveReadNames;
        this.sam2CramRecordFactory.captureAllTags = this.captureAllTags;
        this.sam2CramRecordFactory.captureTags.addAll(this.captureTags);
        this.sam2CramRecordFactory.ignoreTags.addAll(this.ignoreTags);
        this.containerFactory.setPreserveReadNames(this.preserveReadNames);
        int n3 = 0;
        int n4 = n;
        for (SAMRecord sAMRecord : this.samRecords) {
            object3 = this.sam2CramRecordFactory.createCramRecord(sAMRecord);
            ((CramCompressionRecord)object3).index = ++n3;
            ((CramCompressionRecord)object3).alignmentDelta = sAMRecord.getAlignmentStart() - n4;
            ((CramCompressionRecord)object3).alignmentStart = sAMRecord.getAlignmentStart();
            n4 = sAMRecord.getAlignmentStart();
            arrayList.add((CramCompressionRecord)object3);
            if (this.preservation != null) {
                this.preservation.addQualityScores(sAMRecord, (CramCompressionRecord)object3, (ReferenceTracks)object4);
                continue;
            }
            ((CramCompressionRecord)object3).setForcePreserveQualityScores(true);
        }
        if (this.sam2CramRecordFactory.getBaseCount() < 3L * this.sam2CramRecordFactory.getFeatureCount()) {
            log.warn("Abnormally high number of mismatches, possibly wrong reference.");
        }
        TreeMap treeMap = new TreeMap();
        TreeMap treeMap2 = new TreeMap();
        for (CramCompressionRecord container : arrayList) {
            if (!container.isMultiFragment()) {
                container.setDetached(true);
                container.setHasMateDownStream(false);
                container.recordsToNextFragment = -1;
                container.next = null;
                container.previous = null;
                continue;
            }
            sliceArray = container.readName;
            object2 = container.isSecondaryAlignment() ? treeMap2 : treeMap;
            object = (CramCompressionRecord)object2.get(sliceArray);
            if (object == null) {
                object2.put(sliceArray, container);
                continue;
            }
            ((CramCompressionRecord)object).recordsToNextFragment = container.index - ((CramCompressionRecord)object).index - 1;
            ((CramCompressionRecord)object).next = container;
            container.previous = object;
            container.previous.setHasMateDownStream(true);
            container.setHasMateDownStream(false);
            container.setDetached(false);
            container.previous.setDetached(false);
            object2.remove(sliceArray);
        }
        for (CramCompressionRecord container : treeMap.values()) {
            container.setDetached(true);
            container.setHasMateDownStream(false);
            container.recordsToNextFragment = -1;
            container.next = null;
            container.previous = null;
        }
        for (CramCompressionRecord container : treeMap2.values()) {
            container.setDetached(true);
            container.setHasMateDownStream(false);
            container.recordsToNextFragment = -1;
            container.next = null;
            container.previous = null;
        }
        object3 = new Cram2SamRecordFactory(this.samFileHeader);
        for (int i = 0; i < this.samRecords.size(); ++i) {
            sliceArray = this.samRecords.get(i).getSAMString();
            object2 = ((Cram2SamRecordFactory)object3).create((CramCompressionRecord)arrayList.get(i));
            object = ((SAMRecord)object2).getSAMString();
            assert (sliceArray.equals(object));
        }
        Container container = this.containerFactory.buildContainer(arrayList);
        for (Slice slice : container.slices) {
            slice.setRefMD5(byArray);
        }
        CramIO.writeContainer(container, this.os);
        this.samRecords.clear();
    }

    @Override
    protected void writeAlignment(SAMRecord sAMRecord) {
        if (this.shouldFlushContainer(sAMRecord)) {
            try {
                this.flushContainer();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        this.updateReferenceContext(sAMRecord.getReferenceIndex());
        this.samRecords.add(sAMRecord);
    }

    private void updateReferenceContext(int n) {
        if (this.refSeqIndex == -2) {
            this.refSeqIndex = n;
        } else {
            int n2 = n;
            if (this.refSeqIndex != n2) {
                this.refSeqIndex = n2;
            }
        }
    }

    @Override
    protected void writeHeader(String string) {
        SAMFileHeader sAMFileHeader = new SAMTextHeaderCodec().decode(new StringLineReader(string), this.fileName != null ? this.fileName : null);
        this.containerFactory = new ContainerFactory(sAMFileHeader, this.recordsPerSlice);
        CramHeader cramHeader = new CramHeader(CRAMFileWriter.cramVersion.major, CRAMFileWriter.cramVersion.minor, this.fileName, sAMFileHeader);
        try {
            CramIO.writeCramHeader(cramHeader, this.os);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    @Override
    protected void finish() {
        try {
            if (!this.samRecords.isEmpty()) {
                this.flushContainer();
            }
            CramIO.issueZeroB_EOF_marker(this.os);
            this.os.flush();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    protected String getFilename() {
        return this.fileName;
    }

    public boolean isPreserveReadNames() {
        return this.preserveReadNames;
    }

    public void setPreserveReadNames(boolean bl) {
        this.preserveReadNames = bl;
    }

    public List<PreservationPolicy> getPreservationPolicies() {
        if (this.preservation == null) {
            this.preservation = new QualityScorePreservation("*8");
        }
        return this.preservation.getPreservationPolicies();
    }

    public boolean isCaptureAllTags() {
        return this.captureAllTags;
    }

    public void setCaptureAllTags(boolean bl) {
        this.captureAllTags = bl;
    }

    public Set<String> getCaptureTags() {
        return this.captureTags;
    }

    public void setCaptureTags(Set<String> set) {
        this.captureTags = set;
    }

    public Set<String> getIgnoreTags() {
        return this.ignoreTags;
    }

    public void setIgnoreTags(Set<String> set) {
        this.ignoreTags = set;
    }
}

