/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.BAMFileSpan;
import htsjdk.samtools.Chunk;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileSource;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.SAMUtils;
import htsjdk.samtools.SAMValidationError;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.cram.build.ContainerParser;
import htsjdk.samtools.cram.build.Cram2SamRecordFactory;
import htsjdk.samtools.cram.build.CramIO;
import htsjdk.samtools.cram.build.CramNormalizer;
import htsjdk.samtools.cram.io.CountingInputStream;
import htsjdk.samtools.cram.ref.ReferenceSource;
import htsjdk.samtools.cram.structure.Container;
import htsjdk.samtools.cram.structure.CramCompressionRecord;
import htsjdk.samtools.cram.structure.CramHeader;
import htsjdk.samtools.cram.structure.Slice;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.RuntimeEOFException;
import htsjdk.samtools.util.SequenceUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CRAMIterator
implements SAMRecordIterator {
    private static Log log = Log.getInstance(CRAMIterator.class);
    private CountingInputStream is;
    private CramHeader cramHeader;
    private ArrayList<SAMRecord> records;
    private int recordCounter = 0;
    private SAMRecord nextRecord = null;
    private boolean restoreNMTag = true;
    private boolean restoreMDTag = false;
    private CramNormalizer normalizer;
    private byte[] refs;
    private int prevSeqId = -1;
    private Container container;
    private long containerOffset = 0L;
    private SamReader mReader;
    private ContainerParser parser;
    private ReferenceSource referenceSource;
    private ValidationStringency validationStringency = ValidationStringency.SILENT;
    private long samRecordIndex;
    private ArrayList<CramCompressionRecord> cramRecords;

    public ValidationStringency getValidationStringency() {
        return this.validationStringency;
    }

    public void setValidationStringency(ValidationStringency validationStringency) {
        this.validationStringency = validationStringency;
    }

    public CRAMIterator(InputStream inputStream, ReferenceSource referenceSource) throws IOException {
        this.is = new CountingInputStream(inputStream);
        this.referenceSource = referenceSource;
        this.cramHeader = CramIO.readCramHeader(this.is);
        this.records = new ArrayList(10000);
        this.normalizer = new CramNormalizer(this.cramHeader.getSamFileHeader(), referenceSource);
        this.parser = new ContainerParser(this.cramHeader.getSamFileHeader());
    }

    public CramHeader getCramHeader() {
        return this.cramHeader;
    }

    private void nextContainer() throws IOException, IllegalArgumentException, IllegalAccessException {
        this.recordCounter = 0;
        this.containerOffset = this.is.getCount();
        this.container = CramIO.readContainer(this.is);
        if (this.container == null || this.container.isEOF()) {
            this.records.clear();
            this.nextRecord = null;
            this.recordCounter = -1;
            return;
        }
        if (this.records == null) {
            this.records = new ArrayList(this.container.nofRecords);
        } else {
            this.records.clear();
        }
        if (this.cramRecords == null) {
            this.cramRecords = new ArrayList(this.container.nofRecords);
        } else {
            this.cramRecords.clear();
        }
        this.parser.getRecords(this.container, this.cramRecords);
        if (this.container.sequenceId == -1) {
            this.refs = new byte[0];
        } else if (this.container.sequenceId == -2) {
            this.refs = null;
            this.prevSeqId = -2;
        } else if (this.prevSeqId < 0 || this.prevSeqId != this.container.sequenceId) {
            SAMSequenceRecord sAMSequenceRecord = this.cramHeader.getSamFileHeader().getSequence(this.container.sequenceId);
            this.refs = this.referenceSource.getReferenceBases(sAMSequenceRecord, true);
            this.prevSeqId = this.container.sequenceId;
        }
        try {
            for (int i = 0; i < this.container.slices.length; ++i) {
                Slice slice = this.container.slices[i];
                if (slice.sequenceId < 0 || slice.validateRefMD5(this.refs)) continue;
                log.error(String.format("Reference sequence MD5 mismatch for slice: seq id %d, start %d, span %d, expected MD5 %s", slice.sequenceId, slice.alignmentStart, slice.alignmentSpan, String.format("%032x", new BigInteger(1, slice.refMD5))));
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException);
        }
        this.normalizer.normalize(this.cramRecords, true, this.refs, this.container.alignmentStart, this.container.h.substitutionMatrix, this.container.h.AP_seriesDelta);
        Cram2SamRecordFactory cram2SamRecordFactory = new Cram2SamRecordFactory(this.cramHeader.getSamFileHeader());
        for (CramCompressionRecord cramCompressionRecord : this.cramRecords) {
            Object object;
            SAMRecord sAMRecord = cram2SamRecordFactory.create(cramCompressionRecord);
            if (!cramCompressionRecord.isSegmentUnmapped()) {
                object = this.cramHeader.getSamFileHeader().getSequence(cramCompressionRecord.sequenceId);
                this.refs = this.referenceSource.getReferenceBases((SAMSequenceRecord)object, true);
                SequenceUtil.calculateMdAndNmTags(sAMRecord, this.refs, this.restoreMDTag, this.restoreNMTag);
            }
            sAMRecord.setValidationStringency(this.validationStringency);
            if (this.validationStringency != ValidationStringency.SILENT) {
                object = sAMRecord.isValid();
                SAMUtils.processValidationErrors((List<SAMValidationError>)object, this.samRecordIndex, this.validationStringency);
            }
            if (this.mReader != null) {
                long l = this.containerOffset << 16 | (long)cramCompressionRecord.sliceIndex;
                long l2 = (this.containerOffset << 16 | (long)cramCompressionRecord.sliceIndex) + 1L;
                this.nextRecord.setFileSource(new SAMFileSource(this.mReader, new BAMFileSpan(new Chunk(l, l2))));
            }
            this.records.add(sAMRecord);
        }
        this.cramRecords.clear();
    }

    @Override
    public boolean hasNext() {
        if (this.container != null && this.container.isEOF()) {
            return false;
        }
        if (this.container == null || this.recordCounter >= this.records.size()) {
            try {
                this.nextContainer();
                if (this.records.isEmpty()) {
                    return false;
                }
            }
            catch (Exception exception) {
                throw new RuntimeEOFException(exception);
            }
        }
        this.nextRecord = this.records.get(this.recordCounter++);
        return true;
    }

    @Override
    public SAMRecord next() {
        return this.nextRecord;
    }

    @Override
    public void remove() {
        throw new RuntimeException("Removal of records not implemented.");
    }

    @Override
    public void close() {
        this.records.clear();
        try {
            this.is.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public SAMRecordIterator assertSorted(SAMFileHeader.SortOrder sortOrder) {
        throw new RuntimeException("Not implemented.");
    }

    public SamReader getFileSource() {
        return this.mReader;
    }

    public void setFileSource(SamReader samReader) {
        this.mReader = samReader;
    }

    public SAMFileHeader getSAMFileHeader() {
        return this.cramHeader.getSamFileHeader();
    }

    public static class CramFileIterable
    implements Iterable<SAMRecord> {
        private ReferenceSource referenceSource;
        private File cramFile;
        private ValidationStringency validationStringency;

        public CramFileIterable(File file, ReferenceSource referenceSource, ValidationStringency validationStringency) {
            this.referenceSource = referenceSource;
            this.cramFile = file;
            this.validationStringency = validationStringency;
        }

        public CramFileIterable(File file, ReferenceSource referenceSource) {
            this(file, referenceSource, ValidationStringency.DEFAULT_STRINGENCY);
        }

        @Override
        public Iterator<SAMRecord> iterator() {
            try {
                FileInputStream fileInputStream = new FileInputStream(this.cramFile);
                BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
                CRAMIterator cRAMIterator = new CRAMIterator(bufferedInputStream, this.referenceSource);
                cRAMIterator.setValidationStringency(this.validationStringency);
                return cRAMIterator;
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    }
}

