/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMTag;
import htsjdk.samtools.util.PeekableIterator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

public class SamPairUtil {
    public static PairOrientation getPairOrientation(SAMRecord sAMRecord) {
        boolean bl = sAMRecord.getReadNegativeStrandFlag();
        if (sAMRecord.getReadUnmappedFlag() || !sAMRecord.getReadPairedFlag() || sAMRecord.getMateUnmappedFlag()) {
            throw new IllegalArgumentException("Invalid SAMRecord: " + sAMRecord.getReadName() + ". This method only works for SAMRecords " + "that are paired reads with both reads aligned.");
        }
        if (bl == sAMRecord.getMateNegativeStrandFlag()) {
            return PairOrientation.TANDEM;
        }
        long l = bl ? sAMRecord.getMateAlignmentStart() : sAMRecord.getAlignmentStart();
        long l2 = bl ? sAMRecord.getAlignmentEnd() : sAMRecord.getAlignmentStart() + sAMRecord.getInferredInsertSize();
        return l < l2 ? PairOrientation.FR : PairOrientation.RF;
    }

    public static boolean isProperPair(SAMRecord sAMRecord, SAMRecord sAMRecord2, List<PairOrientation> list) {
        if (sAMRecord.getReadUnmappedFlag() || sAMRecord2.getReadUnmappedFlag()) {
            return false;
        }
        if (sAMRecord.getReferenceName().equals("*")) {
            return false;
        }
        if (!sAMRecord.getReferenceName().equals(sAMRecord2.getReferenceName())) {
            return false;
        }
        PairOrientation pairOrientation = SamPairUtil.getPairOrientation(sAMRecord);
        return list.contains((Object)pairOrientation);
    }

    public static void assertMate(SAMRecord sAMRecord, SAMRecord sAMRecord2) {
        if (sAMRecord == null) {
            throw new SAMException("First record does not exist - cannot perform mate assertion!");
        }
        if (sAMRecord2 == null) {
            throw new SAMException(sAMRecord.toString() + " is missing its mate");
        }
        if (!sAMRecord.getReadPairedFlag()) {
            throw new SAMException("First record is not marked as paired: " + sAMRecord.toString());
        }
        if (!sAMRecord2.getReadPairedFlag()) {
            throw new SAMException("Second record is not marked as paired: " + sAMRecord2.toString());
        }
        if (!sAMRecord.getFirstOfPairFlag()) {
            throw new SAMException("First record is not marked as first of pair: " + sAMRecord.toString());
        }
        if (!sAMRecord2.getSecondOfPairFlag()) {
            throw new SAMException("Second record is not marked as second of pair: " + sAMRecord2.toString());
        }
        if (!sAMRecord.getReadName().equals(sAMRecord2.getReadName())) {
            throw new SAMException("First [" + sAMRecord.getReadName() + "] and Second [" + sAMRecord2.getReadName() + "] readnames do not match!");
        }
    }

    public static SAMRecord obtainAssertedMate(Iterator<SAMRecord> iterator, SAMRecord sAMRecord) {
        if (iterator.hasNext()) {
            SAMRecord sAMRecord2 = iterator.next();
            SamPairUtil.assertMate(sAMRecord, sAMRecord2);
            return sAMRecord2;
        }
        throw new SAMException("Second record does not exist: " + sAMRecord.getReadName());
    }

    public static int computeInsertSize(SAMRecord sAMRecord, SAMRecord sAMRecord2) {
        if (sAMRecord.getReadUnmappedFlag() || sAMRecord2.getReadUnmappedFlag()) {
            return 0;
        }
        if (!sAMRecord.getReferenceName().equals(sAMRecord2.getReferenceName())) {
            return 0;
        }
        int n = sAMRecord.getReadNegativeStrandFlag() ? sAMRecord.getAlignmentEnd() : sAMRecord.getAlignmentStart();
        int n2 = sAMRecord2.getReadNegativeStrandFlag() ? sAMRecord2.getAlignmentEnd() : sAMRecord2.getAlignmentStart();
        int n3 = n2 >= n ? 1 : -1;
        return n2 - n + n3;
    }

    public static void setMateInfo(SAMRecord sAMRecord, SAMRecord sAMRecord2, boolean bl) {
        if (!sAMRecord.getReadUnmappedFlag() && !sAMRecord2.getReadUnmappedFlag()) {
            sAMRecord.setMateReferenceIndex(sAMRecord2.getReferenceIndex());
            sAMRecord.setMateAlignmentStart(sAMRecord2.getAlignmentStart());
            sAMRecord.setMateNegativeStrandFlag(sAMRecord2.getReadNegativeStrandFlag());
            sAMRecord.setMateUnmappedFlag(false);
            sAMRecord.setAttribute(SAMTag.MQ.name(), (Object)sAMRecord2.getMappingQuality());
            sAMRecord2.setMateReferenceIndex(sAMRecord.getReferenceIndex());
            sAMRecord2.setMateAlignmentStart(sAMRecord.getAlignmentStart());
            sAMRecord2.setMateNegativeStrandFlag(sAMRecord.getReadNegativeStrandFlag());
            sAMRecord2.setMateUnmappedFlag(false);
            sAMRecord2.setAttribute(SAMTag.MQ.name(), (Object)sAMRecord.getMappingQuality());
            if (bl) {
                sAMRecord.setAttribute(SAMTag.MC.name(), (Object)sAMRecord2.getCigarString());
                sAMRecord2.setAttribute(SAMTag.MC.name(), (Object)sAMRecord.getCigarString());
            } else {
                sAMRecord.setAttribute(SAMTag.MC.name(), null);
                sAMRecord2.setAttribute(SAMTag.MC.name(), null);
            }
        } else if (sAMRecord.getReadUnmappedFlag() && sAMRecord2.getReadUnmappedFlag()) {
            sAMRecord.setReferenceIndex(-1);
            sAMRecord.setAlignmentStart(0);
            sAMRecord.setMateReferenceIndex(-1);
            sAMRecord.setMateAlignmentStart(0);
            sAMRecord.setMateNegativeStrandFlag(sAMRecord2.getReadNegativeStrandFlag());
            sAMRecord.setMateUnmappedFlag(true);
            sAMRecord.setAttribute(SAMTag.MQ.name(), null);
            sAMRecord.setAttribute(SAMTag.MC.name(), null);
            sAMRecord.setInferredInsertSize(0);
            sAMRecord2.setReferenceIndex(-1);
            sAMRecord2.setAlignmentStart(0);
            sAMRecord2.setMateReferenceIndex(-1);
            sAMRecord2.setMateAlignmentStart(0);
            sAMRecord2.setMateNegativeStrandFlag(sAMRecord.getReadNegativeStrandFlag());
            sAMRecord2.setMateUnmappedFlag(true);
            sAMRecord2.setAttribute(SAMTag.MQ.name(), null);
            sAMRecord2.setAttribute(SAMTag.MC.name(), null);
            sAMRecord2.setInferredInsertSize(0);
        } else {
            SAMRecord sAMRecord3 = sAMRecord.getReadUnmappedFlag() ? sAMRecord2 : sAMRecord;
            SAMRecord sAMRecord4 = sAMRecord.getReadUnmappedFlag() ? sAMRecord : sAMRecord2;
            sAMRecord4.setReferenceIndex(sAMRecord3.getReferenceIndex());
            sAMRecord4.setAlignmentStart(sAMRecord3.getAlignmentStart());
            sAMRecord3.setMateReferenceIndex(sAMRecord4.getReferenceIndex());
            sAMRecord3.setMateAlignmentStart(sAMRecord4.getAlignmentStart());
            sAMRecord3.setMateNegativeStrandFlag(sAMRecord4.getReadNegativeStrandFlag());
            sAMRecord3.setMateUnmappedFlag(true);
            sAMRecord3.setAttribute(SAMTag.MC.name(), null);
            sAMRecord3.setInferredInsertSize(0);
            sAMRecord4.setMateReferenceIndex(sAMRecord3.getReferenceIndex());
            sAMRecord4.setMateAlignmentStart(sAMRecord3.getAlignmentStart());
            sAMRecord4.setMateNegativeStrandFlag(sAMRecord3.getReadNegativeStrandFlag());
            sAMRecord4.setMateUnmappedFlag(false);
            if (bl) {
                sAMRecord4.setAttribute(SAMTag.MC.name(), (Object)sAMRecord3.getCigarString());
            } else {
                sAMRecord4.setAttribute(SAMTag.MC.name(), null);
            }
            sAMRecord4.setInferredInsertSize(0);
        }
        int n = SamPairUtil.computeInsertSize(sAMRecord, sAMRecord2);
        sAMRecord.setInferredInsertSize(n);
        sAMRecord2.setInferredInsertSize(-n);
    }

    @Deprecated
    public static void setMateInfo(SAMRecord sAMRecord, SAMRecord sAMRecord2, SAMFileHeader sAMFileHeader, boolean bl) {
        SamPairUtil.setMateInfo(sAMRecord, sAMRecord2, bl);
    }

    public static void setMateInfo(SAMRecord sAMRecord, SAMRecord sAMRecord2, SAMFileHeader sAMFileHeader) {
        SamPairUtil.setMateInfo(sAMRecord, sAMRecord2, false);
    }

    public static void setMateInformationOnSupplementalAlignment(SAMRecord sAMRecord, SAMRecord sAMRecord2, boolean bl) {
        sAMRecord.setMateReferenceIndex(sAMRecord2.getReferenceIndex());
        sAMRecord.setMateAlignmentStart(sAMRecord2.getAlignmentStart());
        sAMRecord.setMateNegativeStrandFlag(sAMRecord2.getReadNegativeStrandFlag());
        sAMRecord.setMateUnmappedFlag(sAMRecord2.getReadUnmappedFlag());
        sAMRecord.setInferredInsertSize(-sAMRecord2.getInferredInsertSize());
        if (bl && !sAMRecord2.getReadUnmappedFlag()) {
            sAMRecord.setAttribute(SAMTag.MC.name(), (Object)sAMRecord2.getCigarString());
        } else {
            sAMRecord.setAttribute(SAMTag.MC.name(), null);
        }
    }

    public static void setMateInformationOnSupplementalAlignment(SAMRecord sAMRecord, SAMRecord sAMRecord2) {
        SamPairUtil.setMateInformationOnSupplementalAlignment(sAMRecord, sAMRecord2, false);
    }

    public static void setProperPairAndMateInfo(SAMRecord sAMRecord, SAMRecord sAMRecord2, SAMFileHeader sAMFileHeader, List<PairOrientation> list) {
        SamPairUtil.setProperPairAndMateInfo(sAMRecord, sAMRecord2, sAMFileHeader, list, false);
    }

    public static void setProperPairAndMateInfo(SAMRecord sAMRecord, SAMRecord sAMRecord2, SAMFileHeader sAMFileHeader, List<PairOrientation> list, boolean bl) {
        SamPairUtil.setMateInfo(sAMRecord, sAMRecord2, sAMFileHeader, bl);
        SamPairUtil.setProperPairFlags(sAMRecord, sAMRecord2, list);
    }

    public static void setProperPairFlags(SAMRecord sAMRecord, SAMRecord sAMRecord2, List<PairOrientation> list) {
        boolean bl = !sAMRecord.getReadUnmappedFlag() && !sAMRecord2.getReadUnmappedFlag() ? SamPairUtil.isProperPair(sAMRecord, sAMRecord2, list) : false;
        sAMRecord.setProperPairFlag(bl);
        sAMRecord2.setProperPairFlag(bl);
    }

    public static class SetMateInfoIterator
    extends PeekableIterator<SAMRecord> {
        private final Queue<SAMRecord> records = new LinkedList<SAMRecord>();
        private final boolean setMateCigar;
        private long numMateCigarsAdded = 0L;

        public SetMateInfoIterator(Iterator<SAMRecord> iterator) {
            this(iterator, true);
        }

        public SetMateInfoIterator(Iterator<SAMRecord> iterator, boolean bl) {
            super(iterator);
            this.setMateCigar = bl;
        }

        public long getNumMateCigarsAdded() {
            return this.numMateCigarsAdded;
        }

        @Override
        public boolean hasNext() {
            return !this.records.isEmpty() || super.hasNext();
        }

        private void advance() {
            if (!this.records.isEmpty()) {
                return;
            }
            SAMRecord sAMRecord = null;
            SAMRecord sAMRecord2 = null;
            SAMRecord sAMRecord3 = (SAMRecord)super.peek();
            boolean bl = false;
            while (super.hasNext() && ((SAMRecord)super.peek()).getReadName().equals(sAMRecord3.getReadName())) {
                SAMRecord sAMRecord4 = (SAMRecord)super.next();
                if (sAMRecord4.getReadPairedFlag()) {
                    if (!sAMRecord4.isSecondaryOrSupplementary()) {
                        if (sAMRecord4.getFirstOfPairFlag()) {
                            if (null != sAMRecord) {
                                throw new SAMException("Found two records that are paired, not supplementary, and first of the pair");
                            }
                            sAMRecord = sAMRecord4;
                        } else if (sAMRecord4.getSecondOfPairFlag()) {
                            if (null != sAMRecord2) {
                                throw new SAMException("Found two records that are paired, not supplementary, and second of the pair");
                            }
                            sAMRecord2 = sAMRecord4;
                        }
                    }
                    if (sAMRecord4.getSupplementaryAlignmentFlag()) {
                        bl = true;
                    }
                }
                this.records.add(sAMRecord4);
            }
            if (null != sAMRecord && null != sAMRecord2) {
                SamPairUtil.setMateInfo(sAMRecord, sAMRecord2, this.setMateCigar);
                if (this.setMateCigar) {
                    this.numMateCigarsAdded += 2L;
                }
            }
            if (bl) {
                for (SAMRecord sAMRecord5 : this.records) {
                    if (!sAMRecord5.getReadPairedFlag() || !sAMRecord5.getSupplementaryAlignmentFlag()) continue;
                    if (sAMRecord5.getFirstOfPairFlag()) {
                        SamPairUtil.setMateInformationOnSupplementalAlignment(sAMRecord5, sAMRecord2, this.setMateCigar);
                    } else {
                        SamPairUtil.setMateInformationOnSupplementalAlignment(sAMRecord5, sAMRecord, this.setMateCigar);
                    }
                    ++this.numMateCigarsAdded;
                }
            }
        }

        @Override
        public SAMRecord next() {
            this.advance();
            if (this.records.isEmpty()) {
                throw new IllegalStateException("Unexpectedly found an empty record list");
            }
            return this.records.poll();
        }

        @Override
        public SAMRecord peek() {
            this.advance();
            if (this.records.isEmpty()) {
                throw new IllegalStateException("Unexpectedly found an empty record list");
            }
            return this.records.peek();
        }
    }

    public static enum PairOrientation {
        FR,
        RF,
        TANDEM;

    }
}

