/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.build;

import htsjdk.samtools.cram.common.MutableInt;
import htsjdk.samtools.cram.encoding.BetaIntegerEncoding;
import htsjdk.samtools.cram.encoding.BitCodec;
import htsjdk.samtools.cram.encoding.ByteArrayLenEncoding;
import htsjdk.samtools.cram.encoding.ByteArrayStopEncoding;
import htsjdk.samtools.cram.encoding.Encoding;
import htsjdk.samtools.cram.encoding.ExternalByteArrayEncoding;
import htsjdk.samtools.cram.encoding.ExternalByteEncoding;
import htsjdk.samtools.cram.encoding.ExternalIntegerEncoding;
import htsjdk.samtools.cram.encoding.GammaIntegerEncoding;
import htsjdk.samtools.cram.encoding.HuffmanByteEncoding;
import htsjdk.samtools.cram.encoding.HuffmanIntegerEncoding;
import htsjdk.samtools.cram.encoding.NullEncoding;
import htsjdk.samtools.cram.encoding.SubexpIntegerEncoding;
import htsjdk.samtools.cram.encoding.huffman.HuffmanCode;
import htsjdk.samtools.cram.encoding.huffman.HuffmanTree;
import htsjdk.samtools.cram.encoding.read_features.Deletion;
import htsjdk.samtools.cram.encoding.read_features.HardClip;
import htsjdk.samtools.cram.encoding.read_features.Padding;
import htsjdk.samtools.cram.encoding.read_features.ReadFeature;
import htsjdk.samtools.cram.encoding.read_features.RefSkip;
import htsjdk.samtools.cram.encoding.read_features.Substitution;
import htsjdk.samtools.cram.structure.CompressionHeader;
import htsjdk.samtools.cram.structure.CramCompressionRecord;
import htsjdk.samtools.cram.structure.EncodingKey;
import htsjdk.samtools.cram.structure.EncodingParams;
import htsjdk.samtools.cram.structure.ReadTag;
import htsjdk.samtools.cram.structure.SubstitutionMatrix;
import htsjdk.samtools.util.Log;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;

public class CompressionHeaderFactory {
    private static final Charset charset = Charset.forName("US-ASCII");
    private static Log log = Log.getInstance(CompressionHeaderFactory.class);
    private static final int oqz = ReadTag.nameType3BytesToInt("OQ", 'Z');
    private static final int bqz = ReadTag.nameType3BytesToInt("OQ", 'Z');

    /*
     * WARNING - void declaration
     */
    public CompressionHeader build(List<CramCompressionRecord> list, SubstitutionMatrix substitutionMatrix) {
        Object object;
        void cramCompressionRecord;
        CompressionHeader compressionHeader = new CompressionHeader();
        compressionHeader.externalIds = new ArrayList<Integer>();
        int n = 0;
        int n2 = n++;
        compressionHeader.externalIds.add(n2);
        int n3 = n++;
        compressionHeader.externalIds.add(n3);
        int n4 = n++;
        compressionHeader.externalIds.add(n4);
        int n5 = n++;
        compressionHeader.externalIds.add(n5);
        int n6 = n++;
        compressionHeader.externalIds.add(n6);
        log.debug("Assigned external id to bases: " + n2);
        log.debug("Assigned external id to quality scores: " + n3);
        log.debug("Assigned external id to read names: " + n4);
        log.debug("Assigned external id to mate info: " + n5);
        log.debug("Assigned external id to tag values: " + n6);
        compressionHeader.eMap = new TreeMap<EncodingKey, EncodingParams>();
        Object object3 = EncodingKey.values();
        int n7 = ((EncodingKey[])object3).length;
        boolean bl = false;
        while (cramCompressionRecord < n7) {
            EncodingKey encodingKey = object3[cramCompressionRecord];
            compressionHeader.eMap.put(encodingKey, NullEncoding.toParam());
            ++cramCompressionRecord;
        }
        compressionHeader.tMap = new TreeMap<Integer, EncodingParams>();
        CompressionHeaderFactory.getOptimalIntegerEncoding(compressionHeader, EncodingKey.BF_BitFlags, 0, list);
        CompressionHeaderFactory.getOptimalIntegerEncoding(compressionHeader, EncodingKey.CF_CompressionBitFlags, 0, list);
        CompressionHeaderFactory.getOptimalIntegerEncoding(compressionHeader, EncodingKey.RI_RefId, -2, list);
        CompressionHeaderFactory.getOptimalIntegerEncoding(compressionHeader, EncodingKey.RL_ReadLength, 0, list);
        CompressionHeaderFactory.getOptimalIntegerEncoding(compressionHeader, EncodingKey.AP_AlignmentPositionOffset, 0, list);
        CompressionHeaderFactory.getOptimalIntegerEncoding(compressionHeader, EncodingKey.RG_ReadGroup, -1, list);
        object3 = new HuffmanParamsCalculator();
        for (CramCompressionRecord cramCompressionRecord2 : list) {
            ((HuffmanParamsCalculator)object3).add(cramCompressionRecord2.readName.length());
        }
        ((HuffmanParamsCalculator)object3).calculate();
        compressionHeader.eMap.put(EncodingKey.RN_ReadName, ByteArrayLenEncoding.toParam(HuffmanIntegerEncoding.toParam(((HuffmanParamsCalculator)object3).values(), ((HuffmanParamsCalculator)object3).bitLens()), ExternalByteArrayEncoding.toParam(n4)));
        object3 = new IntegerEncodingCalculator(EncodingKey.NF_RecordsToNextFragment.name(), 0);
        for (CramCompressionRecord cramCompressionRecord3 : list) {
            if (!cramCompressionRecord3.isHasMateDownStream()) continue;
            ((IntegerEncodingCalculator)object3).addValue(cramCompressionRecord3.recordsToNextFragment);
        }
        Iterator<CramCompressionRecord> iterator = ((IntegerEncodingCalculator)object3).getBestEncoding();
        compressionHeader.eMap.put(EncodingKey.NF_RecordsToNextFragment, new EncodingParams(iterator.id(), iterator.toByteArray()));
        object3 = new HuffmanParamsCalculator();
        for (CramCompressionRecord cramCompressionRecord4 : list) {
            ((HuffmanParamsCalculator)object3).add(cramCompressionRecord4.tags == null ? 0 : cramCompressionRecord4.tags.length);
        }
        ((HuffmanParamsCalculator)object3).calculate();
        compressionHeader.eMap.put(EncodingKey.TC_TagCount, HuffmanIntegerEncoding.toParam(((HuffmanParamsCalculator)object3).values(), ((HuffmanParamsCalculator)object3).bitLens()));
        object3 = new HuffmanParamsCalculator();
        for (CramCompressionRecord object42 : list) {
            if (object42.tags == null) continue;
            for (ReadTag readTag : object42.tags) {
                ((HuffmanParamsCalculator)object3).add(readTag.keyType3BytesAsInt);
            }
        }
        ((HuffmanParamsCalculator)object3).calculate();
        compressionHeader.eMap.put(EncodingKey.TN_TagNameAndType, HuffmanIntegerEncoding.toParam(((HuffmanParamsCalculator)object3).values(), ((HuffmanParamsCalculator)object3).bitLens()));
        object3 = new Comparator<ReadTag>(){

            @Override
            public int compare(ReadTag readTag, ReadTag readTag2) {
                return readTag.keyType3BytesAsInt - readTag2.keyType3BytesAsInt;
            }
        };
        iterator = new Comparator<byte[]>(){

            @Override
            public int compare(byte[] byArray, byte[] byArray2) {
                if (byArray.length - byArray2.length != 0) {
                    return byArray.length - byArray2.length;
                }
                for (int i = 0; i < byArray.length; ++i) {
                    if (byArray[i] == byArray2[i]) continue;
                    return byArray[i] - byArray2[i];
                }
                return 0;
            }
        };
        TreeMap<byte[], Object> treeMap = new TreeMap<byte[], Object>((Comparator<byte[]>)((Object)iterator));
        MutableInt mutableInt = new MutableInt();
        treeMap.put(new byte[0], mutableInt);
        for (CramCompressionRecord cramCompressionRecord5 : list) {
            if (cramCompressionRecord5.tags == null) {
                ++mutableInt.value;
                cramCompressionRecord5.tagIdsIndex = mutableInt;
                continue;
            }
            Arrays.sort(cramCompressionRecord5.tags, object3);
            cramCompressionRecord5.tagIds = new byte[cramCompressionRecord5.tags.length * 3];
            int n8 = 0;
            for (int i = 0; i < cramCompressionRecord5.tags.length; ++i) {
                cramCompressionRecord5.tagIds[i * 3] = (byte)cramCompressionRecord5.tags[n8].keyType3Bytes.charAt(0);
                cramCompressionRecord5.tagIds[i * 3 + 1] = (byte)cramCompressionRecord5.tags[n8].keyType3Bytes.charAt(1);
                cramCompressionRecord5.tagIds[i * 3 + 2] = (byte)cramCompressionRecord5.tags[n8].keyType3Bytes.charAt(2);
                ++n8;
            }
            object = (MutableInt)treeMap.get(cramCompressionRecord5.tagIds);
            if (object == null) {
                object = new MutableInt();
                treeMap.put(cramCompressionRecord5.tagIds, object);
            }
            ++((MutableInt)object).value;
            cramCompressionRecord5.tagIdsIndex = object;
        }
        Object object2 = new byte[treeMap.size()][][];
        int n9 = 0;
        HuffmanParamsCalculator huffmanParamsCalculator = new HuffmanParamsCalculator();
        for (byte[] byArray : treeMap.keySet()) {
            int n10 = byArray.length / 3;
            object2[n9] = new byte[n10][];
            int n11 = 0;
            while (n11 < byArray.length) {
                int n12 = n11 / 3;
                object2[n9][n12] = new byte[3];
                object2[n9][n12][0] = byArray[n11++];
                object2[n9][n12][1] = byArray[n11++];
                object2[n9][n12][2] = byArray[n11++];
            }
            huffmanParamsCalculator.add(n9, ((MutableInt)treeMap.get((Object)byArray)).value);
            ((MutableInt)treeMap.get((Object)byArray)).value = n9++;
        }
        huffmanParamsCalculator.calculate();
        compressionHeader.eMap.put(EncodingKey.TL_TagIdList, HuffmanIntegerEncoding.toParam(huffmanParamsCalculator.values(), huffmanParamsCalculator.bitLens()));
        compressionHeader.dictionary = (byte[][][])object2;
        object3 = new TreeMap();
        for (CramCompressionRecord cramCompressionRecord6 : list) {
            if (cramCompressionRecord6.tags == null) continue;
            for (ReadTag readTag : cramCompressionRecord6.tags) {
                switch (readTag.keyType3BytesAsInt) {
                    default: 
                }
                object = (HuffmanParamsCalculator)object3.get(readTag.keyType3BytesAsInt);
                if (object == null) {
                    object = new HuffmanParamsCalculator();
                    object3.put(readTag.keyType3BytesAsInt, object);
                }
                ((HuffmanParamsCalculator)object).add(readTag.getValueAsByteArray().length);
            }
        }
        if (!object3.isEmpty()) {
            for (Integer n13 : object3.keySet()) {
                HuffmanParamsCalculator huffmanParamsCalculator2 = (HuffmanParamsCalculator)object3.get(n13);
                huffmanParamsCalculator2.calculate();
                compressionHeader.tMap.put(n13, ByteArrayLenEncoding.toParam(HuffmanIntegerEncoding.toParam(huffmanParamsCalculator2.values(), huffmanParamsCalculator2.bitLens()), ExternalByteArrayEncoding.toParam(n6)));
            }
        }
        for (Integer n14 : compressionHeader.tMap.keySet()) {
            log.debug(String.format("TAG ENCODING: %d, %s", n14, compressionHeader.tMap.get(n14)));
        }
        object3 = new HuffmanParamsCalculator();
        for (CramCompressionRecord cramCompressionRecord7 : list) {
            ((HuffmanParamsCalculator)object3).add(cramCompressionRecord7.readFeatures == null ? 0 : cramCompressionRecord7.readFeatures.size());
        }
        ((HuffmanParamsCalculator)object3).calculate();
        compressionHeader.eMap.put(EncodingKey.FN_NumberOfReadFeatures, HuffmanIntegerEncoding.toParam(((HuffmanParamsCalculator)object3).values(), ((HuffmanParamsCalculator)object3).bitLens()));
        object3 = new IntegerEncodingCalculator("read feature position", 0);
        for (CramCompressionRecord cramCompressionRecord8 : list) {
            boolean bl2 = false;
            if (cramCompressionRecord8.readFeatures == null) continue;
            for (ReadFeature readFeature : cramCompressionRecord8.readFeatures) {
                int n15;
                ((IntegerEncodingCalculator)object3).addValue(readFeature.getPosition() - n15);
                n15 = readFeature.getPosition();
            }
        }
        iterator = ((IntegerEncodingCalculator)object3).getBestEncoding();
        compressionHeader.eMap.put(EncodingKey.FP_FeaturePosition, new EncodingParams(iterator.id(), iterator.toByteArray()));
        object3 = new HuffmanParamsCalculator();
        for (CramCompressionRecord cramCompressionRecord9 : list) {
            if (cramCompressionRecord9.readFeatures == null) continue;
            for (ReadFeature readFeature : cramCompressionRecord9.readFeatures) {
                ((HuffmanParamsCalculator)object3).add(readFeature.getOperator());
            }
        }
        ((HuffmanParamsCalculator)object3).calculate();
        compressionHeader.eMap.put(EncodingKey.FC_FeatureCode, HuffmanByteEncoding.toParam(((HuffmanParamsCalculator)object3).valuesAsBytes(), ((HuffmanParamsCalculator)object3).bitLens));
        compressionHeader.eMap.put(EncodingKey.BA_Base, ExternalByteEncoding.toParam(n2));
        compressionHeader.eMap.put(EncodingKey.QS_QualityScore, ExternalByteEncoding.toParam(n3));
        if (substitutionMatrix == null) {
            object3 = new long[200][200];
            for (CramCompressionRecord cramCompressionRecord10 : list) {
                if (cramCompressionRecord10.readFeatures == null) continue;
                for (ReadFeature readFeature : cramCompressionRecord10.readFeatures) {
                    if (readFeature.getOperator() != 88) continue;
                    Substitution substitution = (Substitution)readFeature;
                    byte by = substitution.getRefernceBase();
                    byte by2 = substitution.getBase();
                    Object object4 = object3[by];
                    byte by3 = by2;
                    object4[by3] = object4[by3] + 1L;
                }
            }
            compressionHeader.substitutionMatrix = new SubstitutionMatrix((long[][])object3);
        } else {
            compressionHeader.substitutionMatrix = substitutionMatrix;
        }
        object3 = new HuffmanParamsCalculator();
        for (CramCompressionRecord cramCompressionRecord11 : list) {
            if (cramCompressionRecord11.readFeatures == null) continue;
            for (ReadFeature readFeature : cramCompressionRecord11.readFeatures) {
                if (readFeature.getOperator() != 88) continue;
                Substitution substitution = (Substitution)readFeature;
                if (substitution.getCode() == -1) {
                    byte by = substitution.getRefernceBase();
                    byte by4 = substitution.getBase();
                    substitution.setCode(compressionHeader.substitutionMatrix.code(by, by4));
                }
                ((HuffmanParamsCalculator)object3).add(substitution.getCode());
            }
        }
        ((HuffmanParamsCalculator)object3).calculate();
        compressionHeader.eMap.put(EncodingKey.BS_BaseSubstitutionCode, HuffmanIntegerEncoding.toParam(((HuffmanParamsCalculator)object3).values, ((HuffmanParamsCalculator)object3).bitLens));
        compressionHeader.eMap.put(EncodingKey.IN_Insertion, ByteArrayStopEncoding.toParam((byte)0, n2));
        compressionHeader.eMap.put(EncodingKey.SC_SoftClip, ByteArrayStopEncoding.toParam((byte)0, n2));
        object3 = new HuffmanParamsCalculator();
        for (CramCompressionRecord cramCompressionRecord12 : list) {
            if (cramCompressionRecord12.readFeatures == null) continue;
            for (ReadFeature readFeature : cramCompressionRecord12.readFeatures) {
                if (readFeature.getOperator() != 68) continue;
                ((HuffmanParamsCalculator)object3).add(((Deletion)readFeature).getLength());
            }
        }
        ((HuffmanParamsCalculator)object3).calculate();
        compressionHeader.eMap.put(EncodingKey.DL_DeletionLength, HuffmanIntegerEncoding.toParam(((HuffmanParamsCalculator)object3).values, ((HuffmanParamsCalculator)object3).bitLens));
        object3 = new IntegerEncodingCalculator(EncodingKey.HC_HardClip.name(), 1);
        for (CramCompressionRecord cramCompressionRecord13 : list) {
            if (cramCompressionRecord13.readFeatures == null) continue;
            for (ReadFeature readFeature : cramCompressionRecord13.readFeatures) {
                if (readFeature.getOperator() != 72) continue;
                ((IntegerEncodingCalculator)object3).addValue(((HardClip)readFeature).getLength());
            }
        }
        iterator = ((IntegerEncodingCalculator)object3).getBestEncoding();
        compressionHeader.eMap.put(EncodingKey.HC_HardClip, new EncodingParams(iterator.id(), iterator.toByteArray()));
        object3 = new IntegerEncodingCalculator(EncodingKey.PD_padding.name(), 1);
        for (CramCompressionRecord cramCompressionRecord14 : list) {
            if (cramCompressionRecord14.readFeatures == null) continue;
            for (ReadFeature readFeature : cramCompressionRecord14.readFeatures) {
                if (readFeature.getOperator() != 80) continue;
                ((IntegerEncodingCalculator)object3).addValue(((Padding)readFeature).getLength());
            }
        }
        iterator = ((IntegerEncodingCalculator)object3).getBestEncoding();
        compressionHeader.eMap.put(EncodingKey.PD_padding, new EncodingParams(iterator.id(), iterator.toByteArray()));
        object3 = new HuffmanParamsCalculator();
        for (CramCompressionRecord cramCompressionRecord15 : list) {
            if (cramCompressionRecord15.readFeatures == null) continue;
            for (ReadFeature readFeature : cramCompressionRecord15.readFeatures) {
                if (readFeature.getOperator() != 78) continue;
                ((HuffmanParamsCalculator)object3).add(((RefSkip)readFeature).getLength());
            }
        }
        ((HuffmanParamsCalculator)object3).calculate();
        compressionHeader.eMap.put(EncodingKey.RS_RefSkip, HuffmanIntegerEncoding.toParam(((HuffmanParamsCalculator)object3).values, ((HuffmanParamsCalculator)object3).bitLens));
        object3 = new HuffmanParamsCalculator();
        for (CramCompressionRecord cramCompressionRecord16 : list) {
            if (cramCompressionRecord16.isSegmentUnmapped()) continue;
            ((HuffmanParamsCalculator)object3).add(cramCompressionRecord16.mappingQuality);
        }
        ((HuffmanParamsCalculator)object3).calculate();
        compressionHeader.eMap.put(EncodingKey.MQ_MappingQualityScore, HuffmanIntegerEncoding.toParam(((HuffmanParamsCalculator)object3).values(), ((HuffmanParamsCalculator)object3).bitLens));
        object3 = new HuffmanParamsCalculator();
        for (CramCompressionRecord cramCompressionRecord17 : list) {
            ((HuffmanParamsCalculator)object3).add(cramCompressionRecord17.getMateFlags());
        }
        ((HuffmanParamsCalculator)object3).calculate();
        compressionHeader.eMap.put(EncodingKey.MF_MateBitFlags, HuffmanIntegerEncoding.toParam(((HuffmanParamsCalculator)object3).values, ((HuffmanParamsCalculator)object3).bitLens));
        object3 = new HuffmanParamsCalculator();
        for (CramCompressionRecord cramCompressionRecord18 : list) {
            if (!cramCompressionRecord18.isDetached()) continue;
            ((HuffmanParamsCalculator)object3).add(cramCompressionRecord18.mateSequenceID);
        }
        ((HuffmanParamsCalculator)object3).calculate();
        if (((HuffmanParamsCalculator)object3).values.length == 0) {
            compressionHeader.eMap.put(EncodingKey.NS_NextFragmentReferenceSequenceID, NullEncoding.toParam());
        }
        compressionHeader.eMap.put(EncodingKey.NS_NextFragmentReferenceSequenceID, HuffmanIntegerEncoding.toParam(((HuffmanParamsCalculator)object3).values(), ((HuffmanParamsCalculator)object3).bitLens()));
        log.debug("NS: " + compressionHeader.eMap.get((Object)EncodingKey.NS_NextFragmentReferenceSequenceID));
        compressionHeader.eMap.put(EncodingKey.NP_NextFragmentAlignmentStart, ExternalIntegerEncoding.toParam(n5));
        compressionHeader.eMap.put(EncodingKey.TS_InsetSize, ExternalIntegerEncoding.toParam(n5));
        return compressionHeader;
    }

    private static final int getValue(EncodingKey encodingKey, CramCompressionRecord cramCompressionRecord) {
        switch (encodingKey) {
            case AP_AlignmentPositionOffset: {
                return cramCompressionRecord.alignmentDelta;
            }
            case BF_BitFlags: {
                return cramCompressionRecord.flags;
            }
            case CF_CompressionBitFlags: {
                return cramCompressionRecord.compressionFlags;
            }
            case FN_NumberOfReadFeatures: {
                return cramCompressionRecord.readFeatures == null ? 0 : cramCompressionRecord.readFeatures.size();
            }
            case MF_MateBitFlags: {
                return cramCompressionRecord.mateFlags;
            }
            case MQ_MappingQualityScore: {
                return cramCompressionRecord.mappingQuality;
            }
            case NF_RecordsToNextFragment: {
                return cramCompressionRecord.recordsToNextFragment;
            }
            case NP_NextFragmentAlignmentStart: {
                return cramCompressionRecord.mateAlignmentStart;
            }
            case NS_NextFragmentReferenceSequenceID: {
                return cramCompressionRecord.mateSequenceID;
            }
            case RG_ReadGroup: {
                return cramCompressionRecord.readGroupID;
            }
            case RI_RefId: {
                return cramCompressionRecord.sequenceId;
            }
            case RL_ReadLength: {
                return cramCompressionRecord.readLength;
            }
            case TC_TagCount: {
                return cramCompressionRecord.tags == null ? 0 : cramCompressionRecord.tags.length;
            }
        }
        throw new RuntimeException("Unexpected encoding key: " + encodingKey.name());
    }

    private static final void getOptimalIntegerEncoding(CompressionHeader compressionHeader, EncodingKey encodingKey, int n, List<CramCompressionRecord> list) {
        IntegerEncodingCalculator integerEncodingCalculator = new IntegerEncodingCalculator(encodingKey.name(), n);
        for (CramCompressionRecord cramCompressionRecord : list) {
            int n2 = CompressionHeaderFactory.getValue(encodingKey, cramCompressionRecord);
            integerEncodingCalculator.addValue(n2);
        }
        Encoding<Integer> encoding = integerEncodingCalculator.getBestEncoding();
        compressionHeader.eMap.put(encodingKey, new EncodingParams(encoding.id(), encoding.toByteArray()));
    }

    private static Integer[] autobox(int[] nArray) {
        Integer[] integerArray = new Integer[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            integerArray[i] = nArray[i];
        }
        return integerArray;
    }

    public static class IntegerEncodingCalculator {
        public List<EncodingLengthCalculator> calcs = new ArrayList<EncodingLengthCalculator>();
        private int max = 0;
        private int count = 0;
        private String name;
        private HashMap<Integer, MutableInt> dictionary = new HashMap();
        private int dictionaryThreshold = 100;

        public IntegerEncodingCalculator(String string, int n, int n2) {
            this.name = string;
            this.calcs.add(new EncodingLengthCalculator(new GammaIntegerEncoding(1 - n2)));
            for (int i = 2; i < 5; ++i) {
                this.calcs.add(new EncodingLengthCalculator(new SubexpIntegerEncoding(0 - n2, i)));
            }
            this.dictionary = n < 1 ? null : new HashMap();
        }

        public IntegerEncodingCalculator(String string, int n) {
            this(string, 255, n);
        }

        public void addValue(int n) {
            ++this.count;
            if (n > this.max) {
                this.max = n;
            }
            for (EncodingLengthCalculator encodingLengthCalculator : this.calcs) {
                encodingLengthCalculator.add(n);
            }
            if (this.dictionary != null) {
                if (this.dictionary.size() >= this.dictionaryThreshold - 1) {
                    this.dictionary = null;
                } else {
                    Object object = this.dictionary.get(n);
                    if (object == null) {
                        object = new MutableInt();
                        this.dictionary.put(n, (MutableInt)object);
                    }
                    ++((MutableInt)object).value;
                }
            }
        }

        public Encoding<Integer> getBestEncoding() {
            int n;
            if (this.dictionary != null && this.dictionary.size() == 1) {
                int n2 = this.dictionary.keySet().iterator().next();
                EncodingParams encodingParams = HuffmanIntegerEncoding.toParam(new int[]{n2}, new int[]{0});
                HuffmanIntegerEncoding huffmanIntegerEncoding = new HuffmanIntegerEncoding();
                huffmanIntegerEncoding.fromByteArray(encodingParams.params);
                return huffmanIntegerEncoding;
            }
            EncodingLengthCalculator encodingLengthCalculator = this.calcs.get(0);
            for (EncodingLengthCalculator encodingLengthCalculator2 : this.calcs) {
                if (encodingLengthCalculator2.len() >= encodingLengthCalculator.len()) continue;
                encodingLengthCalculator = encodingLengthCalculator2;
            }
            Object object = encodingLengthCalculator.encoding;
            long l = encodingLengthCalculator.len();
            if (l > (long)((n = (int)Math.round(Math.log(this.max) / Math.log(2.0) + 0.5)) * this.count)) {
                object = new BetaIntegerEncoding(n);
                l = n * this.count;
            }
            if (this.dictionary != null) {
                HuffmanParamsCalculator huffmanParamsCalculator = new HuffmanParamsCalculator();
                for (Integer object22 : this.dictionary.keySet()) {
                    huffmanParamsCalculator.add(object22, this.dictionary.get((Object)object22).value);
                }
                huffmanParamsCalculator.calculate();
                EncodingParams encodingParams = HuffmanIntegerEncoding.toParam(huffmanParamsCalculator.values(), huffmanParamsCalculator.bitLens());
                HuffmanIntegerEncoding huffmanIntegerEncoding = new HuffmanIntegerEncoding();
                huffmanIntegerEncoding.fromByteArray(encodingParams.params);
                EncodingLengthCalculator encodingLengthCalculator2 = new EncodingLengthCalculator(huffmanIntegerEncoding);
                for (Integer n2 : this.dictionary.keySet()) {
                    encodingLengthCalculator2.add(n2, this.dictionary.get((Object)n2).value);
                }
                if (encodingLengthCalculator2.len() < l) {
                    object = huffmanIntegerEncoding;
                    l = encodingLengthCalculator2.len();
                }
            }
            byte[] byArray = object.toByteArray();
            byArray = Arrays.copyOf(byArray, Math.min(byArray.length, 20));
            log.debug("Best encoding for " + this.name + ": " + object.id().name() + Arrays.toString(byArray));
            return object;
        }
    }

    public static class EncodingLengthCalculator {
        private BitCodec<Integer> codec;
        private Encoding<Integer> encoding;
        private long len;

        public EncodingLengthCalculator(Encoding<Integer> encoding) {
            this.encoding = encoding;
            this.codec = encoding.buildCodec(null, null);
        }

        public void add(int n) {
            this.len += this.codec.numberOfBits(n);
        }

        public void add(int n, int n2) {
            this.len += (long)n2 * this.codec.numberOfBits(n);
        }

        public long len() {
            return this.len;
        }
    }

    public static class HuffmanParamsCalculator {
        private HashMap<Integer, MutableInt> countMap = new HashMap();
        private int[] values = new int[0];
        private int[] bitLens = new int[0];

        public void add(int n) {
            MutableInt mutableInt = this.countMap.get(n);
            if (mutableInt == null) {
                mutableInt = new MutableInt();
                this.countMap.put(n, mutableInt);
            }
            ++mutableInt.value;
        }

        public void add(Integer n, int n2) {
            MutableInt mutableInt = this.countMap.get(n);
            if (mutableInt == null) {
                mutableInt = new MutableInt();
                this.countMap.put(n, mutableInt);
            }
            mutableInt.value += n2;
        }

        public int[] bitLens() {
            return this.bitLens;
        }

        public int[] values() {
            return this.values;
        }

        public Integer[] valuesAsAutoIntegers() {
            Integer[] integerArray = new Integer[this.values.length];
            for (int i = 0; i < integerArray.length; ++i) {
                integerArray[i] = this.values[i];
            }
            return integerArray;
        }

        public byte[] valuesAsBytes() {
            byte[] byArray = new byte[this.values.length];
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = (byte)(0xFF & this.values[i]);
            }
            return byArray;
        }

        public Byte[] valuesAsAutoBytes() {
            Byte[] byteArray = new Byte[this.values.length];
            for (int i = 0; i < byteArray.length; ++i) {
                byteArray[i] = (byte)(0xFF & this.values[i]);
            }
            return byteArray;
        }

        public void calculate() {
            HuffmanTree<Integer> huffmanTree = null;
            int n = this.countMap.size();
            Object object = new int[n];
            Object[] objectArray = new int[n];
            int n2 = 0;
            for (Integer n3 : this.countMap.keySet()) {
                objectArray[n2] = n3;
                object[n2] = this.countMap.get((Object)n3).value;
                ++n2;
            }
            huffmanTree = HuffmanCode.buildTree((int[])object, CompressionHeaderFactory.autobox(objectArray));
            ArrayList arrayList = new ArrayList();
            object = new ArrayList();
            HuffmanCode.getValuesAndBitLengths(arrayList, (List<Integer>)object, huffmanTree);
            objectArray = new BitCode[arrayList.size()];
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                objectArray[n2] = (int)new BitCode((Integer)arrayList.get(n2), (Integer)object.get(n2));
            }
            Arrays.sort(objectArray);
            this.values = new int[objectArray.length];
            this.bitLens = new int[objectArray.length];
            for (n2 = 0; n2 < objectArray.length; ++n2) {
                Object object2 = objectArray[n2];
                this.bitLens[n2] = ((BitCode)object2).len;
                this.values[n2] = ((BitCode)object2).value;
            }
        }
    }

    private static class BitCode
    implements Comparable<BitCode> {
        int value;
        int len;

        public BitCode(int n, int n2) {
            this.value = n;
            this.len = n2;
        }

        @Override
        public int compareTo(BitCode bitCode) {
            int n = this.value - bitCode.value;
            if (n != 0) {
                return n;
            }
            return this.len - bitCode.len;
        }
    }
}

