/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.build;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.cram.build.Utils;
import htsjdk.samtools.cram.encoding.read_features.BaseQualityScore;
import htsjdk.samtools.cram.encoding.read_features.Deletion;
import htsjdk.samtools.cram.encoding.read_features.InsertBase;
import htsjdk.samtools.cram.encoding.read_features.Insertion;
import htsjdk.samtools.cram.encoding.read_features.ReadBase;
import htsjdk.samtools.cram.encoding.read_features.ReadFeature;
import htsjdk.samtools.cram.encoding.read_features.SoftClip;
import htsjdk.samtools.cram.encoding.read_features.Substitution;
import htsjdk.samtools.cram.ref.ReferenceSource;
import htsjdk.samtools.cram.structure.CramCompressionRecord;
import htsjdk.samtools.cram.structure.SubstitutionMatrix;
import htsjdk.samtools.util.Log;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CramNormalizer {
    private SAMFileHeader header;
    private int readCounter = 0;
    private String readNamePrefix = "";
    private byte defaultQualityScore = (byte)30;
    private static Log log = Log.getInstance(CramNormalizer.class);
    private ReferenceSource referenceSource;

    public CramNormalizer(SAMFileHeader sAMFileHeader) {
        this.header = sAMFileHeader;
    }

    public CramNormalizer(SAMFileHeader sAMFileHeader, ReferenceSource referenceSource) {
        this.header = sAMFileHeader;
        this.referenceSource = referenceSource;
    }

    public void normalize(ArrayList<CramCompressionRecord> arrayList, boolean bl, byte[] byArray, int n, SubstitutionMatrix substitutionMatrix, boolean bl2) {
        Object object;
        int n2 = this.readCounter;
        for (CramCompressionRecord cramCompressionRecord : arrayList) {
            cramCompressionRecord.index = ++this.readCounter;
            if (cramCompressionRecord.sequenceId == -1) {
                cramCompressionRecord.sequenceName = "*";
                cramCompressionRecord.alignmentStart = 0;
                continue;
            }
            cramCompressionRecord.sequenceName = this.header.getSequence(cramCompressionRecord.sequenceId).getSequenceName();
        }
        for (CramCompressionRecord cramCompressionRecord : arrayList) {
            int n3;
            if (!cramCompressionRecord.isMultiFragment() || cramCompressionRecord.isDetached()) {
                cramCompressionRecord.recordsToNextFragment = -1;
                cramCompressionRecord.next = null;
                cramCompressionRecord.previous = null;
                continue;
            }
            if (!cramCompressionRecord.isHasMateDownStream()) continue;
            object = arrayList.get(cramCompressionRecord.index + cramCompressionRecord.recordsToNextFragment - n2);
            cramCompressionRecord.next = object;
            ((CramCompressionRecord)object).previous = cramCompressionRecord;
            cramCompressionRecord.mateAlignmentStart = ((CramCompressionRecord)object).alignmentStart;
            cramCompressionRecord.setMateUmapped(((CramCompressionRecord)object).isSegmentUnmapped());
            cramCompressionRecord.setMateNegativeStrand(((CramCompressionRecord)object).isNegativeStrand());
            cramCompressionRecord.mateSequenceID = ((CramCompressionRecord)object).sequenceId;
            if (cramCompressionRecord.mateSequenceID == -1) {
                cramCompressionRecord.mateAlignmentStart = 0;
            }
            ((CramCompressionRecord)object).mateAlignmentStart = cramCompressionRecord.alignmentStart;
            ((CramCompressionRecord)object).setMateUmapped(cramCompressionRecord.isSegmentUnmapped());
            ((CramCompressionRecord)object).setMateNegativeStrand(cramCompressionRecord.isNegativeStrand());
            ((CramCompressionRecord)object).mateSequenceID = cramCompressionRecord.sequenceId;
            if (((CramCompressionRecord)object).mateSequenceID == -1) {
                ((CramCompressionRecord)object).mateAlignmentStart = 0;
            }
            if (cramCompressionRecord.isFirstSegment()) {
                cramCompressionRecord.templateSize = n3 = CramNormalizer.computeInsertSize(cramCompressionRecord, (CramCompressionRecord)object);
                ((CramCompressionRecord)object).templateSize = -n3;
                continue;
            }
            ((CramCompressionRecord)object).templateSize = n3 = CramNormalizer.computeInsertSize((CramCompressionRecord)object, cramCompressionRecord);
            cramCompressionRecord.templateSize = -n3;
        }
        for (CramCompressionRecord cramCompressionRecord : arrayList) {
            if (cramCompressionRecord.readName != null) continue;
            object = this.readNamePrefix + cramCompressionRecord.index;
            cramCompressionRecord.readName = object;
            if (cramCompressionRecord.next != null) {
                cramCompressionRecord.next.readName = object;
            }
            if (cramCompressionRecord.previous == null) continue;
            cramCompressionRecord.previous.readName = object;
        }
        for (CramCompressionRecord cramCompressionRecord : arrayList) {
            if (cramCompressionRecord.isSegmentUnmapped()) continue;
            object = byArray;
            if (this.referenceSource != null) {
                object = this.referenceSource.getReferenceBases(this.header.getSequence(cramCompressionRecord.sequenceId), true);
            }
            byte[] byArray2 = CramNormalizer.restoreReadBases(cramCompressionRecord, (byte[])object, substitutionMatrix);
            cramCompressionRecord.readBases = byArray2;
        }
        CramNormalizer.restoreQualityScores(this.defaultQualityScore, arrayList);
    }

    public static void restoreQualityScores(byte by, List<CramCompressionRecord> list) {
        for (CramCompressionRecord cramCompressionRecord : list) {
            CramNormalizer.restoreQualityScores(by, cramCompressionRecord);
        }
    }

    public static byte[] restoreQualityScores(byte by, CramCompressionRecord cramCompressionRecord) {
        if (!cramCompressionRecord.isForcePreserveQualityScores()) {
            byte[] byArray = new byte[cramCompressionRecord.readLength];
            Arrays.fill(byArray, by);
            if (cramCompressionRecord.readFeatures != null) {
                for (ReadFeature readFeature : cramCompressionRecord.readFeatures) {
                    switch (readFeature.getOperator()) {
                        case 81: {
                            int n = readFeature.getPosition();
                            byte by2 = ((BaseQualityScore)readFeature).getQualityScore();
                            try {
                                byArray[n - 1] = by2;
                                break;
                            }
                            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                System.err.println("PROBLEM CAUSED BY:");
                                System.err.println(cramCompressionRecord.toString());
                                throw arrayIndexOutOfBoundsException;
                            }
                        }
                        case 66: {
                            int n = readFeature.getPosition();
                            byte by2 = ((ReadBase)readFeature).getQualityScore();
                            try {
                                byArray[n - 1] = by2;
                                break;
                            }
                            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                System.err.println("PROBLEM CAUSED BY:");
                                System.err.println(cramCompressionRecord.toString());
                                throw arrayIndexOutOfBoundsException;
                            }
                        }
                    }
                }
            }
            cramCompressionRecord.qualityScores = byArray;
        } else {
            byte[] byArray = cramCompressionRecord.qualityScores;
            for (int i = 0; i < byArray.length; ++i) {
                if (byArray[i] != -1) continue;
                byArray[i] = by;
            }
        }
        return cramCompressionRecord.qualityScores;
    }

    private static final long calcRefLength(CramCompressionRecord cramCompressionRecord) {
        if (cramCompressionRecord.readFeatures == null || cramCompressionRecord.readFeatures.isEmpty()) {
            return cramCompressionRecord.readLength;
        }
        long l = cramCompressionRecord.readLength;
        for (ReadFeature readFeature : cramCompressionRecord.readFeatures) {
            switch (readFeature.getOperator()) {
                case 68: {
                    l += (long)((Deletion)readFeature).getLength();
                    break;
                }
                case 73: {
                    l -= (long)((Insertion)readFeature).getSequence().length;
                    break;
                }
            }
        }
        return l;
    }

    private static final byte[] restoreReadBases(CramCompressionRecord cramCompressionRecord, byte[] byArray, SubstitutionMatrix substitutionMatrix) {
        ReadFeature readFeature;
        int n = cramCompressionRecord.readLength;
        byte[] byArray2 = new byte[n];
        int n2 = 1;
        int n3 = cramCompressionRecord.alignmentStart - 1;
        int n4 = 0;
        if (cramCompressionRecord.readFeatures == null || cramCompressionRecord.readFeatures.isEmpty()) {
            if (byArray.length < n3 + byArray2.length) {
                Arrays.fill(byArray2, (byte)78);
                System.arraycopy(byArray, n3, byArray2, 0, Math.min(byArray2.length, byArray.length - n3));
            } else {
                System.arraycopy(byArray, n3, byArray2, 0, byArray2.length);
            }
            return byArray2;
        }
        List<ReadFeature> list = cramCompressionRecord.readFeatures;
        block10: for (ReadFeature readFeature2 : list) {
            while (n2 < readFeature2.getPosition()) {
                byArray2[n2 - 1] = byArray[n3 + n4++];
                ++n2;
            }
            switch (readFeature2.getOperator()) {
                case 88: {
                    readFeature = (Substitution)readFeature2;
                    byte by = Utils.normalizeBase(byArray[n3 + n4]);
                    byte by2 = substitutionMatrix.base(by, ((Substitution)readFeature).getCode());
                    ((Substitution)readFeature).setBase(by2);
                    ((Substitution)readFeature).setRefernceBase(by);
                    byArray2[n2++ - 1] = by2;
                    ++n4;
                    break;
                }
                case 73: {
                    Insertion insertion = (Insertion)readFeature2;
                    for (int i = 0; i < insertion.getSequence().length; ++i) {
                        byArray2[n2++ - 1] = insertion.getSequence()[i];
                    }
                    continue block10;
                }
                case 83: {
                    SoftClip softClip = (SoftClip)readFeature2;
                    for (int i = 0; i < softClip.getSequence().length; ++i) {
                        byArray2[n2++ - 1] = softClip.getSequence()[i];
                    }
                    continue block10;
                }
                case 68: {
                    Deletion deletion = (Deletion)readFeature2;
                    n4 += deletion.getLength();
                    break;
                }
                case 105: {
                    InsertBase insertBase = (InsertBase)readFeature2;
                    byArray2[n2++ - 1] = insertBase.getBase();
                }
            }
        }
        while (n2 <= n) {
            byArray2[n2 - 1] = byArray[n3 + n4++];
            ++n2;
        }
        for (ReadFeature readFeature2 : list) {
            switch (readFeature2.getOperator()) {
                case 66: {
                    readFeature = (ReadBase)readFeature2;
                    byArray2[readFeature2.getPosition() - 1] = ((ReadBase)readFeature).getBase();
                    break;
                }
            }
        }
        for (int i = 0; i < byArray2.length; ++i) {
            byArray2[i] = Utils.normalizeBase(byArray2[i]);
        }
        return byArray2;
    }

    private static int computeInsertSize(CramCompressionRecord cramCompressionRecord, CramCompressionRecord cramCompressionRecord2) {
        if (cramCompressionRecord.isSegmentUnmapped() || cramCompressionRecord2.isSegmentUnmapped()) {
            return 0;
        }
        if (cramCompressionRecord.sequenceId != cramCompressionRecord2.sequenceId) {
            return 0;
        }
        int n = cramCompressionRecord.isNegativeStrand() ? cramCompressionRecord.getAlignmentEnd() : cramCompressionRecord.alignmentStart;
        int n2 = cramCompressionRecord2.isNegativeStrand() ? cramCompressionRecord2.getAlignmentEnd() : cramCompressionRecord2.alignmentStart;
        int n3 = n2 >= n ? 1 : -1;
        return n2 - n + n3;
    }
}

