/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.build;

import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMTag;
import htsjdk.samtools.cram.build.Utils;
import htsjdk.samtools.cram.encoding.read_features.BaseQualityScore;
import htsjdk.samtools.cram.encoding.read_features.Deletion;
import htsjdk.samtools.cram.encoding.read_features.HardClip;
import htsjdk.samtools.cram.encoding.read_features.InsertBase;
import htsjdk.samtools.cram.encoding.read_features.Padding;
import htsjdk.samtools.cram.encoding.read_features.ReadFeature;
import htsjdk.samtools.cram.encoding.read_features.RefSkip;
import htsjdk.samtools.cram.encoding.read_features.SoftClip;
import htsjdk.samtools.cram.encoding.read_features.Substitution;
import htsjdk.samtools.cram.mask.RefMaskUtils;
import htsjdk.samtools.cram.structure.CramCompressionRecord;
import htsjdk.samtools.cram.structure.ReadTag;
import htsjdk.samtools.util.Log;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class Sam2CramRecordFactory {
    public static final String UNKNOWN_READ_GROUP_ID = "UNKNOWN";
    public static final String UNKNOWN_READ_GROUP_SAMPLE = "UNKNOWN";
    public static final byte QS_asciiOffset = 33;
    public static final byte unsetQualityScore = 32;
    public static final byte ignorePositionsWithQualityScore = -1;
    private byte[] refBases;
    private byte[] refSNPs;
    private RefMaskUtils.RefMask refPile;
    private static Log log = Log.getInstance(Sam2CramRecordFactory.class);
    private Map<String, Integer> readGroupMap = new HashMap<String, Integer>();
    private long landedRefMaskScores = 0L;
    private long landedPiledScores = 0L;
    private long landedTotalScores = 0L;
    public boolean captureAllTags = false;
    public boolean preserveReadNames = false;
    public Set<String> captureTags = new TreeSet<String>();
    public Set<String> ignoreTags = new TreeSet<String>();
    public boolean losslessQS;
    private List<ReadTag> readTagList;
    private long baseCount;
    private long featureCount;

    public Sam2CramRecordFactory(int n, byte[] byArray, SAMFileHeader sAMFileHeader) {
        this.ignoreTags.add(SAMTag.NM.name());
        this.ignoreTags.add(SAMTag.MD.name());
        this.ignoreTags.add(SAMTag.RG.name());
        this.losslessQS = false;
        this.readTagList = new ArrayList<ReadTag>();
        this.baseCount = 0L;
        this.featureCount = 0L;
        this.refBases = byArray;
        List<SAMReadGroupRecord> list = sAMFileHeader.getReadGroups();
        for (int i = 0; i < list.size(); ++i) {
            SAMReadGroupRecord sAMReadGroupRecord = list.get(i);
            this.readGroupMap.put(sAMReadGroupRecord.getId(), i);
        }
    }

    public CramCompressionRecord createCramRecord(SAMRecord sAMRecord) {
        List<Object> list;
        CramCompressionRecord cramCompressionRecord = new CramCompressionRecord();
        if (sAMRecord.getReadPairedFlag()) {
            cramCompressionRecord.mateAlignmentStart = sAMRecord.getMateAlignmentStart();
            cramCompressionRecord.setMateUmapped(sAMRecord.getMateUnmappedFlag());
            cramCompressionRecord.setMateNegativeStrand(sAMRecord.getMateNegativeStrandFlag());
            cramCompressionRecord.mateSequenceID = sAMRecord.getMateReferenceIndex();
        } else {
            cramCompressionRecord.mateSequenceID = -1;
        }
        cramCompressionRecord.sequenceId = sAMRecord.getReferenceIndex();
        cramCompressionRecord.readName = sAMRecord.getReadName();
        cramCompressionRecord.alignmentStart = sAMRecord.getAlignmentStart();
        cramCompressionRecord.setMultiFragment(sAMRecord.getReadPairedFlag());
        cramCompressionRecord.setProperPair(sAMRecord.getReadPairedFlag() && sAMRecord.getProperPairFlag());
        cramCompressionRecord.setSegmentUnmapped(sAMRecord.getReadUnmappedFlag());
        cramCompressionRecord.setNegativeStrand(sAMRecord.getReadNegativeStrandFlag());
        cramCompressionRecord.setFirstSegment(sAMRecord.getReadPairedFlag() && sAMRecord.getFirstOfPairFlag());
        cramCompressionRecord.setLastSegment(sAMRecord.getReadPairedFlag() && sAMRecord.getSecondOfPairFlag());
        cramCompressionRecord.setSecondaryAlignment(sAMRecord.getNotPrimaryAlignmentFlag());
        cramCompressionRecord.setVendorFiltered(sAMRecord.getReadFailsVendorQualityCheckFlag());
        cramCompressionRecord.setDuplicate(sAMRecord.getDuplicateReadFlag());
        cramCompressionRecord.readLength = sAMRecord.getReadLength();
        cramCompressionRecord.mappingQuality = sAMRecord.getMappingQuality();
        cramCompressionRecord.setDuplicate(sAMRecord.getDuplicateReadFlag());
        cramCompressionRecord.templateSize = sAMRecord.getInferredInsertSize();
        SAMReadGroupRecord sAMReadGroupRecord = sAMRecord.getReadGroup();
        cramCompressionRecord.readGroupID = sAMReadGroupRecord != null ? this.readGroupMap.get(sAMReadGroupRecord.getId()) : -1;
        if (!sAMRecord.getReadPairedFlag()) {
            cramCompressionRecord.setLastSegment(false);
        } else if (sAMRecord.getFirstOfPairFlag()) {
            cramCompressionRecord.setLastSegment(false);
        } else if (sAMRecord.getSecondOfPairFlag()) {
            cramCompressionRecord.setLastSegment(true);
        } else {
            cramCompressionRecord.setLastSegment(true);
        }
        if (!sAMRecord.getReadUnmappedFlag() && sAMRecord.getAlignmentStart() != 0) {
            list = this.checkedCreateVariations(cramCompressionRecord, sAMRecord);
            cramCompressionRecord.readFeatures = list;
        } else {
            cramCompressionRecord.readFeatures = Collections.emptyList();
        }
        cramCompressionRecord.readBases = sAMRecord.getReadBases();
        cramCompressionRecord.qualityScores = sAMRecord.getBaseQualities();
        this.landedTotalScores += (long)cramCompressionRecord.readLength;
        this.readTagList.clear();
        if (this.captureAllTags) {
            list = sAMRecord.getAttributes();
            for (SAMRecord.SAMTagAndValue sAMTagAndValue : list) {
                if (this.ignoreTags.contains(sAMTagAndValue.tag)) continue;
                this.readTagList.add(ReadTag.deriveTypeFromValue(sAMTagAndValue.tag, sAMTagAndValue.value));
            }
        } else if (!this.captureTags.isEmpty()) {
            list = sAMRecord.getAttributes();
            cramCompressionRecord.tags = new ReadTag[list.size()];
            for (SAMRecord.SAMTagAndValue sAMTagAndValue : list) {
                if (!this.captureTags.contains(sAMTagAndValue.tag)) continue;
                this.readTagList.add(ReadTag.deriveTypeFromValue(sAMTagAndValue.tag, sAMTagAndValue.value));
            }
        }
        cramCompressionRecord.tags = this.readTagList.toArray(new ReadTag[this.readTagList.size()]);
        cramCompressionRecord.setVendorFiltered(sAMRecord.getReadFailsVendorQualityCheckFlag());
        if (this.preserveReadNames) {
            cramCompressionRecord.readName = sAMRecord.getReadName();
        }
        return cramCompressionRecord;
    }

    private List<ReadFeature> checkedCreateVariations(CramCompressionRecord cramCompressionRecord, SAMRecord sAMRecord) {
        try {
            return this.createVariations(cramCompressionRecord, sAMRecord);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            log.error("Reference bases array length=" + this.refBases.length);
            log.error("Offensive CRAM record: " + cramCompressionRecord.toString());
            log.error("Offensive SAM record: " + sAMRecord.getSAMString());
            throw arrayIndexOutOfBoundsException;
        }
    }

    private List<ReadFeature> createVariations(CramCompressionRecord cramCompressionRecord, SAMRecord sAMRecord) {
        LinkedList<ReadFeature> linkedList = new LinkedList<ReadFeature>();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        List<CigarElement> list = sAMRecord.getCigar().getCigarElements();
        byte[] byArray = sAMRecord.getReadBases();
        byte[] byArray2 = sAMRecord.getBaseQualities();
        for (CigarElement cigarElement : list) {
            n3 = cigarElement.getLength();
            CigarOperator cigarOperator = cigarElement.getOperator();
            switch (cigarOperator) {
                case D: {
                    linkedList.add(new Deletion(n + 1, n3));
                    break;
                }
                case N: {
                    linkedList.add(new RefSkip(n + 1, n3));
                    break;
                }
                case P: {
                    linkedList.add(new Padding(n + 1, n3));
                    break;
                }
                case H: {
                    linkedList.add(new HardClip(n + 1, n3));
                    break;
                }
                case S: {
                    this.addSoftClip(linkedList, n, n3, byArray, byArray2);
                    break;
                }
                case I: {
                    this.addInsertion(linkedList, n, n3, byArray, byArray2);
                    break;
                }
                case M: 
                case X: 
                case EQ: {
                    this.addSubstitutionsAndMaskedBases(cramCompressionRecord, linkedList, n, n2, n3, byArray, byArray2);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported cigar operator: " + (Object)((Object)cigarElement.getOperator()));
                }
            }
            if (cigarElement.getOperator().consumesReadBases()) {
                n += n3;
            }
            if (!cigarElement.getOperator().consumesReferenceBases()) continue;
            n2 += n3;
        }
        this.baseCount += (long)byArray.length;
        this.featureCount += (long)linkedList.size();
        return linkedList;
    }

    private void addSoftClip(List<ReadFeature> list, int n, int n2, byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = Arrays.copyOfRange(byArray, n, n + n2);
        SoftClip softClip = new SoftClip(n + 1, byArray3);
        list.add(softClip);
    }

    private void addInsertion(List<ReadFeature> list, int n, int n2, byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = Arrays.copyOfRange(byArray, n, n + n2);
        for (int i = 0; i < byArray3.length; ++i) {
            InsertBase insertBase = new InsertBase();
            insertBase.setPosition(n + 1 + i);
            insertBase.setBase(byArray3[i]);
            list.add(insertBase);
        }
    }

    private void addSubstitutionsAndMaskedBases(CramCompressionRecord cramCompressionRecord, List<ReadFeature> list, int n, int n2, int n3, byte[] byArray, byte[] byArray2) {
        boolean bl = byArray2.length == 0;
        int n4 = 0;
        boolean bl2 = false;
        for (n4 = 0; n4 < n3; ++n4) {
            byte by;
            int n5 = n4 + n + 1;
            int n6 = cramCompressionRecord.alignmentStart + n4 + n2 - 1;
            bl2 = false;
            byte by2 = n6 >= this.refBases.length ? (byte)78 : this.refBases[n6];
            if (byArray[n4 + n] != (by2 = Utils.normalizeBase(by2))) {
                Substitution substitution = new Substitution();
                substitution.setPosition(n5);
                substitution.setBase(byArray[n4 + n]);
                substitution.setRefernceBase(by2);
                substitution.setBaseChange(null);
                list.add(substitution);
                if (this.losslessQS || bl) continue;
            }
            if (bl) continue;
            if (!bl2 && this.refSNPs != null && (by = this.refSNPs[n6]) != 0) {
                byte by3 = (byte)(33 + byArray2[n4 + n]);
                list.add(new BaseQualityScore(n5, by3));
                bl2 = true;
                ++this.landedRefMaskScores;
            }
            if (!bl2 && this.refPile != null && this.refPile.shouldStore(n6, by2)) {
                byte by4 = (byte)(33 + byArray2[n4 + n]);
                list.add(new BaseQualityScore(n5, by4));
                bl2 = true;
                ++this.landedPiledScores;
            }
            if (!bl2) continue;
            ++this.landedTotalScores;
        }
    }

    public long getLandedRefMaskScores() {
        return this.landedRefMaskScores;
    }

    public long getLandedPiledScores() {
        return this.landedPiledScores;
    }

    public long getLandedTotalScores() {
        return this.landedTotalScores;
    }

    public byte[] getRefBases() {
        return this.refBases;
    }

    public void setRefBases(byte[] byArray) {
        this.refBases = byArray;
    }

    public byte[] getRefSNPs() {
        return this.refSNPs;
    }

    public void setRefSNPs(byte[] byArray) {
        this.refSNPs = byArray;
    }

    public RefMaskUtils.RefMask getRefPile() {
        return this.refPile;
    }

    public Map<String, Integer> getReadGroupMap() {
        return this.readGroupMap;
    }

    public void setRefPile(RefMaskUtils.RefMask refMask) {
        this.refPile = refMask;
    }

    public long getBaseCount() {
        return this.baseCount;
    }

    public long getFeatureCount() {
        return this.featureCount;
    }
}

