/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding;

import htsjdk.samtools.cram.common.NullOutputStream;
import htsjdk.samtools.cram.encoding.AbstractBitCodec;
import htsjdk.samtools.cram.io.BitInputStream;
import htsjdk.samtools.cram.io.BitOutputStream;
import htsjdk.samtools.cram.io.DefaultBitOutputStream;
import htsjdk.samtools.util.Log;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;

public class ArithCodec
extends AbstractBitCodec<byte[]> {
    private byte curBit = 0;
    private int curByte = 0;
    private double min = 0.0;
    private double max = 1.0;
    private double localMin = 0.0;
    private double localMax = 1.0;
    private final int TERMINATOR = 256;
    private double[] probs;
    private int[] map = new int[257];
    private int[] rev_map;
    private long bitCount;
    private ByteArrayOutputStream baos;
    private ArrayList<Integer> fileData;

    public ArithCodec(int[] nArray, int[] nArray2) {
        int n;
        int n2;
        Arrays.fill(this.map, -1);
        for (n2 = 0; n2 < nArray2.length; ++n2) {
            this.map[nArray2[n2]] = n2;
        }
        this.map[this.TERMINATOR] = nArray2.length;
        this.rev_map = new int[nArray2.length + 1];
        System.arraycopy(nArray2, 0, this.rev_map, 0, nArray2.length);
        this.rev_map[nArray2.length] = this.TERMINATOR;
        this.probs = new double[nArray.length + 1];
        n2 = 0;
        int n3 = 0;
        for (n = 0; n < nArray.length; ++n) {
            n2 += nArray[n];
        }
        n3 = n2 / 100 > 0 ? n2 / 100 : n2 / 10;
        n2 += n3;
        n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            this.probs[i] = (double)(n += nArray[i]) / (double)n2;
        }
        this.probs[this.probs.length - 1] = 1.0;
        this.baos = new ByteArrayOutputStream(430000000);
        this.fileData = new ArrayList();
    }

    @Override
    public byte[] read(BitInputStream bitInputStream) throws IOException {
        this.baos.reset();
        this.fileData.clear();
        this.curBit = 0;
        this.curByte = 0;
        this.min = 0.0;
        this.max = 1.0;
        this.localMin = 0.0;
        this.localMax = 1.0;
        int n = this.decodeCharacter(bitInputStream);
        while (n != this.map[this.TERMINATOR]) {
            this.baos.write(this.rev_map[n]);
            n = this.decodeCharacter(bitInputStream);
        }
        return this.baos.toByteArray();
    }

    public int decodeCharacter(BitInputStream bitInputStream) throws IOException {
        int n;
        double d;
        double d2 = this.min;
        double d3 = this.max;
        byte by = this.curBit;
        int n2 = this.curByte;
        int n3 = 0;
        if (this.fileData.isEmpty()) {
            this.fileData.add(bitInputStream.readBits(8));
        }
        while (true) {
            d = (this.min + this.max) / 2.0;
            n3 = -1;
            for (n = 0; n < this.probs.length; ++n) {
                if (!(this.probs[n] > this.min)) continue;
                if (!(this.probs[n] > this.max)) break;
                n3 = n;
                break;
            }
            if (n3 != -1) break;
            n = 0;
            if ((this.fileData.get(this.curByte) & 128 >> this.curBit) != 0) {
                n = 1;
            }
            if (n != 0) {
                this.min = d;
            } else {
                this.max = d;
            }
            this.curBit = (byte)(this.curBit + 1);
            if (this.curBit != 8) continue;
            this.curBit = 0;
            ++this.curByte;
            if (this.curByte <= this.fileData.size() - 1) continue;
            try {
                this.fileData.add(bitInputStream.readBits(8));
            }
            catch (Throwable throwable) {
                this.fileData.add(0);
            }
        }
        this.min = d2;
        this.max = d3;
        this.curBit = by;
        this.curByte = n2;
        while (true) {
            d = (this.min + this.max) / 2.0;
            for (n = 0; n < this.probs.length && !(this.probs[n] > d); ++n) {
            }
            if (d < 0.0 || d > 1.0) {
                n = -1;
            }
            if (n == n3) break;
            boolean bl = false;
            if ((this.fileData.get(this.curByte) & 128 >> this.curBit) != 0) {
                bl = true;
            }
            if (bl) {
                this.min = d;
            } else {
                this.max = d;
            }
            this.curBit = (byte)(this.curBit + 1);
            if (this.curBit != 8) continue;
            this.curBit = 0;
            ++this.curByte;
            if (this.curByte <= this.fileData.size() - 1) continue;
            try {
                this.fileData.add(bitInputStream.readBits(8));
            }
            catch (Throwable throwable) {
                this.fileData.add(0);
            }
        }
        d2 = 0.0;
        if (n3 > 0) {
            d2 = this.probs[n3 - 1];
        }
        double d4 = 1.0 / (this.probs[n3] - d2);
        this.min = d4 * (this.min - d2);
        this.max = d4 * (this.max - d2);
        return n3;
    }

    @Override
    public long write(BitOutputStream bitOutputStream, byte[] byArray) throws IOException {
        this.baos.reset();
        this.curBit = 0;
        this.curByte = 0;
        this.min = 0.0;
        this.max = 1.0;
        this.localMin = 0.0;
        this.localMax = 1.0;
        this.bitCount = 0L;
        try {
            for (int i = 0; i < byArray.length; ++i) {
                this.encodeCharacter(bitOutputStream, this.map[byArray[i] & 0xFF]);
            }
            this.encodeCharacter(bitOutputStream, this.map[this.TERMINATOR]);
            this.encodeCharacter(bitOutputStream, this.map[this.TERMINATOR]);
            this.flush(bitOutputStream);
        }
        catch (Exception exception) {
            Log.getInstance(this.getClass()).error(exception, new Object[0]);
        }
        return this.bitCount;
    }

    private void encodeCharacter(BitOutputStream bitOutputStream, int n) throws Exception {
        if (this.probs.length < 2 || this.probs[this.probs.length - 1] != 1.0 || n < 0 || n >= this.probs.length) {
            throw new Exception("Invalid input");
        }
        this.localMin = n > 0 ? this.probs[n - 1] : 0.0;
        this.localMax = this.probs[n];
        while (true) {
            double d;
            if ((d = (this.min + this.max) / 2.0) < this.localMin) {
                this.curByte |= 128 >> this.curBit;
                this.curBit = (byte)(this.curBit + 1);
                if (this.curBit == 8) {
                    bitOutputStream.write(this.curByte, 8);
                    this.curByte = 0;
                    this.curBit = 0;
                    this.bitCount += 8L;
                }
                this.min = d;
                continue;
            }
            if (!(d >= this.localMax)) break;
            this.curBit = (byte)(this.curBit + 1);
            if (this.curBit == 8) {
                bitOutputStream.write(this.curByte, 8);
                this.curByte = 0;
                this.curBit = 0;
                this.bitCount += 8L;
            }
            this.max = d;
        }
        double d = 1.0 / (this.localMax - this.localMin);
        this.min = d * (this.min - this.localMin);
        this.max = d * (this.max - this.localMin);
    }

    private void flush(BitOutputStream bitOutputStream) throws IOException {
        if (this.curBit != 0) {
            while (true) {
                double d;
                double d2;
                if ((d2 = (this.min + this.max) / 2.0) < (d = (this.localMin + this.localMax) / 2.0)) {
                    this.curByte |= 128 >> this.curBit;
                    this.min = d2;
                } else {
                    this.max = d2;
                }
                this.curBit = (byte)(this.curBit + 1);
                if (this.curBit != 8) continue;
                bitOutputStream.write(this.curByte, 8);
                this.curByte = 0;
                this.curBit = 0;
                this.bitCount += 8L;
                d2 = (this.min + this.max) / 2.0;
                if (d2 >= this.localMin && d2 < this.localMax) break;
            }
        }
        bitOutputStream.close();
    }

    @Override
    public long numberOfBits(byte[] byArray) {
        NullOutputStream nullOutputStream = new NullOutputStream();
        DefaultBitOutputStream defaultBitOutputStream = new DefaultBitOutputStream(nullOutputStream);
        this.baos.reset();
        this.curBit = 0;
        this.curByte = 0;
        this.min = 0.0;
        this.max = 1.0;
        this.localMin = 0.0;
        this.localMax = 1.0;
        this.bitCount = 0L;
        try {
            for (int i = 0; i < byArray.length; ++i) {
                this.encodeCharacter(defaultBitOutputStream, this.map[byArray[i] & 0xFF]);
            }
            this.encodeCharacter(defaultBitOutputStream, this.map[this.TERMINATOR]);
            this.encodeCharacter(defaultBitOutputStream, this.map[this.TERMINATOR]);
            this.flush(defaultBitOutputStream);
        }
        catch (Exception exception) {
            Log.getInstance(ArithCodec.class).error(exception, new Object[0]);
        }
        return this.bitCount;
    }

    @Override
    public byte[] read(BitInputStream bitInputStream, int n) throws IOException {
        throw new RuntimeException("Not implemented.");
    }
}

