/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding;

import htsjdk.samtools.cram.encoding.AbstractBitCodec;
import htsjdk.samtools.cram.io.BitInputStream;
import htsjdk.samtools.cram.io.BitOutputStream;
import htsjdk.samtools.cram.io.DefaultBitOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;

public class ArithCodec1
extends AbstractBitCodec<byte[]> {
    private byte curBit = 0;
    private int curByte = 0;
    private double min = 0.0;
    private double max = 1.0;
    private double localMin = 0.0;
    private double localMax = 1.0;
    private long bitCount;
    private ByteArrayOutputStream baos;
    private ArrayList<Integer> fileData;
    private int previous;
    private double[][] freq;

    public ArithCodec1(int[] nArray, byte[][] byArray) {
        int n;
        long[] lArray = new long[257];
        this.freq = new double[257][256];
        for (n = 0; n < 256; ++n) {
            this.freq[256][n] = 1.0;
            lArray[256] = lArray[256] + 1L;
        }
        for (n = 0; n < nArray.length; ++n) {
            int n2 = byArray[n].length > 1 ? byArray[n][0] : 256;
            byte by = byArray[n].length > 1 ? byArray[n][1] : byArray[n][0];
            this.freq[n2][by] = nArray[n];
            int n3 = n2;
            lArray[n3] = lArray[n3] + (long)nArray[n];
        }
        for (n = 0; n < this.freq.length; ++n) {
            double d = 0.0;
            for (int i = 0; i < this.freq[n].length; ++i) {
                if (lArray[n] <= 0L) continue;
                this.freq[n][i] = d += this.freq[n][i] / (double)lArray[n];
            }
            if (this.freq[n][this.freq[n].length - 1] == 1.0) continue;
            this.freq[n][this.freq[n].length - 1] = 1.0;
        }
        this.baos = new ByteArrayOutputStream();
        this.fileData = new ArrayList();
        this.previous = 256;
    }

    private Byte readByte(BitInputStream bitInputStream) throws IOException {
        this.baos.reset();
        this.fileData.clear();
        this.curBit = 0;
        this.curByte = 0;
        this.min = 0.0;
        this.max = 1.0;
        this.localMin = 0.0;
        this.localMax = 1.0;
        this.previous = 256;
        int n = this.decodeCharacter(bitInputStream);
        this.baos.write(n);
        this.previous = n;
        return (byte)n;
    }

    @Override
    public byte[] read(BitInputStream bitInputStream, int n) throws IOException {
        int n2;
        int n3;
        this.baos.reset();
        this.fileData.clear();
        this.curBit = 0;
        this.curByte = 0;
        this.min = 0.0;
        this.max = 1.0;
        this.localMin = 0.0;
        this.localMax = 1.0;
        this.previous = 256;
        for (n3 = 0; n3 < n; ++n3) {
            n2 = this.decodeCharacter(bitInputStream);
            this.baos.write(n2);
            this.previous = n2;
        }
        System.out.println(this.fileData.size());
        System.out.println(this.curByte);
        System.out.println(this.curBit);
        n3 = 8 - this.curBit;
        System.out.println(n3);
        n2 = this.fileData.get(this.fileData.size() - 1);
        bitInputStream.putBack(this.curBit, n2 >> this.curBit & (1 << n3) - 1);
        return this.baos.toByteArray();
    }

    public int decodeCharacter(BitInputStream bitInputStream) throws IOException {
        int n;
        double d;
        double d2 = this.min;
        double d3 = this.max;
        byte by = this.curBit;
        int n2 = this.curByte;
        int n3 = 256;
        if (this.fileData.isEmpty()) {
            this.fileData.add(bitInputStream.readBits(8));
        }
        double[] dArray = this.freq[this.previous];
        while (true) {
            d = (this.min + this.max) / 2.0;
            n3 = -1;
            for (n = 0; n < dArray.length; ++n) {
                if (!(dArray[n] > this.min)) continue;
                if (!(dArray[n] > this.max)) break;
                n3 = n;
                break;
            }
            if (n3 != -1) break;
            n = 0;
            if ((this.fileData.get(this.curByte) & 128 >> this.curBit) != 0) {
                n = 1;
            }
            if (n != 0) {
                this.min = d;
            } else {
                this.max = d;
            }
            this.curBit = (byte)(this.curBit + 1);
            if (this.curBit != 8) continue;
            this.curBit = 0;
            ++this.curByte;
            if (this.curByte <= this.fileData.size() - 1) continue;
            try {
                this.fileData.add(bitInputStream.readBits(8));
            }
            catch (Throwable throwable) {
                this.fileData.add(0);
            }
        }
        this.min = d2;
        this.max = d3;
        this.curBit = by;
        this.curByte = n2;
        while (true) {
            d = (this.min + this.max) / 2.0;
            for (n = 0; n < dArray.length && !(dArray[n] > d); ++n) {
            }
            if (d < 0.0 || d > 1.0) {
                n = -1;
            }
            if (n == n3) break;
            boolean bl = false;
            if ((this.fileData.get(this.curByte) & 128 >> this.curBit) != 0) {
                bl = true;
            }
            if (bl) {
                this.min = d;
            } else {
                this.max = d;
            }
            this.curBit = (byte)(this.curBit + 1);
            if (this.curBit != 8) continue;
            this.curBit = 0;
            ++this.curByte;
            if (this.curByte <= this.fileData.size() - 1) continue;
            try {
                this.fileData.add(bitInputStream.readBits(8));
            }
            catch (Throwable throwable) {
                this.fileData.add(0);
            }
        }
        d2 = 0.0;
        if (n3 > 0) {
            d2 = dArray[n3 - 1];
        }
        double d4 = 1.0 / (dArray[n3] - d2);
        this.min = d4 * (this.min - d2);
        this.max = d4 * (this.max - d2);
        return n3;
    }

    @Override
    public long write(BitOutputStream bitOutputStream, byte[] byArray) throws IOException {
        this.baos.reset();
        this.curBit = 0;
        this.curByte = 0;
        this.min = 0.0;
        this.max = 1.0;
        this.localMin = 0.0;
        this.localMax = 1.0;
        this.bitCount = 0L;
        this.previous = 256;
        try {
            for (int i = 0; i < byArray.length; ++i) {
                this.encodeCharacter(bitOutputStream, byArray[i] & 0xFF);
                this.previous = byArray[i] & 0xFF;
            }
            this.flush(bitOutputStream);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        return this.bitCount;
    }

    private void encodeCharacter(BitOutputStream bitOutputStream, int n) throws Exception {
        double[] dArray = this.freq[this.previous];
        if (dArray.length < 2 || dArray[dArray.length - 1] != 1.0 || n < 0 || n >= dArray.length) {
            throw new Exception("Invalid input");
        }
        this.localMin = n > 0 ? dArray[n - 1] : 0.0;
        this.localMax = dArray[n];
        while (true) {
            double d;
            if ((d = (this.min + this.max) / 2.0) < this.localMin) {
                this.curByte |= 128 >> this.curBit;
                this.curBit = (byte)(this.curBit + 1);
                if (this.curBit == 8) {
                    bitOutputStream.write(this.curByte, 8);
                    this.curByte = 0;
                    this.curBit = 0;
                    this.bitCount += 8L;
                }
                this.min = d;
                continue;
            }
            if (!(d >= this.localMax)) break;
            this.curBit = (byte)(this.curBit + 1);
            if (this.curBit == 8) {
                bitOutputStream.write(this.curByte, 8);
                this.curByte = 0;
                this.curBit = 0;
                this.bitCount += 8L;
            }
            this.max = d;
        }
        double d = 1.0 / (this.localMax - this.localMin);
        this.min = d * (this.min - this.localMin);
        this.max = d * (this.max - this.localMin);
    }

    private void flush(BitOutputStream bitOutputStream) throws IOException {
        if (this.curBit != 0) {
            while (true) {
                double d;
                double d2;
                if ((d2 = (this.min + this.max) / 2.0) < (d = (this.localMin + this.localMax) / 2.0)) {
                    this.curByte |= 128 >> this.curBit;
                    this.min = d2;
                } else {
                    this.max = d2;
                }
                this.curBit = (byte)(this.curBit + 1);
                if (this.curBit != 8) continue;
                bitOutputStream.write(this.curByte, 8);
                this.curByte = 0;
                this.curBit = 0;
                this.bitCount += 8L;
                d2 = (this.min + this.max) / 2.0;
                if (d2 >= this.localMin && d2 < this.localMax) break;
            }
        }
        bitOutputStream.close();
    }

    @Override
    public long numberOfBits(byte[] byArray) {
        NullOutputStream nullOutputStream = new NullOutputStream();
        DefaultBitOutputStream defaultBitOutputStream = new DefaultBitOutputStream(nullOutputStream);
        this.baos.reset();
        this.curBit = 0;
        this.curByte = 0;
        this.min = 0.0;
        this.max = 1.0;
        this.localMin = 0.0;
        this.localMax = 1.0;
        this.bitCount = 0L;
        this.previous = 256;
        try {
            for (int i = 0; i < byArray.length; ++i) {
                this.encodeCharacter(defaultBitOutputStream, byArray[i] & 0xFF);
                this.previous = byArray[i];
            }
            this.flush(defaultBitOutputStream);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.bitCount;
    }

    @Override
    public byte[] read(BitInputStream bitInputStream) throws IOException {
        return null;
    }

    private class NullOutputStream
    extends OutputStream {
        private NullOutputStream() {
        }

        @Override
        public void write(int n) throws IOException {
        }
    }
}

