/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding;

import htsjdk.samtools.cram.encoding.AbstractBitCodec;
import htsjdk.samtools.cram.encoding.BitCodec;
import htsjdk.samtools.cram.encoding.DataSeriesType;
import htsjdk.samtools.cram.encoding.Encoding;
import htsjdk.samtools.cram.encoding.EncodingFactory;
import htsjdk.samtools.cram.io.BitInputStream;
import htsjdk.samtools.cram.io.BitOutputStream;
import htsjdk.samtools.cram.io.ByteBufferUtils;
import htsjdk.samtools.cram.io.ExposedByteArrayOutputStream;
import htsjdk.samtools.cram.structure.EncodingID;
import htsjdk.samtools.cram.structure.EncodingParams;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Map;

public class ByteArrayLenEncoding
implements Encoding<byte[]> {
    public static final EncodingID ID = EncodingID.BYTE_ARRAY_LEN;
    Encoding<Integer> lenEncoding;
    Encoding<byte[]> byteEncoding;

    @Override
    public EncodingID id() {
        return ID;
    }

    public static EncodingParams toParam(EncodingParams encodingParams, EncodingParams encodingParams2) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write((byte)encodingParams.id.ordinal());
            ByteBufferUtils.writeUnsignedITF8(encodingParams.params.length, byteArrayOutputStream);
            byteArrayOutputStream.write(encodingParams.params);
            byteArrayOutputStream.write((byte)encodingParams2.id.ordinal());
            ByteBufferUtils.writeUnsignedITF8(encodingParams2.params.length, byteArrayOutputStream);
            byteArrayOutputStream.write(encodingParams2.params);
        }
        catch (IOException iOException) {
            throw new RuntimeException("It never happened. ");
        }
        return new EncodingParams(ID, byteArrayOutputStream.toByteArray());
    }

    @Override
    public byte[] toByteArray() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write((byte)this.lenEncoding.id().ordinal());
            byte[] byArray = this.lenEncoding.toByteArray();
            ByteBufferUtils.writeUnsignedITF8(byArray.length, byteArrayOutputStream);
            byteArrayOutputStream.write(byArray);
            byteArrayOutputStream.write((byte)this.byteEncoding.id().ordinal());
            byte[] byArray2 = this.byteEncoding.toByteArray();
            ByteBufferUtils.writeUnsignedITF8(byArray2.length, byteArrayOutputStream);
            byteArrayOutputStream.write(byArray2);
        }
        catch (IOException iOException) {
            throw new RuntimeException("It never happened. ");
        }
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public void fromByteArray(byte[] byArray) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        EncodingFactory encodingFactory = new EncodingFactory();
        EncodingID encodingID = EncodingID.values()[byteBuffer.get()];
        this.lenEncoding = encodingFactory.createEncoding(DataSeriesType.INT, encodingID);
        int n = ByteBufferUtils.readUnsignedITF8(byteBuffer);
        byte[] byArray2 = new byte[n];
        byteBuffer.get(byArray2);
        this.lenEncoding.fromByteArray(byArray2);
        EncodingID encodingID2 = EncodingID.values()[byteBuffer.get()];
        this.byteEncoding = encodingFactory.createEncoding(DataSeriesType.BYTE_ARRAY, encodingID2);
        n = ByteBufferUtils.readUnsignedITF8(byteBuffer);
        byArray2 = new byte[n];
        byteBuffer.get(byArray2);
        this.byteEncoding.fromByteArray(byArray2);
    }

    @Override
    public BitCodec<byte[]> buildCodec(Map<Integer, InputStream> map, Map<Integer, ExposedByteArrayOutputStream> map2) {
        return new ByteArrayLenCodec(this.lenEncoding.buildCodec(map, map2), this.byteEncoding.buildCodec(map, map2));
    }

    private static class ByteArrayLenCodec
    extends AbstractBitCodec<byte[]> {
        private BitCodec<Integer> lenCodec;
        private BitCodec<byte[]> byteCodec;

        public ByteArrayLenCodec(BitCodec<Integer> bitCodec, BitCodec<byte[]> bitCodec2) {
            this.lenCodec = bitCodec;
            this.byteCodec = bitCodec2;
        }

        @Override
        public byte[] read(BitInputStream bitInputStream) throws IOException {
            int n = this.lenCodec.read(bitInputStream);
            return this.byteCodec.read(bitInputStream, n);
        }

        @Override
        public byte[] read(BitInputStream bitInputStream, int n) throws IOException {
            throw new RuntimeException("Not implemented.");
        }

        @Override
        public long write(BitOutputStream bitOutputStream, byte[] byArray) throws IOException {
            long l = this.lenCodec.write(bitOutputStream, byArray.length);
            return l += this.byteCodec.write(bitOutputStream, byArray);
        }

        @Override
        public long numberOfBits(byte[] byArray) {
            return this.lenCodec.numberOfBits(byArray.length) + this.byteCodec.numberOfBits(byArray);
        }
    }
}

