/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding;

import htsjdk.samtools.cram.encoding.AbstractBitCodec;
import htsjdk.samtools.cram.io.BitInputStream;
import htsjdk.samtools.cram.io.BitOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class CanonicalHuffmanIntegerCodec
extends AbstractBitCodec<Integer> {
    private TreeMap<Integer, HuffmanBitCode> codes;
    private Integer[] codeLentghSorted;
    private Map<Integer, Map<Long, Integer>> codeCache = new HashMap<Integer, Map<Long, Integer>>();
    private Map<Long, Integer>[] codeMaps;

    public CanonicalHuffmanIntegerCodec(int[] nArray, int[] nArray2) {
        int n;
        int n2;
        TreeMap treeMap = new TreeMap();
        for (n2 = 0; n2 < nArray.length; ++n2) {
            if (treeMap.containsKey(nArray2[n2])) {
                ((TreeSet)treeMap.get(nArray2[n2])).add(nArray[n2]);
                continue;
            }
            TreeSet<Integer> treeSet = new TreeSet<Integer>();
            treeSet.add(nArray[n2]);
            treeMap.put(nArray2[n2], treeSet);
        }
        this.codeLentghSorted = new Integer[treeMap.size()];
        n2 = 0;
        int n3 = 0;
        int n4 = -1;
        this.codes = new TreeMap();
        Set set = treeMap.keySet();
        for (Object k : set) {
            n = Integer.parseInt(k.toString());
            this.codeLentghSorted[n2++] = n;
            TreeSet treeSet = (TreeSet)treeMap.get(k);
            for (Integer n5 : treeSet) {
                HuffmanBitCode huffmanBitCode = new HuffmanBitCode();
                huffmanBitCode.bitLentgh = n;
                huffmanBitCode.value = n5;
                ++n4;
                int n6 = n - n3;
                huffmanBitCode.bitCode = n4 <<= n6;
                n3 += n6;
                if (this.NumberOfSetBits(n4) > n) {
                    throw new IllegalArgumentException("Symbol out of range");
                }
                this.codes.put(n5, huffmanBitCode);
                Map<Long, Integer> map = this.codeCache.get(huffmanBitCode.bitLentgh);
                if (map == null) {
                    map = new HashMap<Long, Integer>();
                    this.codeCache.put(huffmanBitCode.bitLentgh, map);
                }
                map.put(new Long(huffmanBitCode.bitCode), huffmanBitCode.value);
            }
        }
        this.codeMaps = this.codeLentghSorted.length > 0 ? new Map[this.codeLentghSorted[this.codeLentghSorted.length - 1] + 1] : new Map[1];
        Integer[] integerArray = this.codeLentghSorted;
        int n7 = integerArray.length;
        for (n = 0; n < n7; ++n) {
            int n8 = integerArray[n];
            this.codeMaps[n8] = this.codeCache.get(n8);
        }
    }

    @Override
    public Integer read(BitInputStream bitInputStream) throws IOException {
        long l = 0L;
        int n = 0;
        Integer[] integerArray = this.codeLentghSorted;
        int n2 = integerArray.length;
        for (int i = 0; i < n2; ++i) {
            int n3 = integerArray[i];
            l <<= n3 - n;
            long l2 = bitInputStream.readLongBits(n3 - n);
            n = n3;
            Map<Long, Integer> map = this.codeMaps[n3];
            Integer n4 = map.get(l |= l2);
            if (n4 == null) continue;
            return n4;
        }
        throw new RuntimeException("Bit code not found. Current state: " + n + " bits read, buf=" + l);
    }

    @Override
    public long write(BitOutputStream bitOutputStream, Integer n) throws IOException {
        HuffmanBitCode huffmanBitCode = this.codes.get(n);
        if (huffmanBitCode == null) {
            throw new RuntimeException("Huffman code not found for value: " + n);
        }
        bitOutputStream.write(huffmanBitCode.bitCode, huffmanBitCode.bitLentgh);
        return huffmanBitCode.bitLentgh;
    }

    @Override
    public long numberOfBits(Integer n) {
        try {
            HuffmanBitCode huffmanBitCode = this.codes.get(n);
            return huffmanBitCode.bitLentgh;
        }
        catch (NullPointerException nullPointerException) {
            throw new RuntimeException("Value " + n + " not found.", nullPointerException);
        }
    }

    private int NumberOfSetBits(int n) {
        n -= n >> 1 & 0x55555555;
        n = (n & 0x33333333) + (n >> 2 & 0x33333333);
        return (n + (n >> 4) & 0xF0F0F0F) * 0x1010101 >> 24;
    }

    @Override
    public Integer read(BitInputStream bitInputStream, int n) throws IOException {
        throw new RuntimeException("Not implemented");
    }

    private static class HuffmanBitCode {
        int bitCode;
        int bitLentgh;
        int value;

        private HuffmanBitCode() {
        }
    }
}

