/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding;

import htsjdk.samtools.cram.encoding.AbstractBitCodec;
import htsjdk.samtools.cram.io.BitInputStream;
import htsjdk.samtools.cram.io.BitOutputStream;
import htsjdk.samtools.cram.io.BitwiseUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ExternalByteArrayCodec
extends AbstractBitCodec<byte[]> {
    private OutputStream os;
    private InputStream is;

    public ExternalByteArrayCodec(OutputStream outputStream, InputStream inputStream) {
        this.os = outputStream;
        this.is = inputStream;
    }

    @Override
    public byte[] read(BitInputStream bitInputStream, int n) throws IOException {
        return BitwiseUtils.readFully(this.is, n);
    }

    @Override
    public void readInto(BitInputStream bitInputStream, byte[] byArray, int n, int n2) throws IOException {
        BitwiseUtils.readFully(this.is, byArray, n, n2);
    }

    @Override
    public void skip(BitInputStream bitInputStream) throws IOException {
        this.is.skip(1L);
    }

    @Override
    public void skip(BitInputStream bitInputStream, int n) throws IOException {
        this.is.skip(n);
    }

    @Override
    public long write(BitOutputStream bitOutputStream, byte[] byArray) throws IOException {
        this.os.write(byArray);
        return this.numberOfBits(byArray);
    }

    @Override
    public long numberOfBits(byte[] byArray) {
        return byArray.length * 8;
    }

    @Override
    public byte[] read(BitInputStream bitInputStream) throws IOException {
        throw new RuntimeException("Cannot read byte array of unknown length.");
    }
}

