/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding;

import htsjdk.samtools.cram.encoding.BitCodec;
import htsjdk.samtools.cram.encoding.Encoding;
import htsjdk.samtools.cram.encoding.ExternalByteArrayCodec;
import htsjdk.samtools.cram.io.ByteBufferUtils;
import htsjdk.samtools.cram.io.ExposedByteArrayOutputStream;
import htsjdk.samtools.cram.structure.EncodingID;
import htsjdk.samtools.cram.structure.EncodingParams;
import java.io.InputStream;
import java.util.Map;

public class ExternalByteArrayEncoding
implements Encoding<byte[]> {
    public static final EncodingID encodingId = EncodingID.EXTERNAL;
    public int contentId = -1;

    public static EncodingParams toParam(int n) {
        ExternalByteArrayEncoding externalByteArrayEncoding = new ExternalByteArrayEncoding();
        externalByteArrayEncoding.contentId = n;
        return new EncodingParams(encodingId, externalByteArrayEncoding.toByteArray());
    }

    @Override
    public byte[] toByteArray() {
        return ByteBufferUtils.writeUnsignedITF8(this.contentId);
    }

    @Override
    public void fromByteArray(byte[] byArray) {
        this.contentId = ByteBufferUtils.readUnsignedITF8(byArray);
    }

    @Override
    public BitCodec<byte[]> buildCodec(Map<Integer, InputStream> map, Map<Integer, ExposedByteArrayOutputStream> map2) {
        InputStream inputStream = map == null ? null : map.get(this.contentId);
        ExposedByteArrayOutputStream exposedByteArrayOutputStream = map2 == null ? null : map2.get(this.contentId);
        return new ExternalByteArrayCodec(exposedByteArrayOutputStream, inputStream);
    }

    @Override
    public EncodingID id() {
        return encodingId;
    }
}

