/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding;

import htsjdk.samtools.cram.encoding.BitCodec;
import htsjdk.samtools.cram.encoding.Encoding;
import htsjdk.samtools.cram.encoding.GolombIntegerCodec;
import htsjdk.samtools.cram.io.ByteBufferUtils;
import htsjdk.samtools.cram.io.ExposedByteArrayOutputStream;
import htsjdk.samtools.cram.structure.EncodingID;
import htsjdk.samtools.cram.structure.EncodingParams;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Map;

public class GolombIntegerEncoding
implements Encoding<Integer> {
    public static final EncodingID ENCODING_ID = EncodingID.GOLOMB;
    private int m;
    private int offset;

    public GolombIntegerEncoding() {
    }

    public GolombIntegerEncoding(int n) {
        this.m = n;
        this.offset = 0;
    }

    @Override
    public EncodingID id() {
        return ENCODING_ID;
    }

    public static EncodingParams toParam(int n) {
        GolombIntegerEncoding golombIntegerEncoding = new GolombIntegerEncoding();
        golombIntegerEncoding.m = n;
        golombIntegerEncoding.offset = 0;
        return new EncodingParams(ENCODING_ID, golombIntegerEncoding.toByteArray());
    }

    public static EncodingParams toParam(int n, int n2) {
        GolombIntegerEncoding golombIntegerEncoding = new GolombIntegerEncoding();
        golombIntegerEncoding.m = n;
        golombIntegerEncoding.offset = n2;
        return new EncodingParams(ENCODING_ID, golombIntegerEncoding.toByteArray());
    }

    @Override
    public byte[] toByteArray() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(10);
        ByteBufferUtils.writeUnsignedITF8(this.offset, byteBuffer);
        ByteBufferUtils.writeUnsignedITF8(this.m, byteBuffer);
        byteBuffer.flip();
        byte[] byArray = new byte[byteBuffer.limit()];
        byteBuffer.get(byArray);
        return byArray;
    }

    @Override
    public void fromByteArray(byte[] byArray) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        this.offset = ByteBufferUtils.readUnsignedITF8(byteBuffer);
        this.m = ByteBufferUtils.readUnsignedITF8(byteBuffer);
    }

    @Override
    public BitCodec<Integer> buildCodec(Map<Integer, InputStream> map, Map<Integer, ExposedByteArrayOutputStream> map2) {
        return new GolombIntegerCodec(this.m, true, this.offset);
    }
}

