/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding;

import htsjdk.samtools.cram.encoding.BitCodec;
import htsjdk.samtools.cram.encoding.Encoding;
import htsjdk.samtools.cram.encoding.GolombLongCodec;
import htsjdk.samtools.cram.io.ByteBufferUtils;
import htsjdk.samtools.cram.io.ExposedByteArrayOutputStream;
import htsjdk.samtools.cram.structure.EncodingID;
import htsjdk.samtools.cram.structure.EncodingParams;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Map;

public class GolombLongEncoding
implements Encoding<Long> {
    public static final EncodingID ENCODING_ID = EncodingID.GOLOMB;
    private int m;
    private int offset;

    @Override
    public EncodingID id() {
        return ENCODING_ID;
    }

    public static EncodingParams toParam(int n, int n2) {
        GolombLongEncoding golombLongEncoding = new GolombLongEncoding();
        golombLongEncoding.offset = n;
        golombLongEncoding.m = n2;
        return new EncodingParams(ENCODING_ID, golombLongEncoding.toByteArray());
    }

    @Override
    public byte[] toByteArray() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(10);
        ByteBufferUtils.writeUnsignedITF8(this.offset, byteBuffer);
        ByteBufferUtils.writeUnsignedITF8(this.m, byteBuffer);
        byteBuffer.flip();
        byte[] byArray = new byte[byteBuffer.limit()];
        byteBuffer.get(byArray);
        return byArray;
    }

    @Override
    public void fromByteArray(byte[] byArray) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        this.offset = ByteBufferUtils.readUnsignedITF8(byteBuffer);
        this.m = ByteBufferUtils.readUnsignedITF8(byteBuffer);
    }

    @Override
    public BitCodec<Long> buildCodec(Map<Integer, InputStream> map, Map<Integer, ExposedByteArrayOutputStream> map2) {
        return new GolombLongCodec(this.offset, this.m, true);
    }
}

