/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding;

import htsjdk.samtools.cram.encoding.AbstractBitCodec;
import htsjdk.samtools.cram.io.BitInputStream;
import htsjdk.samtools.cram.io.BitOutputStream;
import java.io.IOException;

public class SubexpIntegerCodec
extends AbstractBitCodec<Integer> {
    private int offset = 0;
    private int k = 2;
    private boolean unaryBit = true;

    public SubexpIntegerCodec(int n, int n2) {
        this(n, n2, true);
    }

    public SubexpIntegerCodec(int n, int n2, boolean bl) {
        this.offset = n;
        this.k = n2;
        this.unaryBit = bl;
    }

    public SubexpIntegerCodec(int n) {
        this.k = n;
    }

    @Override
    public final Integer read(BitInputStream bitInputStream) throws IOException {
        int n = 0;
        while (bitInputStream.readBit() == this.unaryBit) {
            ++n;
        }
        int n2 = 0;
        int n3 = 0;
        if (n == 0) {
            n2 = this.k;
            n3 = bitInputStream.readBits(n2);
        } else {
            n2 = n + this.k - 1;
            n3 = 1 << n2 | bitInputStream.readBits(n2);
        }
        return n3 - this.offset;
    }

    @Override
    public final long write(BitOutputStream bitOutputStream, Integer n) throws IOException {
        if (n + this.offset < 0) {
            throw new IllegalArgumentException("Value is less then offset: " + n);
        }
        long l = n + this.offset;
        int n2 = 0;
        int n3 = 0;
        if (l < 1L << this.k) {
            n2 = this.k;
            n3 = 0;
        } else {
            n2 = (int)(Math.log(l) / Math.log(2.0));
            n3 = n2 - this.k + 1;
        }
        bitOutputStream.write(this.unaryBit, (long)n3);
        bitOutputStream.write(!this.unaryBit);
        bitOutputStream.write(l, n2);
        return n3 + 1 + n2;
    }

    @Override
    public final long numberOfBits(Integer n) {
        long l = n + this.offset;
        long l2 = 0L;
        long l3 = 0L;
        if (l < 1L << this.k) {
            l2 = this.k;
            l3 = 0L;
        } else {
            l2 = (long)Math.floor(Math.log(l) / Math.log(2.0));
            l3 = l2 - (long)this.k + 1L;
        }
        return l3 + 1L + l2;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int n) {
        this.offset = n;
    }

    public int getK() {
        return this.k;
    }

    public void setK(int n) {
        this.k = n;
    }

    public boolean isUnaryBit() {
        return this.unaryBit;
    }

    public void setUnaryBit(boolean bl) {
        this.unaryBit = bl;
    }

    @Override
    public Integer read(BitInputStream bitInputStream, int n) throws IOException {
        throw new RuntimeException("Not implemented.");
    }
}

