/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding;

import htsjdk.samtools.cram.encoding.BitCodec;
import htsjdk.samtools.cram.encoding.Encoding;
import htsjdk.samtools.cram.encoding.SubexpIntegerCodec;
import htsjdk.samtools.cram.io.ByteBufferUtils;
import htsjdk.samtools.cram.io.ExposedByteArrayOutputStream;
import htsjdk.samtools.cram.structure.EncodingID;
import htsjdk.samtools.cram.structure.EncodingParams;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Map;

public class SubexpIntegerEncoding
implements Encoding<Integer> {
    public static final EncodingID ENCODING_ID = EncodingID.SUBEXP;
    private int offset;
    private int k;

    public SubexpIntegerEncoding() {
    }

    public SubexpIntegerEncoding(int n) {
        this(0, n);
    }

    public SubexpIntegerEncoding(int n, int n2) {
        this.offset = n;
        this.k = n2;
    }

    @Override
    public EncodingID id() {
        return ENCODING_ID;
    }

    public static EncodingParams toParam(int n, int n2) {
        SubexpIntegerEncoding subexpIntegerEncoding = new SubexpIntegerEncoding();
        subexpIntegerEncoding.offset = n;
        subexpIntegerEncoding.k = n2;
        return new EncodingParams(ENCODING_ID, subexpIntegerEncoding.toByteArray());
    }

    @Override
    public byte[] toByteArray() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(10);
        ByteBufferUtils.writeUnsignedITF8(this.offset, byteBuffer);
        ByteBufferUtils.writeUnsignedITF8(this.k, byteBuffer);
        byteBuffer.flip();
        byte[] byArray = new byte[byteBuffer.limit()];
        byteBuffer.get(byArray);
        return byArray;
    }

    @Override
    public void fromByteArray(byte[] byArray) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        this.offset = ByteBufferUtils.readUnsignedITF8(byteBuffer);
        this.k = ByteBufferUtils.readUnsignedITF8(byteBuffer);
    }

    @Override
    public BitCodec<Integer> buildCodec(Map<Integer, InputStream> map, Map<Integer, ExposedByteArrayOutputStream> map2) {
        return new SubexpIntegerCodec(this.offset, this.k);
    }
}

