/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding.huffint;

import htsjdk.samtools.cram.encoding.huffint.HuffmanBitCode;
import htsjdk.samtools.cram.io.BitInputStream;
import htsjdk.samtools.cram.io.BitOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

class Helper {
    TreeMap<Integer, HuffmanBitCode> codes;
    int[] values;
    int[] bitLengths;
    private TreeMap<Integer, SortedSet<Integer>> codebook;
    final HuffmanBitCode[] sortedCodes;
    final HuffmanBitCode[] sortedByValue;
    final int[] sortedValues;
    final int[] sortedBitCodes;
    final int[] sortedValuesByBitCode;
    final int[] sortedBitLensByBitCode;
    final int[] bitCodeToValue;
    private HuffmanBitCode searchCode = new HuffmanBitCode();
    static Comparator<HuffmanBitCode> bitCodeComparator = new Comparator<HuffmanBitCode>(){

        @Override
        public int compare(HuffmanBitCode huffmanBitCode, HuffmanBitCode huffmanBitCode2) {
            int n = huffmanBitCode.bitLentgh - huffmanBitCode2.bitLentgh;
            if (n == 0) {
                return huffmanBitCode.bitCode - huffmanBitCode2.bitCode;
            }
            return n;
        }
    };
    static Comparator<HuffmanBitCode> valueComparator = new Comparator<HuffmanBitCode>(){

        @Override
        public int compare(HuffmanBitCode huffmanBitCode, HuffmanBitCode huffmanBitCode2) {
            return huffmanBitCode.value - huffmanBitCode2.value;
        }
    };

    Helper(int[] nArray, int[] nArray2) {
        int n;
        this.values = nArray;
        this.bitLengths = nArray2;
        this.buildCodeBook();
        this.buildCodes();
        ArrayList<HuffmanBitCode> arrayList = new ArrayList<HuffmanBitCode>(this.codes.size());
        arrayList.addAll(this.codes.values());
        Collections.sort(arrayList, bitCodeComparator);
        this.sortedCodes = arrayList.toArray(new HuffmanBitCode[arrayList.size()]);
        this.sortedValues = Arrays.copyOf(nArray, nArray.length);
        Arrays.sort(this.sortedValues);
        int n2 = 0;
        this.sortedByValue = new HuffmanBitCode[this.sortedValues.length];
        for (int n3 : this.sortedValues) {
            this.sortedByValue[n2++] = this.codes.get(n3);
        }
        this.sortedBitCodes = new int[this.sortedCodes.length];
        this.sortedValuesByBitCode = new int[this.sortedCodes.length];
        this.sortedBitLensByBitCode = new int[this.sortedCodes.length];
        n2 = 0;
        for (n = 0; n < this.sortedBitCodes.length; ++n) {
            this.sortedBitCodes[n] = this.sortedCodes[n].bitCode;
            this.sortedValuesByBitCode[n] = this.sortedCodes[n].value;
            this.sortedBitLensByBitCode[n] = this.sortedCodes[n].bitLentgh;
            if (n2 >= this.sortedCodes[n].bitCode) continue;
            n2 = this.sortedCodes[n].bitCode;
        }
        this.bitCodeToValue = new int[n2 + 1];
        Arrays.fill(this.bitCodeToValue, -1);
        for (n = 0; n < this.sortedBitCodes.length; ++n) {
            this.bitCodeToValue[this.sortedCodes[n].bitCode] = n;
        }
    }

    private void buildCodeBook() {
        this.codebook = new TreeMap();
        for (int i = 0; i < this.values.length; ++i) {
            if (this.codebook.containsKey(this.bitLengths[i])) {
                ((TreeSet)this.codebook.get(this.bitLengths[i])).add(this.values[i]);
                continue;
            }
            TreeSet<Integer> treeSet = new TreeSet<Integer>();
            treeSet.add(this.values[i]);
            this.codebook.put(this.bitLengths[i], treeSet);
        }
    }

    private void buildCodes() {
        this.codes = new TreeMap();
        Set<Integer> set = this.codebook.keySet();
        int n = 0;
        int n2 = -1;
        for (Integer n3 : set) {
            int n4 = Integer.parseInt(((Object)n3).toString());
            TreeSet treeSet = (TreeSet)this.codebook.get(n3);
            for (Integer n5 : treeSet) {
                HuffmanBitCode huffmanBitCode = new HuffmanBitCode();
                huffmanBitCode.bitLentgh = n4;
                huffmanBitCode.value = n5;
                ++n2;
                int n6 = n4 - n;
                huffmanBitCode.bitCode = n2 <<= n6;
                n += n6;
                if (Helper.NumberOfSetBits(n2) > n4) {
                    throw new IllegalArgumentException("Symbol out of range");
                }
                this.codes.put(n5, huffmanBitCode);
            }
        }
    }

    final long write(BitOutputStream bitOutputStream, int n) throws IOException {
        int n2 = Arrays.binarySearch(this.sortedValues, n);
        HuffmanBitCode huffmanBitCode = this.sortedByValue[n2];
        if (huffmanBitCode.value != n) {
            throw new RuntimeException(String.format("Searching for %d but found %s.", n, huffmanBitCode.toString()));
        }
        bitOutputStream.write(huffmanBitCode.bitCode, huffmanBitCode.bitLentgh);
        return huffmanBitCode.bitLentgh;
    }

    final int read(BitInputStream bitInputStream) throws IOException {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.sortedCodes.length; ++i) {
            int n3 = this.sortedCodes[i].bitLentgh;
            n2 <<= n3 - n;
            n = n3;
            int n4 = this.bitCodeToValue[n2 |= bitInputStream.readBits(n3 - n)];
            if (n4 > -1 && this.sortedBitLensByBitCode[n4] == n3) {
                return this.sortedValuesByBitCode[n4];
            }
            for (int j = i; this.sortedCodes[j + 1].bitLentgh == n3 && j < this.sortedCodes.length; ++j) {
                ++i;
            }
        }
        throw new RuntimeException("Not found.");
    }

    private static int NumberOfSetBits(int n) {
        n -= n >> 1 & 0x55555555;
        n = (n & 0x33333333) + (n >> 2 & 0x33333333);
        return (n + (n >> 4) & 0xF0F0F0F) * 0x1010101 >> 24;
    }
}

