/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding.huffman;

import htsjdk.samtools.cram.encoding.huffman.HuffmanLeaf;
import htsjdk.samtools.cram.encoding.huffman.HuffmanNode;
import htsjdk.samtools.cram.encoding.huffman.HuffmanTree;
import java.io.PrintStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.TreeMap;

public class HuffmanCode {
    @Deprecated
    public static <T> HuffmanTree<T> buildTreeUsingPriorityQueue(int[] nArray, T[] TArray) {
        PriorityQueue<HuffmanTree> priorityQueue = new PriorityQueue<HuffmanTree>();
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] <= 0) continue;
            priorityQueue.offer(new HuffmanLeaf<T>(nArray[i], TArray[i]));
        }
        while (priorityQueue.size() > 1) {
            HuffmanTree huffmanTree = (HuffmanTree)priorityQueue.poll();
            HuffmanTree huffmanTree2 = (HuffmanTree)priorityQueue.poll();
            priorityQueue.offer(new HuffmanNode(huffmanTree, huffmanTree2));
        }
        return (HuffmanTree)priorityQueue.poll();
    }

    public static <T> HuffmanTree<T> buildTree(int[] nArray, T[] TArray) {
        LinkedList<HuffmanTree> linkedList = new LinkedList<HuffmanTree>();
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] <= 0) continue;
            linkedList.add(new HuffmanLeaf<T>(nArray[i], TArray[i]));
        }
        Comparator comparator = new Comparator<HuffmanTree<T>>(){

            @Override
            public int compare(HuffmanTree<T> huffmanTree, HuffmanTree<T> huffmanTree2) {
                return huffmanTree.frequency - huffmanTree2.frequency;
            }
        };
        while (linkedList.size() > 1) {
            Collections.sort(linkedList, comparator);
            HuffmanTree huffmanTree = (HuffmanTree)linkedList.remove();
            HuffmanTree huffmanTree2 = (HuffmanTree)linkedList.remove();
            linkedList.add(new HuffmanNode(huffmanTree, huffmanTree2));
        }
        return linkedList.isEmpty() ? null : (HuffmanTree)linkedList.remove();
    }

    public static <T> void getValuesAndBitLengths(List<T> list, List<Integer> list2, HuffmanTree<T> huffmanTree) {
        TreeMap treeMap = new TreeMap();
        HuffmanCode.getBitCode(huffmanTree, new HuffmanBitCode(), treeMap);
        for (Object k : treeMap.keySet()) {
            HuffmanBitCode huffmanBitCode = (HuffmanBitCode)treeMap.get(k);
            list.add(k);
            list2.add(huffmanBitCode.bitLentgh);
        }
    }

    public static void printTree(HuffmanTree<?> huffmanTree, StringBuffer stringBuffer, PrintStream printStream) {
        if (huffmanTree instanceof HuffmanLeaf) {
            HuffmanLeaf huffmanLeaf = (HuffmanLeaf)huffmanTree;
            printStream.println(huffmanLeaf.value + "\t" + huffmanLeaf.frequency + "\t" + stringBuffer);
        } else if (huffmanTree instanceof HuffmanNode) {
            HuffmanNode huffmanNode = (HuffmanNode)huffmanTree;
            stringBuffer.append('0');
            HuffmanCode.printTree(huffmanNode.left, stringBuffer, printStream);
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
            stringBuffer.append('1');
            HuffmanCode.printTree(huffmanNode.right, stringBuffer, printStream);
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        }
    }

    public static <T> boolean equal(HuffmanTree<T> huffmanTree, HuffmanTree<T> huffmanTree2) {
        if (huffmanTree.compareTo(huffmanTree2) != 0) {
            return false;
        }
        if (huffmanTree instanceof HuffmanLeaf && huffmanTree2 instanceof HuffmanLeaf) {
            Object t = ((HuffmanLeaf)huffmanTree).value;
            Object t2 = ((HuffmanLeaf)huffmanTree2).value;
            if (t == null && t2 == null) {
                return true;
            }
            return t != null && t.equals(t2);
        }
        if (huffmanTree instanceof HuffmanNode && huffmanTree2 instanceof HuffmanNode) {
            HuffmanNode huffmanNode = (HuffmanNode)huffmanTree;
            HuffmanNode huffmanNode2 = (HuffmanNode)huffmanTree2;
            if (!HuffmanCode.equal(huffmanNode.left, huffmanNode2.left)) {
                return false;
            }
            return HuffmanCode.equal(huffmanNode.right, huffmanNode2.right);
        }
        return false;
    }

    private static <T> void getBitCode(HuffmanTree<T> huffmanTree, HuffmanBitCode<T> huffmanBitCode, Map<T, HuffmanBitCode<T>> map) {
        if (huffmanTree instanceof HuffmanLeaf) {
            HuffmanLeaf huffmanLeaf = (HuffmanLeaf)huffmanTree;
            HuffmanBitCode huffmanBitCode2 = new HuffmanBitCode();
            huffmanBitCode2.bitCode = huffmanBitCode.bitCode;
            huffmanBitCode2.bitLentgh = huffmanBitCode.bitLentgh;
            map.put(huffmanLeaf.value, huffmanBitCode2);
            return;
        }
        if (huffmanTree instanceof HuffmanNode) {
            HuffmanNode huffmanNode = (HuffmanNode)huffmanTree;
            huffmanBitCode.bitCode <<= 1;
            ++huffmanBitCode.bitLentgh;
            HuffmanCode.getBitCode(huffmanNode.left, huffmanBitCode, map);
            huffmanBitCode.bitCode >>>= 1;
            --huffmanBitCode.bitLentgh;
            huffmanBitCode.bitCode = huffmanBitCode.bitCode << 1 | 1L;
            ++huffmanBitCode.bitLentgh;
            HuffmanCode.getBitCode(huffmanNode.right, huffmanBitCode, map);
            huffmanBitCode.bitCode >>>= 1;
            --huffmanBitCode.bitLentgh;
        }
    }

    private static class HuffmanBitCode<T> {
        long bitCode;
        int bitLentgh;
        T value;

        private HuffmanBitCode() {
        }
    }
}

