/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding.reader;

import htsjdk.samtools.cram.encoding.read_features.BaseQualityScore;
import htsjdk.samtools.cram.encoding.read_features.Deletion;
import htsjdk.samtools.cram.encoding.read_features.HardClip;
import htsjdk.samtools.cram.encoding.read_features.InsertBase;
import htsjdk.samtools.cram.encoding.read_features.Insertion;
import htsjdk.samtools.cram.encoding.read_features.Padding;
import htsjdk.samtools.cram.encoding.read_features.ReadBase;
import htsjdk.samtools.cram.encoding.read_features.ReadFeature;
import htsjdk.samtools.cram.encoding.read_features.RefSkip;
import htsjdk.samtools.cram.encoding.read_features.SoftClip;
import htsjdk.samtools.cram.encoding.read_features.Substitution;
import htsjdk.samtools.cram.encoding.reader.AbstractReader;
import htsjdk.samtools.cram.encoding.reader.DataReader;
import htsjdk.samtools.cram.structure.CramCompressionRecord;
import htsjdk.samtools.cram.structure.ReadTag;
import java.io.IOException;
import java.util.LinkedList;

public class CramRecordReader
extends AbstractReader {
    private CramCompressionRecord prevRecord;

    public void read(CramCompressionRecord cramCompressionRecord) throws IOException {
        try {
            Object object;
            int n;
            int n2;
            cramCompressionRecord.flags = (Integer)this.bitFlagsC.readData();
            cramCompressionRecord.compressionFlags = ((Byte)this.compBitFlagsC.readData()).byteValue();
            cramCompressionRecord.sequenceId = this.refId == -2 ? (Integer)this.refIdCodec.readData() : this.refId;
            cramCompressionRecord.readLength = (Integer)this.readLengthC.readData();
            if (this.AP_delta) {
                cramCompressionRecord.alignmentDelta = (Integer)this.alStartC.readData();
            } else {
                cramCompressionRecord.alignmentStart = (Integer)this.alStartC.readData();
            }
            cramCompressionRecord.readGroupID = (Integer)this.readGroupC.readData();
            if (this.captureReadNames) {
                cramCompressionRecord.readName = new String((byte[])this.readNameC.readData(), this.charset);
            }
            if (cramCompressionRecord.isDetached()) {
                cramCompressionRecord.mateFlags = ((Byte)this.mbfc.readData()).byteValue();
                if (!this.captureReadNames) {
                    cramCompressionRecord.readName = new String((byte[])this.readNameC.readData(), this.charset);
                }
                cramCompressionRecord.mateSequenceID = (Integer)this.mrc.readData();
                cramCompressionRecord.mateAlignmentStart = (Integer)this.malsc.readData();
                cramCompressionRecord.templateSize = (Integer)this.tsc.readData();
                ++detachedCount;
            } else if (cramCompressionRecord.isHasMateDownStream()) {
                cramCompressionRecord.recordsToNextFragment = (Integer)this.distanceC.readData();
            }
            Integer n3 = (Integer)this.tagIdListCodec.readData();
            byte[][] byArray = this.tagIdDictionary[n3];
            if (byArray.length > 0) {
                n2 = byArray.length;
                cramCompressionRecord.tags = new ReadTag[n2];
                for (n = 0; n < byArray.length; ++n) {
                    ReadTag readTag;
                    int n4 = ReadTag.name3BytesToInt(byArray[n]);
                    DataReader dataReader = (DataReader)this.tagValueCodecs.get(n4);
                    object = null;
                    object = (byte[])dataReader.readData();
                    cramCompressionRecord.tags[n] = readTag = new ReadTag(n4, (byte[])object);
                }
            }
            if (!cramCompressionRecord.isSegmentUnmapped()) {
                n2 = (Integer)this.nfc.readData();
                n = 0;
                LinkedList<ReadFeature> linkedList = new LinkedList<ReadFeature>();
                cramCompressionRecord.readFeatures = linkedList;
                block17: for (int i = 0; i < n2; ++i) {
                    int n5;
                    object = (Byte)this.fc.readData();
                    n = n5 = n + (Integer)this.fp.readData();
                    switch ((Byte)object) {
                        case 66: {
                            ReadBase readBase = new ReadBase(n5, (Byte)this.bc.readData(), (Byte)this.qc.readData());
                            linkedList.add(readBase);
                            continue block17;
                        }
                        case 88: {
                            Substitution substitution = new Substitution();
                            substitution.setPosition(n5);
                            byte by = (Byte)this.bsc.readData();
                            substitution.setCode(by);
                            linkedList.add(substitution);
                            continue block17;
                        }
                        case 73: {
                            Insertion insertion = new Insertion(n5, (byte[])this.inc.readData());
                            linkedList.add(insertion);
                            continue block17;
                        }
                        case 83: {
                            SoftClip softClip = new SoftClip(n5, (byte[])this.softClipCodec.readData());
                            linkedList.add(softClip);
                            continue block17;
                        }
                        case 72: {
                            HardClip hardClip = new HardClip(n5, (Integer)this.hardClipCodec.readData());
                            linkedList.add(hardClip);
                            continue block17;
                        }
                        case 80: {
                            Padding padding = new Padding(n5, (Integer)this.dlc.readData());
                            linkedList.add(padding);
                            continue block17;
                        }
                        case 68: {
                            Deletion deletion = new Deletion(n5, (Integer)this.dlc.readData());
                            linkedList.add(deletion);
                            continue block17;
                        }
                        case 78: {
                            RefSkip refSkip = new RefSkip(n5, (Integer)this.refSkipCodec.readData());
                            linkedList.add(refSkip);
                            continue block17;
                        }
                        case 105: {
                            InsertBase insertBase = new InsertBase(n5, (Byte)this.bc.readData());
                            linkedList.add(insertBase);
                            continue block17;
                        }
                        case 81: {
                            BaseQualityScore baseQualityScore = new BaseQualityScore(n5, (Byte)this.qc.readData());
                            linkedList.add(baseQualityScore);
                            continue block17;
                        }
                        default: {
                            throw new RuntimeException("Unknown read feature operator: " + object);
                        }
                    }
                }
                cramCompressionRecord.mappingQuality = (Integer)this.mqc.readData();
                if (cramCompressionRecord.isForcePreserveQualityScores()) {
                    byte[] byArray2 = (byte[])this.qcArray.readDataArray(cramCompressionRecord.readLength);
                    cramCompressionRecord.qualityScores = byArray2;
                }
            } else {
                byte[] byArray3 = new byte[cramCompressionRecord.readLength];
                for (n = 0; n < byArray3.length; ++n) {
                    byArray3[n] = (Byte)this.bc.readData();
                }
                cramCompressionRecord.readBases = byArray3;
                if (cramCompressionRecord.isForcePreserveQualityScores()) {
                    byte[] byArray4 = (byte[])this.qcArray.readDataArray(cramCompressionRecord.readLength);
                    cramCompressionRecord.qualityScores = byArray4;
                }
            }
            ++this.recordCounter;
            this.prevRecord = cramCompressionRecord;
        }
        catch (Exception exception) {
            if (this.prevRecord != null) {
                System.err.printf("Failed at record %d. Here is the previously read record: %s\n", this.recordCounter, this.prevRecord.toString());
            }
            throw new RuntimeException(exception);
        }
    }
}

